/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.actions.Messages;
import com.perforce.team.ui.editor.CompareUtils;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;

public abstract class DiffAction
extends P4Action {
    private static final int MAX_DIFF_CHECK = 5;

    @Override
    public boolean isEnabledEx() {
        P4Collection collection;
        IP4Resource[] resources;
        int size;
        boolean enabled = this.containsOnlineConnection();
        if (enabled && !(enabled = this.containsContainers()) && (size = (resources = (collection = super.getResourceSelection()).members()).length) > 0) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File) {
                    IP4File file = (IP4File)resource;
                    if (file.getHeadRevision() > 0) {
                        enabled = true;
                        break;
                    }
                } else {
                    enabled = true;
                    break;
                }
                ++n2;
            }
        }
        return enabled;
    }

    protected abstract InputStream getCompareStream(IP4File var1);

    protected abstract String getCompareString(IP4File var1);

    protected abstract String getEditorTitle(IP4File var1);

    @Override
    public void runAction() {
        boolean doDiff = true;
        P4Collection collection = this.getFileSelection();
        ArrayList<IP4File> files = new ArrayList<IP4File>();
        ArrayList<IFile> localFiles = new ArrayList<IFile>();
        IP4Resource[] iP4ResourceArray = collection.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File) {
                IFile[] p4LocalFiles;
                IP4File file = (IP4File)resource;
                files.add(file);
                IFile[] iFileArray = p4LocalFiles = file.getLocalFiles();
                int n3 = p4LocalFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFile localFile = iFileArray[n4];
                    localFiles.add(localFile);
                    ++n4;
                }
            }
            ++n2;
        }
        if (files.size() > 5) {
            doDiff = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.DiffDepotAction_DIALOGTITLE, (String)NLS.bind((String)Messages.DiffDepotAction_M, (Object)files.size()));
        }
        if (doDiff) {
            PerforceUIPlugin.saveDirtyResources(this.getTargetPage(), localFiles.toArray(new IFile[0]));
            for (IP4File file : files) {
                try {
                    File depotFile = P4CoreUtils.createFile((InputStream)this.getCompareStream(file));
                    if (depotFile == null) continue;
                    String editorTitle = NLS.bind((String)this.getEditorTitle(file), (Object)file.getName());
                    String compareSide = this.getCompareString(file);
                    IFile localFile = file.getLocalFileForLocation();
                    if (localFile == null) {
                        CompareUtils.openLocalCompare(new File(file.getLocalPath()), depotFile, Messages.DiffDepotAction_DIFF4, compareSide, editorTitle);
                        continue;
                    }
                    CompareUtils.openLocalCompare(localFile, depotFile, Messages.DiffDepotAction_DIFF2, compareSide, editorTitle);
                }
                catch (Exception e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
                catch (Error e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
            }
        }
    }
}

