/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.p4java.option.Options;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4FileIntegration;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.ui.p4java.actions.AbstractStreamAction;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.dialogs.IntegrateToStreamDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractStreamIntegAction
extends AbstractStreamAction {
    protected abstract IntegrateToStreamDialog createIntegrateDialog(Shell var1, IP4Resource var2);

    protected abstract IP4Resource[] doIntegrate(IP4Connection var1, P4FileIntegration var2, Options var3, String var4);

    @Override
    public boolean isEnabledEx() {
        return super.isEnabledEx() && (this.isSelectionInClientStream() || this.isDiffStreamDiffClientSwitch() || this.isConnectedToSandBox());
    }

    @Override
    protected void doRun(final IP4Resource resource) {
        if (!this.switchStreams(resource, true)) {
            return;
        }
        IntegrateToStreamDialog dialog = this.createIntegrateDialog(this.getShell(), resource);
        if (dialog.open() == 0) {
            final IP4Connection connection = resource.getConnection();
            final P4FileIntegration integration = dialog.getFileIntegration();
            final Options options = dialog.getOptions();
            final String desc = dialog.getChangeListDescription();
            P4Runnable runnable = new P4Runnable(){

                public void run(IProgressMonitor monitor) {
                    IP4Resource[] integrated = AbstractStreamIntegAction.this.doIntegrate(connection, integration, options, desc);
                    if (integrated != null && integrated.length > 0) {
                        P4Collection collection = AbstractStreamIntegAction.this.createCollection(integrated);
                        collection.refreshLocalResources(2);
                        resource.refresh();
                    }
                }

                public String getTitle() {
                    return Messages.IntegrateAction_IntegratingFiles;
                }
            };
            this.runRunnable((IP4Runnable)runnable);
        }
    }
}

