/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.p4java.actions;

import com.perforce.p4java.client.IClient;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4TeamUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.SwitchStreamDialog;
import com.perforce.team.ui.p4java.actions.Messages;
import com.perforce.team.ui.p4java.actions.P4Action;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;

public abstract class AbstractStreamAction
extends P4Action {
    @Override
    public boolean isEnabledEx() {
        return this.isStreamConnection();
    }

    private boolean isStreamConnection() {
        IP4Resource resource;
        IP4Connection conn;
        IP4Resource[] resources;
        if (this.containsOnlineConnection() && (resources = this.getResourceSelection().members()).length == 1 && resources[0] != null && (conn = (resource = resources[0]).getConnection()) != null && conn.getClient() != null) {
            return !StringUtils.isEmpty((CharSequence)conn.getClient().getStream());
        }
        return false;
    }

    @Override
    protected void runAction() {
        P4Collection collection = this.getResourceSelection();
        IP4Resource[] members = collection.members();
        if (members.length == 1) {
            this.doRun(members[0]);
        }
    }

    protected abstract void doRun(IP4Resource var1);

    protected boolean switchStreams(IP4Resource resource, boolean force) {
        if (AbstractStreamAction.isResourceInClientStream(resource)) {
            return true;
        }
        IP4Connection conn = resource.getConnection();
        String targetStream = this.getStreamFromResource(resource);
        String message = Messages.WorkinStreamAction_AboutToSwitchWorkspace;
        int code = SwitchStreamDialog.open(3, this.getShell(), Messages.WorkinStreamAction_SwitchStream, message, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, new int[]{2, 3}, 0);
        if (code == 2) {
            IClient c = conn.getClient();
            c.setStream(targetStream);
            conn.updateClient(c);
            conn.refreshClient();
            P4TeamUtils.processClientChange(conn, this.getShell(), force, MessageFormat.format(Messages.AbstractStreamAction_StreamSwitchedDesc, targetStream));
            conn.markForRefresh();
            P4ConnectionManager.getManager().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, (IP4Resource)conn));
            return true;
        }
        return false;
    }

    protected String getStreamFromResource(IP4Resource resource) {
        String ts = null;
        if (resource instanceof IP4Stream) {
            IP4Stream p4stream = (IP4Stream)resource;
            ts = p4stream.getStreamSummary().getStream();
        } else {
            ts = P4TeamUtils.getStream(resource);
        }
        return ts;
    }

    protected boolean isSelectionInClientStream() {
        IP4Resource[] resources = this.getResourceSelection().members();
        if (resources.length == 1 && resources[0] != null) {
            IP4Resource resource = resources[0];
            return AbstractStreamAction.isResourceInClientStream(resource);
        }
        return false;
    }

    protected static boolean isResourceInClientStream(IP4Resource resource) {
        String stream;
        IClient client;
        IP4Connection conn;
        if (resource.getConnection().isConnected() && (conn = resource.getConnection()) != null && (client = conn.getClient()) != null && (stream = client.getStream()) != null) {
            String resourceLocalPath;
            if (resource instanceof IP4Stream) {
                String s = ((IP4Stream)resource).getStreamSummary().getStream();
                return stream.equals(s);
            }
            String resourceRemotePath = resource.getRemotePath();
            if (resourceRemotePath != null ? resourceRemotePath.startsWith(stream) : (resourceLocalPath = resource.getLocalPath()) != null && resourceLocalPath.startsWith(client.getRoot())) {
                return true;
            }
        }
        return false;
    }

    protected boolean isConnectedToSandBox() {
        IP4Resource resource;
        IP4Connection conn;
        IP4Resource[] resources;
        if (this.containsOnlineConnection() && (resources = this.getResourceSelection().members()).length == 1 && resources[0] != null && (conn = (resource = resources[0]).getConnection()) != null) {
            return conn.isSandbox();
        }
        return false;
    }

    protected boolean isDiffStreamDiffClientSwitch() {
        IPreferenceStore store;
        String opt;
        IP4Resource[] resources;
        return this.containsOnlineConnection() && (resources = this.getResourceSelection().members()).length == 1 && resources[0] != null && "diffStreamDiffClient".equals(opt = (store = PerforceUIPlugin.getPlugin().getPreferenceStore()).getString("pref_client_switch_on_stream_option"));
    }
}

