/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.labels;

import com.perforce.p4java.core.ILabelMapping;
import com.perforce.p4java.core.ViewMap;
import com.perforce.team.core.p4java.IP4Label;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.labels.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LabelWidget {
    private Composite displayArea;
    private Text labelText;
    private Text accessText;
    private Text updateText;
    private Text ownerText;
    private Text descriptionText;
    private Text revisionText;
    private Button lockedButton;
    private Text viewText;

    public LabelWidget(Composite parent) {
        this(parent, 5, 5, true);
    }

    public LabelWidget(Composite parent, int marginWidth, int marginHeight, boolean editable) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(4, false);
        daLayout.marginHeight = marginHeight;
        daLayout.marginWidth = marginWidth;
        this.displayArea.setLayout((Layout)daLayout);
        GridData singleTextData = new GridData(4, 4, true, false);
        GridData multiTextData = new GridData(4, 4, true, true);
        multiTextData.horizontalSpan = 3;
        multiTextData.heightHint = 75;
        Label nameLabel = new Label(this.displayArea, 16384);
        nameLabel.setText(Messages.LabelWidget_Name);
        this.labelText = new Text(this.displayArea, 2052);
        this.labelText.setLayoutData((Object)singleTextData);
        Label accessLabel = new Label(this.displayArea, 16384);
        accessLabel.setText(Messages.LabelWidget_AccessTime);
        this.accessText = new Text(this.displayArea, 2052);
        this.accessText.setLayoutData((Object)singleTextData);
        Label updateLabel = new Label(this.displayArea, 16384);
        updateLabel.setText(Messages.LabelWidget_UpdateTime);
        this.updateText = new Text(this.displayArea, 2052);
        this.updateText.setLayoutData((Object)singleTextData);
        Label ownerLabel = new Label(this.displayArea, 16384);
        ownerLabel.setText(Messages.LabelWidget_Owner);
        this.ownerText = new Text(this.displayArea, 2052);
        this.ownerText.setLayoutData((Object)singleTextData);
        Label descriptionLabel = new Label(this.displayArea, 16384);
        descriptionLabel.setText(Messages.LabelWidget_Description);
        this.descriptionText = new Text(this.displayArea, 2114);
        this.descriptionText.setLayoutData((Object)multiTextData);
        Label optionsLabel = new Label(this.displayArea, 16384);
        optionsLabel.setText(Messages.LabelWidget_Options);
        this.lockedButton = new Button(this.displayArea, 32);
        this.lockedButton.setText(Messages.LabelWidget_Locked);
        GridData lbData = new GridData(1, 0x1000000, false, false);
        lbData.horizontalSpan = 3;
        this.lockedButton.setLayoutData((Object)lbData);
        Label revisionLabel = new Label(this.displayArea, 16384);
        revisionLabel.setText(Messages.LabelWidget_Revision);
        this.revisionText = new Text(this.displayArea, 2052);
        GridData rtData = new GridData(4, 4, true, false);
        rtData.horizontalSpan = 3;
        this.revisionText.setLayoutData((Object)rtData);
        Label viewLabel = new Label(this.displayArea, 16384);
        viewLabel.setText(Messages.LabelWidget_View);
        this.viewText = new Text(this.displayArea, 2114);
        this.viewText.setLayoutData((Object)multiTextData);
        this.setEditable(editable);
    }

    public void setEditable(boolean editable) {
        this.viewText.setEditable(editable);
        this.labelText.setEditable(editable);
        this.accessText.setEditable(editable);
        this.updateText.setEditable(editable);
        this.ownerText.setEditable(editable);
        this.descriptionText.setEditable(editable);
        this.revisionText.setEditable(editable);
        this.lockedButton.setEnabled(editable);
    }

    public void update(IP4Label label) {
        this.clear();
        if (label != null) {
            ViewMap view;
            String revision;
            String description;
            String name = label.getName();
            if (name != null) {
                this.labelText.setText(name);
            }
            this.accessText.setText(P4UIUtils.formatLabelDate(label.getAccessTime()));
            this.updateText.setText(P4UIUtils.formatLabelDate(label.getUpdateTime()));
            String owner = label.getOwner();
            if (owner != null) {
                this.ownerText.setText(owner);
            }
            if ((description = label.getDescription()) != null) {
                this.descriptionText.setText(description);
            }
            if ((revision = label.getRevision()) != null) {
                this.revisionText.setText(revision);
            }
            if ((view = label.getView()) != null) {
                StringBuilder builder = new StringBuilder();
                for (ILabelMapping mapping : view) {
                    builder.append(mapping.getViewMapping());
                    builder.append('\n');
                }
                this.viewText.setText(builder.toString());
            }
            this.lockedButton.setSelection(label.isLocked());
        }
    }

    public String getLabelName() {
        return this.labelText.getText();
    }

    public String getAccess() {
        return this.accessText.getText();
    }

    public String getUpdate() {
        return this.updateText.getText();
    }

    public String getView() {
        return this.viewText.getText();
    }

    public boolean isLocked() {
        return this.lockedButton.getSelection();
    }

    public String getRevision() {
        return this.revisionText.getText();
    }

    public String getDescription() {
        return this.descriptionText.getText();
    }

    public String getOwner() {
        return this.ownerText.getText();
    }

    public void clear() {
        String empty = "";
        this.viewText.setText(empty);
        this.labelText.setText(empty);
        this.accessText.setText(empty);
        this.updateText.setText(empty);
        this.ownerText.setText(empty);
        this.descriptionText.setText(empty);
        this.revisionText.setText(empty);
        this.lockedButton.setSelection(false);
    }

    public Composite getControl() {
        return this.displayArea;
    }
}

