/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.editor;

import com.perforce.team.ui.editor.P4CompareNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class P4FileNode
extends P4CompareNode {
    private File file;
    private String name = null;
    private String id = null;

    public P4FileNode(String filename, String label, String type, boolean editable, String name) {
        this(new File(filename), label, type, editable, name);
    }

    public P4FileNode(String filename, String label, String type, String name) {
        this(new File(filename), label, type, false, name);
    }

    public P4FileNode(File file, String label, String type, String name) {
        this(file, label, type, false, name);
    }

    public P4FileNode(File file, String label, String type, boolean editable, String name) {
        super(label, type);
        this.file = file;
        this.editable = editable;
        this.name = name;
    }

    public InputStream getContents() throws CoreException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    @Override
    public void commit(IProgressMonitor monitor) throws CoreException {
        this.isEditable();
    }

    public String getName() {
        return this.name != null ? this.name : this.file.getName();
    }

    public void setContentIdentifier(String id) {
        this.id = id;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof P4FileNode) {
            P4FileNode file2 = (P4FileNode)other;
            if (this.id != null && file2.id != null) {
                return this.id.equals(file2.id);
            }
            return super.equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.id != null) {
            return this.id.hashCode();
        }
        return super.hashCode();
    }
}

