/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.diff;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.diff.IFileDiffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;

public final class DiffRegistry {
    public static final String FILE_DIFF_EXTENSION_POINT = "com.perforce.team.ui.fileDiff";
    public static final String DIFF_ELEMENT = "diff";
    public static final String CONTENT_TYPE_ATTRIBUTE = "contentType";
    public static final String EXTENSION_ATTRIBUTE = "extension";
    public static final String CLASS_ATTRIBUTE = "class";
    private static DiffRegistry registry;
    private Map<String, IConfigurationElement> typeToDiffers = new HashMap<String, IConfigurationElement>();
    private Map<String, IConfigurationElement> extToDiffers = new HashMap<String, IConfigurationElement>();

    public static synchronized DiffRegistry getRegistry() {
        if (registry == null) {
            registry = new DiffRegistry();
        }
        return registry;
    }

    private DiffRegistry() {
        this.loadExtensionPoints();
    }

    public IFileDiffer getDiffer(IP4Resource resource) {
        IContentType type;
        String name;
        IFileDiffer differ = null;
        if (resource != null && (name = resource.getName()) != null && (type = Platform.getContentTypeManager().findContentTypeFor(name)) != null) {
            return this.getDiffer(type, true);
        }
        return differ;
    }

    public String[] getContentTypes() {
        Set<String> types = this.typeToDiffers.keySet();
        return types.toArray(new String[types.size()]);
    }

    public IFileDiffer getDifferByExtension(String extension) {
        IFileDiffer differ = null;
        if (extension != null) {
            try {
                IConfigurationElement element = this.extToDiffers.get(extension);
                if (element != null) {
                    differ = (IFileDiffer)element.createExecutableExtension(CLASS_ATTRIBUTE);
                }
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return differ;
    }

    public IFileDiffer getDiffer(IContentType contentType, boolean checkBaseType) {
        IFileDiffer differ = null;
        if (contentType != null) {
            try {
                IConfigurationElement element = this.typeToDiffers.get(contentType.getId());
                if (element != null) {
                    differ = (IFileDiffer)element.createExecutableExtension(CLASS_ATTRIBUTE);
                } else {
                    IContentType parent = contentType.getBaseType();
                    if (parent != null && !parent.equals(contentType)) {
                        differ = this.getDiffer(parent, true);
                    }
                }
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return differ;
    }

    public IFileDiffer getDiffer(String contentType) {
        if (contentType != null) {
            try {
                IConfigurationElement element = this.typeToDiffers.get(contentType);
                if (element != null) {
                    return (IFileDiffer)element.createExecutableExtension(CLASS_ATTRIBUTE);
                }
            }
            catch (CoreException e) {
                PerforceProviderPlugin.logError((Throwable)e);
            }
        }
        return null;
    }

    private void loadExtensionPoints() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(FILE_DIFF_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String diffClass;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (DIFF_ELEMENT.equals(element.getName()) && (diffClass = element.getAttribute(CLASS_ATTRIBUTE)) != null) {
                Object differ = null;
                try {
                    differ = element.createExecutableExtension(CLASS_ATTRIBUTE);
                }
                catch (CoreException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                }
                if (differ instanceof IFileDiffer) {
                    String extension;
                    String contentType = element.getAttribute(CONTENT_TYPE_ATTRIBUTE);
                    if (contentType != null) {
                        this.typeToDiffers.put(contentType, element);
                    }
                    if ((extension = element.getAttribute(EXTENSION_ATTRIBUTE)) != null) {
                        this.extToDiffers.put(extension, element);
                    }
                }
            }
            ++n2;
        }
    }
}

