/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.ui.PerforceUIPlugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class SwitchStreamDialog
extends MessageDialog {
    private int[] buttonIds;
    protected boolean toggleState;
    private String toggleMessage;
    private IPreferenceStore prefStore;
    private String prefKey;

    public int[] getButtonIds() {
        return this.buttonIds;
    }

    public boolean getToggleState() {
        return this.toggleState;
    }

    public SwitchStreamDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, String toggleMessage, int dialogImageType, String[] dialogButtonLabels, int[] buttonIds, int defaultIndex, IPreferenceStore store, String key) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.buttonIds = buttonIds;
        this.toggleMessage = toggleMessage;
        this.prefStore = store;
        this.prefKey = key;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        String[] labels = this.getButtonLabels();
        Button[] btns = new Button[labels.length];
        int i = 0;
        while (i < btns.length) {
            Button button;
            String label = labels[i];
            btns[i] = button = this.createButton(parent, this.buttonIds[i], label, this.getDefaultButtonIndex() == i);
            ++i;
        }
        this.setButtons(btns);
    }

    protected Control createCustomArea(Composite parent) {
        if (this.toggleMessage == null) {
            return null;
        }
        final Button button = new Button(parent, 16416);
        GridData data = new GridData(0);
        data.horizontalSpan = 2;
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SwitchStreamDialog.this.toggleState = button.getSelection();
                System.out.println(SwitchStreamDialog.this.toggleState);
                if (SwitchStreamDialog.this.prefStore != null) {
                    SwitchStreamDialog.this.prefStore.setValue(SwitchStreamDialog.this.prefKey, SwitchStreamDialog.this.toggleState);
                }
            }
        });
        button.setText(this.toggleMessage);
        return button;
    }

    public static int open(int kind, Shell parent, String title, String message, String[] buttonLabels, int[] buttonIds, int defaultIndex) {
        return SwitchStreamDialog.open(kind, parent, title, message, null, buttonLabels, buttonIds, defaultIndex);
    }

    public static int open(int kind, Shell parent, String title, String message, String toggleMessage, String[] buttonLabels, int[] buttonIds, int defaultIndex) {
        IPreferenceStore store = null;
        try {
            store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SwitchStreamDialog dialog = new SwitchStreamDialog(parent, title, null, message, toggleMessage, kind, buttonLabels, buttonIds, defaultIndex, store, "pref_client_switch_no_warn");
        return dialog.open();
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.open();
        int code = SwitchStreamDialog.open(1, shell, "Error", "This is an error", "Do not show again, please", new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, new int[]{2, 3}, 0);
        System.out.println(code);
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }
}

