/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.dialogs.DialogUtils;
import com.perforce.team.ui.dialogs.Messages;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class SwitchClientConfirmDialog
extends MessageDialog {
    public static final String SYNC_CLIENT_SECTION = "SyncClient";
    public static final String SYNC_KEY = "HOW_TO_SYNC";
    private Button noSyncButton;
    private Button syncButton;
    private Button noPromptButton;
    private String syncOpt;

    public SwitchClientConfirmDialog(Shell parentShell) {
        super(parentShell, Messages.SwitchClientDialog_Title, null, MessageFormat.format(Messages.SwitchClientDialog_Description, Messages.SwitchClientDialog_DefaultDescription), 5, new String[]{IDialogConstants.OK_LABEL}, 0);
    }

    public void setDescription(String desc) {
        this.message = MessageFormat.format(Messages.SwitchClientDialog_Description, desc);
    }

    protected Control createCustomArea(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        displayArea.setLayout((Layout)new GridLayout());
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.noSyncButton = DialogUtils.createRadio(displayArea, 0, Messages.SwitchClientDialog_NoSync);
        this.syncButton = DialogUtils.createRadio(displayArea, 0, Messages.SwitchClientDialog_Sync);
        this.noPromptButton = DialogUtils.createCheck(displayArea, Messages.SwitchClientDialog_NoPrompot);
        Link link = new Link(displayArea, 0);
        link.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        link.setText(Messages.SwitchClientDialog_ReactivatePromptTip);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)SwitchClientConfirmDialog.this.getShell(), (String)"com.perforce.team.ui.dialogs.ClientPreferencesDialog", null, (Object)"");
                dlg.open();
            }
        });
        this.loadDialogSettings();
        return displayArea;
    }

    private void loadDialogSettings() {
        IDialogSettings section;
        IDialogSettings settings = PerforceUIPlugin.getPlugin().getDialogSettings();
        String syncOpt = "always";
        if (settings != null && (section = settings.getSection(SYNC_CLIENT_SECTION)) != null) {
            syncOpt = section.get(SYNC_KEY);
        }
        if ("always".equals(syncOpt)) {
            this.syncButton.setSelection(true);
        } else {
            this.noSyncButton.setSelection(true);
        }
    }

    protected boolean customShouldTakeFocus() {
        return false;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.okPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    public void okPressed() {
        IPreferenceStore store = this.getPreferenceStore();
        if (this.syncButton.getSelection()) {
            this.syncOpt = "always";
        } else if (this.noSyncButton.getSelection()) {
            this.syncOpt = "never";
        }
        if (this.noPromptButton.getSelection()) {
            store.setValue("pref_client_switch_option", this.syncOpt);
        }
        this.saveDialogSettings();
        super.okPressed();
    }

    private void saveDialogSettings() {
        IDialogSettings settings = PerforceUIPlugin.getPlugin().getDialogSettings();
        if (settings != null) {
            IDialogSettings section = settings.getSection(SYNC_CLIENT_SECTION);
            if (section == null) {
                section = settings.addNewSection(SYNC_CLIENT_SECTION);
            }
            section.put(SYNC_KEY, this.syncOpt);
        }
    }

    public IPreferenceStore getPreferenceStore() {
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        return store;
    }

    public boolean isAutoSync() {
        return this.syncOpt.equals("always");
    }

    public void setAutoSync(boolean b) {
        this.syncButton.setSelection(b);
    }

    public void setNoPrompt(boolean b) {
        this.noPromptButton.setSelection(b);
    }
}

