/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import java.util.ResourceBundle;
import org.eclipse.compare.CompareUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class ResizableDialog
extends Dialog {
    private static final String DIALOG_BOUNDS_KEY = "ResizableDialogBounds";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    protected ResourceBundle fBundle;
    private Rectangle fNewBounds;
    private IDialogSettings fSettings;
    private String fContextId;

    public ResizableDialog(Shell parent, ResourceBundle bundle) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fBundle = bundle;
        this.fSettings = CompareUI.getPlugin().getDialogSettings();
    }

    public void setHelpContextId(String contextId) {
        this.fContextId = contextId;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.fContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, this.fContextId);
        }
    }

    protected Point getInitialSize() {
        IDialogSettings bounds;
        Point result = super.getInitialSize();
        final Shell s = this.getShell();
        if (s != null) {
            s.addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent arg0) {
                    ResizableDialog.this.fNewBounds = s.getBounds();
                }

                public void controlResized(ControlEvent arg0) {
                    ResizableDialog.this.fNewBounds = s.getBounds();
                }
            });
        }
        if ((bounds = this.fSettings.getSection(DIALOG_BOUNDS_KEY)) == null) {
            if (this.fBundle != null) {
                Shell shell = this.getParentShell();
                if (shell != null) {
                    Point parentSize = shell.getSize();
                    if (result.x <= 0) {
                        result.x = parentSize.x - 300;
                    }
                    if (result.y <= 0) {
                        result.y = parentSize.y - 200;
                    }
                }
            } else {
                Shell shell = this.getParentShell();
                if (shell != null) {
                    Point parentSize = shell.getSize();
                    result.x = parentSize.x - 100;
                    result.y = parentSize.y - 100;
                }
            }
            if (result.x < 700) {
                result.x = 700;
            }
            if (result.y < 500) {
                result.y = 500;
            }
        } else {
            try {
                result.x = bounds.getInt(WIDTH);
            }
            catch (NumberFormatException e) {
                result.x = 700;
            }
            try {
                result.y = bounds.getInt(HEIGHT);
            }
            catch (NumberFormatException e) {
                result.y = 500;
            }
        }
        return result;
    }

    protected Point getInitialLocation(Point initialSize) {
        Point loc = super.getInitialLocation(initialSize);
        IDialogSettings bounds = this.fSettings.getSection(DIALOG_BOUNDS_KEY);
        if (bounds != null) {
            try {
                loc.x = bounds.getInt(X);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                loc.y = bounds.getInt(Y);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return loc;
    }

    public boolean close() {
        boolean closed = super.close();
        if (closed && this.fNewBounds != null) {
            this.saveBounds(this.fNewBounds);
        }
        return closed;
    }

    private void saveBounds(Rectangle bounds) {
        IDialogSettings dialogBounds = this.fSettings.getSection(DIALOG_BOUNDS_KEY);
        if (dialogBounds == null) {
            dialogBounds = new DialogSettings(DIALOG_BOUNDS_KEY);
            this.fSettings.addSection(dialogBounds);
        }
        dialogBounds.put(X, bounds.x);
        dialogBounds.put(Y, bounds.y);
        dialogBounds.put(WIDTH, bounds.width);
        dialogBounds.put(HEIGHT, bounds.height);
    }
}

