/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.ui.IErrorDisplay;
import com.perforce.team.ui.IErrorProvider;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class P4StatusDialog
extends StatusDialog
implements IErrorDisplay {
    protected Button okStatusButton;

    protected void updateButtonsEnableState(IStatus status) {
        if (this.okStatusButton != null && !this.okStatusButton.isDisposed()) {
            this.okStatusButton.setEnabled(!status.matches(4));
        } else {
            super.updateButtonsEnableState(status);
        }
    }

    public P4StatusDialog(Shell parent) {
        super(parent);
    }

    public P4StatusDialog(Shell parent, String title) {
        this(parent);
        this.setTitle(title);
    }

    protected IP4Resource[] getFiles(IP4Resource[] resources) {
        ArrayList<IP4Resource> files = new ArrayList<IP4Resource>();
        if (resources != null) {
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (resource instanceof IP4File || resource instanceof IP4ShelveFile) {
                    files.add(resource);
                }
                ++n2;
            }
        }
        return files.toArray(new IP4Resource[files.size()]);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings;
        PerforceUIPlugin perforceUIPlugin = PerforceUIPlugin.getPlugin();
        if (perforceUIPlugin != null && (settings = perforceUIPlugin.getDialogSettings()) != null && (settings = this.getCustomDialogSettings(settings)) != null) {
            return settings;
        }
        return super.getDialogBoundsSettings();
    }

    protected IDialogSettings getCustomDialogSettings(IDialogSettings parent) {
        String name = this.getSectionName();
        if (name != null) {
            IDialogSettings settings = parent.getSection(name);
            if (settings == null) {
                settings = parent.addNewSection(name);
            }
            return settings;
        }
        return null;
    }

    protected String getSectionName() {
        return null;
    }

    protected void setModalResizeStyle() {
        this.setShellStyle(67696);
    }

    @Override
    public String getErrorMessage() {
        IStatus status = this.getStatus();
        if (status != null && status.getSeverity() == 4) {
            return status.getMessage();
        }
        return null;
    }

    public void setMessage(int severity, String message) {
        Object status = null;
        status = message != null ? new Status(severity, "com.perforce.team.ui", 0, message, null) : Status.OK_STATUS;
        this.updateStatus((IStatus)status);
    }

    @Override
    public void setErrorMessage(String message, IErrorProvider provider) {
        this.setMessage(4, message);
    }

    public void setErrorMessage(String message) {
        this.setErrorMessage(message, null);
    }

    public void setInfoMessage(String message) {
        this.setMessage(1, message);
    }

    public void addFormNameValidation(final Text text, final String formTypeName) {
        final ControlDecoration textDecorator = P4StatusDialog.createDecorator(text);
        textDecorator.setMarginWidth(2);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (text.getEnabled()) {
                    String name = text.getText();
                    String error = P4UIUtils.validateName(name, formTypeName);
                    if (error != null) {
                        textDecorator.setDescriptionText(MessageFormat.format(error, formTypeName));
                        textDecorator.show();
                        P4StatusDialog.this.setErrorMessage(MessageFormat.format("Illegal {0} name.", formTypeName));
                    } else {
                        textDecorator.hide();
                        P4StatusDialog.this.setErrorMessage(null);
                    }
                } else {
                    textDecorator.hide();
                    P4StatusDialog.this.setErrorMessage(null);
                }
            }
        });
    }

    public static ControlDecoration createDecorator(Text text) {
        ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        controlDecoration.hide();
        return controlDecoration;
    }
}

