/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.dialogs.DialogUtils;
import com.perforce.team.ui.dialogs.Messages;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class FilePropertiesDialog
extends PropertyPage
implements IWorkbenchPropertyPage {
    private static final int OPENED_THRESHOLD = 3;
    private IP4File mainFile = null;
    private Text depotLabel;
    private Text clientLabel;
    private Text typeLabel;
    private Text headLabel;
    private Text haveLabel;
    private Text headActionLabel;
    private Text headChangeLabel;
    private Text lastModifiedLabel;
    private IP4ShelveFile[] shelved;
    private IP4File[] opened;

    public FilePropertiesDialog() {
        this.noDefaultAndApplyButton();
    }

    private void load() {
        this.mainFile = this.getPerforceFile();
        this.opened = this.getOpenedBy(this.mainFile);
        this.shelved = this.getShelvedBy(this.mainFile);
    }

    private void createFileInfoArea(Composite parent) {
        if (this.mainFile == null) {
            DialogUtils.createLabel(parent, Messages.FilePropertiesDialog_FileNotManagedByPerforce);
        } else {
            int i;
            String client;
            String modTime;
            String headChange;
            String headAction;
            String haveRevision;
            String headRevision;
            String fileType;
            if (this.mainFile.getHeadRevision() > 0) {
                fileType = this.mainFile.getHeadType();
                headRevision = Integer.toString(this.mainFile.getHeadRevision());
                haveRevision = Integer.toString(this.mainFile.getHaveRevision());
                FileAction headFileAction = this.mainFile.getHeadAction();
                headAction = headFileAction != null ? headFileAction.toString().toLowerCase() : "";
                headChange = Integer.toString(this.mainFile.getHeadChange());
                modTime = P4UIUtils.formatLabelDate(this.mainFile.getHeadTime());
            } else {
                fileType = this.mainFile.getOpenedType();
                headRevision = "";
                haveRevision = "";
                headAction = "";
                headChange = "";
                modTime = "";
            }
            String remote = this.mainFile.getRemotePath();
            if (remote == null) {
                remote = "";
            }
            if (fileType == null) {
                fileType = "";
            }
            if ((client = this.mainFile.getClientPath()) == null) {
                client = "";
            }
            DialogUtils.createLabel(parent, Messages.FilePropertiesDialog_DepotPath);
            this.depotLabel = DialogUtils.createSelectableLabel(parent, remote);
            DialogUtils.createLabel(parent, Messages.FilePropertiesDialog_ClientPath);
            this.clientLabel = DialogUtils.createSelectableLabel(parent, client);
            DialogUtils.createLabel(parent, Messages.FilePropertiesDialog_FileType);
            this.typeLabel = DialogUtils.createSelectableLabel(parent, fileType);
            DialogUtils.createLabel(parent, Messages.FilePropertiesDialog_HeadRevision);
            this.headLabel = DialogUtils.createSelectableLabel(parent, headRevision);
            DialogUtils.createLabel(parent, Messages.FilePropertiesDialog_HaveRevision);
            this.haveLabel = DialogUtils.createSelectableLabel(parent, haveRevision);
            DialogUtils.createLabel(parent, Messages.FilePropertiesDialog_HaveAction);
            this.headActionLabel = DialogUtils.createSelectableLabel(parent, headAction);
            DialogUtils.createLabel(parent, Messages.FilePropertiesDialog_HeadChange);
            this.headChangeLabel = DialogUtils.createSelectableLabel(parent, headChange);
            DialogUtils.createLabel(parent, Messages.FilePropertiesDialog_LastModified);
            this.lastModifiedLabel = DialogUtils.createSelectableLabel(parent, modTime);
            DialogUtils.createSeparator(parent, 2);
            Label label = DialogUtils.createLabel(parent, Messages.FilePropertiesDialog_OpenedBy);
            if (this.opened.length == 0) {
                DialogUtils.createBlank(parent);
            } else if (this.opened.length > 3) {
                List list = DialogUtils.createList(parent, 3, this.getListHeight(label));
                i = 0;
                while (i < this.opened.length) {
                    if (i > 0 && i < 3) {
                        DialogUtils.createBlank(parent);
                    }
                    list.add(this.getOpenedByDesc(this.opened[i]));
                    ++i;
                }
            } else {
                int i2 = 0;
                while (i2 < this.opened.length) {
                    if (i2 > 0) {
                        DialogUtils.createBlank(parent);
                    }
                    DialogUtils.createLabel(parent, this.getOpenedByDesc(this.opened[i2]));
                    ++i2;
                }
            }
            DialogUtils.createLabel(parent, Messages.FilePropertiesDialog_LockedBy);
            boolean locked = false;
            i = 0;
            while (i < this.opened.length) {
                if (this.opened[i] != null && this.opened[i].isLocked()) {
                    DialogUtils.createLabel(parent, String.valueOf(this.opened[i].getUserName()) + "@" + this.opened[i].getClientName());
                    locked = true;
                    break;
                }
                ++i;
            }
            if (!locked) {
                DialogUtils.createLabel(parent, "");
            }
            Label shelveLabel = DialogUtils.createLabel(parent, Messages.FilePropertiesDialog_ShelvedBy);
            if (this.shelved.length == 0) {
                DialogUtils.createBlank(parent);
            } else if (this.shelved.length > 3) {
                List list = DialogUtils.createList(parent, 3, this.getListHeight(shelveLabel));
                int i3 = 0;
                while (i3 < this.shelved.length) {
                    if (i3 > 0 && i3 < 3) {
                        DialogUtils.createBlank(parent);
                    }
                    list.add(this.getOpenedByDesc(this.shelved[i3]));
                    ++i3;
                }
            } else {
                int i4 = 0;
                while (i4 < this.shelved.length) {
                    if (i4 > 0) {
                        DialogUtils.createBlank(parent);
                    }
                    DialogUtils.createLabel(parent, this.getOpenedByDesc(this.shelved[i4]));
                    ++i4;
                }
            }
        }
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout cLayout = new GridLayout(2, false);
        cLayout.marginHeight = 0;
        cLayout.marginWidth = 0;
        composite.setLayout((Layout)cLayout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.load();
        this.createFileInfoArea(composite);
        return composite;
    }

    private String getOpenedByDesc(IP4ShelveFile file) {
        return MessageFormat.format(Messages.FilePropertiesDialog_OpenedByDesc, file.getUser(), file.getWorkspace(), file.getId());
    }

    private String getOpenedByDesc(IP4File file) {
        FileAction fileAction = file.getAction();
        if (fileAction == null) {
            return MessageFormat.format(Messages.FilePropertiesDialog_OpenedByDesc, file.getUserName(), file.getClientName(), file.getChangelistId());
        }
        return MessageFormat.format(Messages.FilePropertiesDialog_OpenedByDescWithAction, file.getUserName(), file.getClientName(), file.getChangelistId(), fileAction.toString().toLowerCase());
    }

    private IP4File getPerforceFile() {
        IP4File p4File = null;
        IP4Resource p4Resource = null;
        IAdaptable element = this.getElement();
        if (element instanceof IP4Resource) {
            p4Resource = (IP4Resource)element;
        } else {
            IFile file = (IFile)this.getElement();
            p4Resource = P4ConnectionManager.getManager().getResource((IResource)file);
        }
        if (p4Resource instanceof IP4File) {
            if (p4Resource != null) {
                IP4File adapted;
                IP4Connection connection = p4Resource.getConnection();
                if (p4Resource.isReadOnly() && (adapted = connection.getFile(((IP4File)p4Resource).getP4JFile())) != null) {
                    p4Resource = adapted;
                }
                if (connection != null && !connection.isOffline() && connection.isConnected()) {
                    p4Resource.refresh();
                }
            }
            if (((IP4File)p4Resource).getP4JFile() != null) {
                p4File = (IP4File)p4Resource;
            }
        }
        return p4File;
    }

    private IP4ShelveFile[] getShelvedBy(IP4File file) {
        IP4ShelveFile[] files = null;
        files = file != null ? file.getShelvedVersions() : new IP4ShelveFile[]{};
        return files;
    }

    private IP4File[] getOpenedBy(IP4File file) {
        String path;
        IP4Connection connection;
        IP4File[] files = new IP4File[]{};
        if (file != null && (connection = file.getConnection()) != null && (path = file.getActionPath()) != null) {
            files = connection.getOpenedBy(path);
        }
        return files;
    }

    private int getListHeight(Label label) {
        return label.computeSize((int)-1, (int)-1).y * 3 * 2;
    }

    public String getDepotLabel() {
        return this.depotLabel.getText();
    }

    public String getClientLabel() {
        return this.clientLabel.getText();
    }

    public String getTypeLabel() {
        return this.typeLabel.getText();
    }

    public String getHeadLabel() {
        return this.headLabel.getText();
    }

    public String getHeadActionLabel() {
        return this.headActionLabel.getText();
    }

    public String getHeadChangeLabel() {
        return this.headChangeLabel.getText();
    }

    public String getLastModifiedLabel() {
        return this.lastModifiedLabel.getText();
    }

    public String getHaveLabel() {
        return this.haveLabel.getText();
    }
}

