/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceLabelProvider;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class FileListViewer
extends CheckboxTableViewer {
    private static final int DEFAULT_WIDTH = 500;
    private static final int DEFAULT_HEIGHT = 150;

    public FileListViewer(Composite parent, Object[] files, Object[] checkedFiles, boolean small) {
        super(new Table(parent, 2082));
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 500;
        data.heightHint = small ? 75 : 150;
        this.getControl().setLayoutData((Object)data);
        this.setSorter(new ViewerSorter());
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new PerforceLabelProvider(){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof IP4Resource) {
                    String path = ((IP4Resource)element).getActionPath(IP4Resource.Type.REMOTE);
                    String decorated = this.decorator.getLabelDecorator().decorateText(path, element);
                    if (decorated != null) {
                        path = decorated;
                    }
                    return path;
                }
                if (element instanceof IFile) {
                    return PerforceProviderPlugin.getResourcePath((IResource)((IFile)element));
                }
                return super.getColumnText(element, columnIndex);
            }
        });
        this.setInput(files);
        this.setCheckedElements(checkedFiles);
        P4UIUtils.trackMovedFiles((ICheckable)this);
    }
}

