/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class DialogUtils {
    private DialogUtils() {
    }

    public static Text createTextField(Composite parent, int width, boolean fill) {
        Text text = new Text(parent, 2052);
        GridData data = fill ? new GridData(768) : new GridData();
        data.verticalAlignment = 2;
        data.grabExcessVerticalSpace = false;
        data.widthHint = width;
        text.setLayoutData((Object)data);
        return text;
    }

    public static Button createButton(Composite parent, String text, int flags) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setLayoutData((Object)new GridData(flags));
        return button;
    }

    public static Text createTextField(Composite parent) {
        return DialogUtils.createTextField(parent, 200, true);
    }

    public static Label createBlank(Composite parent) {
        return DialogUtils.createLabel(parent, "");
    }

    public static Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Label createLabel(Composite parent, String text, int style) {
        Label label = new Label(parent, style);
        label.setText(text);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        label.setLayoutData((Object)data);
        return label;
    }

    public static Combo createCombo(Composite parent, String[] items, boolean readonly) {
        int flags = 4;
        if (readonly) {
            flags |= 8;
        }
        Combo combo = new Combo(parent, flags);
        GridData data = new GridData(768);
        combo.setLayoutData((Object)data);
        int i = 0;
        while (i < items.length) {
            combo.add(items[i]);
            ++i;
        }
        return combo;
    }

    public static Button createRadio(Composite parent, String text) {
        return DialogUtils.createRadio(parent, 0, text);
    }

    public static Button createRadio(Composite parent, int style, String text) {
        Button radio = new Button(parent, 524304);
        radio.setText(text);
        radio.setLayoutData((Object)new GridData());
        return radio;
    }

    public static Button createCheck(Composite parent, String text) {
        Button check = new Button(parent, 32);
        check.setText(text);
        check.setLayoutData((Object)new GridData());
        return check;
    }

    public static List createList(Composite parent, int vspan, int height) {
        List list = new List(parent, 2562);
        GridData data = new GridData();
        data.verticalSpan = vspan;
        data.heightHint = height;
        list.setLayoutData((Object)data);
        return list;
    }

    public static List createList(Composite parent, int vspan, int height, int width, boolean multi) {
        List list = new List(parent, 2560);
        GridData data = new GridData();
        data.verticalSpan = vspan;
        data.heightHint = height;
        data.widthHint = width;
        list.setLayoutData((Object)data);
        return list;
    }

    public static Group createGroup(Composite parent, String title, int numcols) {
        Group group = new Group(parent, 16);
        group.setText(title);
        group.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        layout.numColumns = numcols;
        group.setLayout((Layout)layout);
        return group;
    }

    public static Label createSeparator(Composite composite, int colspan) {
        Label separator = new Label(composite, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = colspan;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
        return separator;
    }

    public static Composite createComposite(Composite parent) {
        return DialogUtils.createComposite(parent, 1, 0);
    }

    public static Composite createComposite(Composite parent, int numcols) {
        return DialogUtils.createComposite(parent, numcols, 0);
    }

    public static Composite createComposite(Composite parent, int numcols, int flags) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(flags));
        GridLayout layout = new GridLayout();
        layout.numColumns = numcols;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    public static Text createTextEditor(Composite parent) {
        Text text = new Text(parent, 2626);
        GridData data = new GridData(1808);
        data.heightHint = 150;
        text.setLayoutData((Object)data);
        return text;
    }

    public static TextViewer createTextViewer(Composite parent) {
        TextViewer viewer = new TextViewer(parent, 2826);
        GridData data = new GridData(1808);
        data.heightHint = 150;
        viewer.getControl().setLayoutData((Object)data);
        return viewer;
    }

    public static TextViewer createTextViewer(Composite parent, int style) {
        TextViewer viewer = new TextViewer(parent, style);
        GridData data = new GridData(1808);
        data.heightHint = 150;
        viewer.getControl().setLayoutData((Object)data);
        return viewer;
    }

    public static SashForm createSash(Composite parent) {
        SashForm sash = new SashForm(parent, 512);
        GridData data = new GridData(1808);
        data.heightHint = 300;
        sash.setLayoutData((Object)data);
        return sash;
    }

    public static Composite createTitledArea(Composite parent, int flags) {
        Composite composite = DialogUtils.createComposite(parent, 1, flags);
        ((GridLayout)composite.getLayout()).verticalSpacing = 2;
        return composite;
    }

    public static Text createSelectableLabel(Composite parent, String defaultText) {
        return DialogUtils.createSelectableLabel(parent, null, defaultText);
    }

    public static Text createSelectableLabel(Composite parent, GridData data) {
        return DialogUtils.createSelectableLabel(parent, data, null);
    }

    public static Text createSelectableLabel(Composite parent, GridData data, String defaultText) {
        Text text = new Text(parent, 8);
        if (data == null) {
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
        }
        text.setLayoutData((Object)data);
        if (defaultText != null) {
            text.setText(defaultText);
        }
        text.setBackground(text.getDisplay().getSystemColor(22));
        return text;
    }
}

