/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.dialogs;

import com.perforce.team.ui.dialogs.DialogUtils;
import com.perforce.team.ui.dialogs.Messages;
import com.perforce.team.ui.dialogs.PerforcePreferencesDialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class ConsolePreferencesDialog
extends PerforcePreferencesDialog {
    public static final String ID = "com.perforce.team.ui.dialogs.ConsolePreferencesDialog";
    private PerforcePreferencesDialog.PerforceColorFieldEditor commandColorEditor;
    private PerforcePreferencesDialog.PerforceColorFieldEditor messageColorEditor;
    private PerforcePreferencesDialog.PerforceColorFieldEditor errorColorEditor;
    private IntegerFieldEditor commandsEditor;
    private BooleanFieldEditor timestampEditor;
    private PerforcePreferencesDialog.PerforceBooleanFieldEditor hideOutputEditor;
    private static final int NUM_COLS = 2;

    public ConsolePreferencesDialog() {
        super(2);
    }

    public void setErrorMessage(String newMessage) {
        super.setErrorMessage(newMessage);
        this.setValid(newMessage == null);
    }

    protected Control createContents(Composite parent) {
        Composite composite = DialogUtils.createComposite(parent, 2);
        Label label = DialogUtils.createLabel(composite, Messages.ConsolePreferencesDialog_ConsoleSettings);
        ((GridData)label.getLayoutData()).horizontalSpan = 2;
        this.commandColorEditor = this.createColorFieldEditor("pref_console_command_colour", Messages.ConsolePreferencesDialog_CommandLine, composite);
        this.messageColorEditor = this.createColorFieldEditor("pref_console_message_colour", Messages.ConsolePreferencesDialog_Message, composite);
        this.errorColorEditor = this.createColorFieldEditor("pref_console_error_colour", Messages.ConsolePreferencesDialog_Error, composite);
        this.commandsEditor = new IntegerFieldEditor("com.perforce.team.ui.commandsMax", Messages.ConsolePreferencesDialog_CommandHistorySize, composite);
        this.commandsEditor.setValidRange(0, Integer.MAX_VALUE);
        this.commandsEditor.setPage((DialogPage)this);
        this.commandsEditor.setPreferenceStore(this.getPreferenceStore());
        this.timestampEditor = this.createBooleanFieldEditor("com.perforce.team.ui.consoleTimestamp", Messages.ConsolePreferencesDialog_ShowTimestamp, composite);
        this.hideOutputEditor = this.createBooleanFieldEditor("pref_console_command_ouput_hide_large", Messages.ConsolePreferencesDialog_HideLargeSizeOutput, composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.commandColorEditor.getHelpControl(), "com.perforce.team.ui.pref_console_command_colour");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.messageColorEditor.getHelpControl(), "com.perforce.team.ui.pref_console_message_colour");
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.errorColorEditor.getHelpControl(), "com.perforce.team.ui.pref_console_error_colour");
        this.setFieldEditors(new FieldEditor[]{this.commandColorEditor, this.messageColorEditor, this.errorColorEditor, this.commandsEditor, this.timestampEditor, this.hideOutputEditor});
        this.initializeValues();
        return composite;
    }
}

