/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.connection;

import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import com.perforce.team.ui.ConfigWizard;
import com.perforce.team.ui.IErrorDisplay;
import com.perforce.team.ui.IErrorProvider;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceLabelProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.SWTUtils;
import com.perforce.team.ui.actions.NewServerAction;
import com.perforce.team.ui.connection.Messages;
import com.perforce.team.ui.operations.RetryableOperation;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class SelectConnectionWizardPage
extends WizardPage
implements IErrorDisplay {
    private static final String NULL_ROOT = "null";
    private ComboViewer serverCombo;
    private Button newServerButton;
    private ClientPathWidget clientPathWidget;
    private CheckboxTableViewer projectMoveViewer;
    private ProjectMoveLabelProvider projectMoveLabelProvider = new ProjectMoveLabelProvider();
    private Map<IProject, Boolean> projectMap = new HashMap<IProject, Boolean>();
    private boolean clientPathInvalid = false;

    public SelectConnectionWizardPage(String pageName) {
        super(pageName, Messages.SelectConnectionWizardPage_EnterConnectionInfo, PerforceUIPlugin.getPlugin().getImageDescriptor("perforce/wizard.png"));
        this.setDescription(Messages.SelectConnectionWizardPage_DefineConnection);
    }

    public void createControl(Composite parent) {
        Composite displayArea = new Composite(parent, 0);
        displayArea.setLayout((Layout)new GridLayout(3, false));
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Label serverLabel = SWTUtils.createLabel(displayArea, Messages.SelectConnectionWizardPage_ServerConnection);
        GridDataFactory.swtDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)serverLabel);
        this.serverCombo = new ComboViewer(displayArea, 8);
        this.serverCombo.setLabelProvider((IBaseLabelProvider)new PerforceLabelProvider(false));
        this.serverCombo.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.serverCombo.setSorter(new ViewerSorter());
        this.serverCombo.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof IP4Connection && !((IP4Connection)element).isOffline();
            }
        }});
        GridData vData = new GridData(4, 0x1000000, true, false);
        this.serverCombo.getControl().setLayoutData((Object)vData);
        this.serverCombo.setInput((Object)P4ConnectionManager.getManager().getConnections());
        this.serverCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            /*
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void selectionChanged(SelectionChangedEvent event) {
                element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (element instanceof IP4Connection == false) return;
                connection = (IP4Connection)element;
                try {
                    if (connection.getClient() == null) ** GOTO lbl13
                    currentRoot = SelectConnectionWizardPage.this.getActiveRoot(connection);
                    root = new File(currentRoot);
                    if (!SelectConnectionWizardPage.this.validateClientRoot(root)) {
                        return;
                    }
                    SelectConnectionWizardPage.access$3(SelectConnectionWizardPage.this, false);
                    return;
lbl13:
                    // 1 sources

                    SelectConnectionWizardPage.access$4(SelectConnectionWizardPage.this).refresh(true);
                    SelectConnectionWizardPage.access$3(SelectConnectionWizardPage.this, true);
                    return;
                }
                catch (Exception e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                    SelectConnectionWizardPage.access$3(SelectConnectionWizardPage.this, true);
                    return;
                }
                finally {
                    SelectConnectionWizardPage.access$1(SelectConnectionWizardPage.this).setInput(SelectConnectionWizardPage.this.getConnection());
                    SelectConnectionWizardPage.this.refreshProjectMoveViewer();
                    SelectConnectionWizardPage.access$2(SelectConnectionWizardPage.this);
                }
            }
        });
        this.newServerButton = new Button(displayArea, 8);
        GridDataFactory.swtDefaults().align(16384, 0x1000000).grab(false, false).applyTo((Control)this.newServerButton);
        this.newServerButton.setText(Messages.SelectConnectionWizardPage_NewServerConnection);
        this.newServerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new NewServerAction().run(null);
                SelectConnectionWizardPage.this.serverCombo.setInput((Object)P4ConnectionManager.getManager().getConnections());
                SelectConnectionWizardPage.this.serverCombo.refresh();
                SelectConnectionWizardPage.this.serverCombo.setSelection(null);
            }
        });
        this.clientPathWidget = new ClientPathWidget();
        this.clientPathWidget.createControl(displayArea);
        this.clientPathWidget.setInput(this.getConnection());
        this.projectMoveViewer = this.createProjectMoveViewer(displayArea);
        this.updateEnablement();
        this.setControl((Control)displayArea);
    }

    protected String getActiveRoot(IP4Connection connection) {
        String currentRoot = connection.getCurrentDirectory();
        if (currentRoot == null) {
            currentRoot = this.getClientRootWithProgress(connection);
        }
        return currentRoot;
    }

    protected String getClientRootWithProgress(final IP4Connection connection) {
        final String[] root = new String[1];
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.SelectConnectionWizardPage_FetchingRoot, 100);
                    monitor.worked(50);
                    root[0] = connection.getClientRoot();
                    monitor.worked(50);
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return root[0];
    }

    protected boolean validateClientRoot(File root) {
        if (root == null) {
            return false;
        }
        if (NULL_ROOT.equalsIgnoreCase(root.getPath())) {
            if (P4CoreUtils.isWindows()) {
                return true;
            }
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.SelectConnectionWizardPage_Error, (String)Messages.SelectConnectionWizardPage_ClientRootCannotBeNull);
            this.serverCombo.setSelection(null);
            return false;
        }
        if (root.isAbsolute()) {
            if (!root.exists()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.SelectConnectionWizardPage_Error, (String)MessageFormat.format(Messages.SelectConnectionWizardPage_ClientRootNotExist, root.toString()));
                this.serverCombo.setSelection(null);
                return false;
            }
            if (!root.canWrite()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.SelectConnectionWizardPage_Error, (String)MessageFormat.format(Messages.SelectConnectionWizardPage_ClientRootNotWritable, root.toString()));
                this.serverCombo.setSelection(null);
                return false;
            }
            return true;
        }
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.SelectConnectionWizardPage_Error, (String)MessageFormat.format(Messages.SelectConnectionWizardPage_ClientRootNotExist, root.toString()));
        this.serverCombo.setSelection(null);
        return false;
    }

    protected void refreshProjectMoveViewer() {
        IPath targetPath;
        this.projectMoveLabelProvider.targetFolder = targetPath = this.clientPathWidget.getTargetClientPath();
        this.projectMoveViewer.refresh();
        this.resizeViewerLastColumn(this.projectMoveViewer);
    }

    private CheckboxTableViewer createProjectMoveViewer(Composite parent) {
        Table projectMoveTable = new Table(parent, 65570);
        CheckboxTableViewer viewer = new CheckboxTableViewer(projectMoveTable);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, true).applyTo((Control)projectMoveTable);
        TableColumn tc = new TableColumn(projectMoveTable, 0);
        tc.setText(Messages.SelectConnectionWizardPage_Relocate);
        tc.setWidth(100);
        tc = new TableColumn(projectMoveTable, 0);
        tc.setText(Messages.SelectConnectionWizardPage_ProjectNameColumnHeader);
        tc.setWidth(150);
        tc = new TableColumn(projectMoveTable, 0);
        tc.setText(Messages.SelectConnectionWizardPage_CurrentLocationColumnHeader);
        tc.setWidth(250);
        tc = new TableColumn(projectMoveTable, 0);
        tc.setText(Messages.SelectConnectionWizardPage_NewLocationTargetHeader);
        tc.setWidth(350);
        projectMoveTable.setHeaderVisible(true);
        viewer.setLabelProvider((IBaseLabelProvider)this.projectMoveLabelProvider);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setSorter(new ViewerSorter());
        GridData vData = new GridData(4, 4, true, true, 3, 1);
        vData.heightHint = 100;
        viewer.getTable().setLayoutData((Object)vData);
        viewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IProject prj = (IProject)event.getElement();
                SelectConnectionWizardPage.this.projectMap.put(prj, event.getChecked());
                SelectConnectionWizardPage.this.projectMoveViewer.refresh((Object)prj);
                SelectConnectionWizardPage.this.resizeViewerLastColumn(SelectConnectionWizardPage.this.projectMoveViewer);
            }
        });
        this.initProjectMap();
        viewer.setInput((Object)this.projectMap.keySet().toArray(new IProject[0]));
        this.resizeViewerColumns(viewer);
        TableItem[] children = viewer.getTable().getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            IProject prj = (IProject)item.getData();
            item.setChecked(this.projectMap.get(prj).booleanValue());
            ++i;
        }
        return viewer;
    }

    private void resizeViewerLastColumn(CheckboxTableViewer viewer) {
        viewer.getTable().getColumns()[viewer.getTable().getColumnCount() - 1].pack();
    }

    private void resizeViewerColumns(CheckboxTableViewer viewer) {
        TableColumn[] tableColumnArray = viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.pack();
            ++n2;
        }
    }

    private void initProjectMap() {
        this.projectMap.clear();
        IProject[] iProjectArray = ((ConfigWizard)this.getWizard()).getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject prj = iProjectArray[n2];
            this.projectMap.put(prj, true);
            ++n2;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateEnablement();
        }
    }

    private void updateEnablement() {
        if (this.serverCombo.getSelection().isEmpty()) {
            this.setDescription(Messages.SelectConnectionWizardPage_SelectOrCreateConnection);
        } else if (this.clientPathInvalid) {
            this.setErrorMessage(Messages.SelectConnectionWizardPage_InvalidClientPath);
        } else {
            this.setErrorMessage(null);
        }
        this.setPageComplete(this.getErrorMessage() == null && !this.serverCombo.getSelection().isEmpty());
    }

    public IP4Connection getConnection() {
        IStructuredSelection selection = (IStructuredSelection)this.serverCombo.getSelection();
        IP4Connection connection = null;
        if (selection.getFirstElement() instanceof IP4Connection) {
            connection = (IP4Connection)selection.getFirstElement();
        }
        return connection;
    }

    @Override
    public void setErrorMessage(String message, IErrorProvider provider) {
        super.setErrorMessage(message);
        this.setPageComplete(this.getErrorMessage() == null);
    }

    public Map<IProject, File> getProjects(boolean relocate) {
        HashMap<IProject, File> ret = new HashMap<IProject, File>();
        IPath targetPath = this.clientPathWidget.getTargetClientPath();
        for (IProject project : this.projectMap.keySet()) {
            if (this.projectMap.get(project).booleanValue() && relocate) {
                boolean isPrefix = targetPath.isPrefixOf(project.getLocation());
                if (isPrefix) {
                    ret.put(project, new File(project.getLocation().toOSString()));
                } else {
                    IPath targetLocation = targetPath.append(project.getLocation().lastSegment());
                    ret.put(project, targetLocation.toFile());
                }
            }
            if (this.projectMap.get(project).booleanValue() || relocate) continue;
            ret.put(project, new File(project.getLocation().toOSString()));
        }
        return ret;
    }

    public void setConnection(IP4Connection ip4Connection) {
        this.serverCombo.setSelection((ISelection)new StructuredSelection((Object)ip4Connection));
    }

    public void setRelativePath(String rpath) {
        this.clientPathWidget.setRelativePath(rpath);
    }

    public Map<IProject, String> getInvalidProject(final Map<IProject, File> projectsToMove, final IP4Connection connection) {
        final HashMap<IProject, String> errorProjects = new HashMap<IProject, String>();
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.SelectConnectionWizardPage_ValidateProjects, projectsToMove.size() + 1);
                    monitor.worked(1);
                    for (Map.Entry entry : projectsToMove.entrySet()) {
                        IProject project = (IProject)entry.getKey();
                        List specList = P4FileSpecBuilder.makeFileSpecList((String[])new String[]{new File((File)entry.getValue(), ".project").toString()});
                        try {
                            try {
                                IFileSpec spec;
                                List<IFileSpec> added = RetryableOperation.whereWithRetry(connection, specList);
                                if (added.size() == 1 && (spec = added.get(0)).getOpStatus() != FileSpecOpStatus.VALID && spec.getOpStatus() != FileSpecOpStatus.INFO) {
                                    errorProjects.put(project, spec.getStatusMessage());
                                }
                            }
                            catch (Throwable e) {
                                errorProjects.put(project, e.getLocalizedMessage());
                                PerforceProviderPlugin.logError((Throwable)e);
                                monitor.worked(1);
                                continue;
                            }
                        }
                        catch (Throwable throwable) {
                            monitor.worked(1);
                            throw throwable;
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                }
            });
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        return errorProjects;
    }

    static /* synthetic */ ClientPathWidget access$1(SelectConnectionWizardPage selectConnectionWizardPage) {
        return selectConnectionWizardPage.clientPathWidget;
    }

    static /* synthetic */ void access$2(SelectConnectionWizardPage selectConnectionWizardPage) {
        selectConnectionWizardPage.updateEnablement();
    }

    static /* synthetic */ void access$3(SelectConnectionWizardPage selectConnectionWizardPage, boolean bl) {
        selectConnectionWizardPage.clientPathInvalid = bl;
    }

    private class ClientPathWidget {
        private Composite clientPathControl;
        private Label clientRootLabel;
        private Text clientRelPathText;
        private Button browseButton;

        private ClientPathWidget() {
        }

        public void createControl(Composite parent) {
            Label targetLabel = SWTUtils.createLabel(parent, Messages.SelectConnectionWizardPage_TargetClientPath);
            GridDataFactory.swtDefaults().align(16384, 0x1000000).applyTo((Control)targetLabel);
            Composite container = new Composite(parent, 0);
            GridDataFactory.swtDefaults().align(4, 0x1000000).span(1, 1).grab(true, false).applyTo((Control)container);
            GridLayoutFactory.fillDefaults().numColumns(2).applyTo(container);
            this.clientRootLabel = new Label(container, 0);
            GridDataFactory.swtDefaults().align(16384, 0x1000000).applyTo((Control)this.clientRootLabel);
            this.clientRootLabel.setForeground(Display.getDefault().getSystemColor(9));
            this.clientRelPathText = SWTUtils.createText(container);
            GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.clientRelPathText);
            this.clientRelPathText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SelectConnectionWizardPage.this.refreshProjectMoveViewer();
                }
            });
            this.browseButton = new Button(parent, 8);
            this.browseButton.setText(Messages.SelectConnectionWizardPage_Browse);
            GridDataFactory.swtDefaults().align(16384, 0x1000000).applyTo((Control)this.browseButton);
            this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dlg = new DirectoryDialog(SelectConnectionWizardPage.this.getShell(), 4096);
                    Path rootdir = new Path(ClientPathWidget.this.getClientRoot());
                    IPath filter = rootdir.append(ClientPathWidget.this.clientRelPathText.getText());
                    dlg.setFilterPath(filter.toString());
                    String result = dlg.open();
                    if (result != null) {
                        Path newdir = new Path(result.trim());
                        if (!rootdir.isPrefixOf((IPath)newdir)) {
                            MessageDialog.openError(null, (String)Messages.SelectConnectionWizardPage_Error, (String)MessageFormat.format(Messages.SelectConnectionWizardPage_Error_RelativePathNotInClientRoot, rootdir.toOSString()));
                            return;
                        }
                        ClientPathWidget.this.clientRelPathText.setText(newdir.removeFirstSegments(rootdir.segmentCount()).setDevice(null).toString());
                    }
                }
            });
            this.clientPathControl = container;
        }

        public void setInput(IP4Connection connection) {
            this.getBrowseClientPathButton().setEnabled(connection != null);
            if (connection == null) {
                if (!this.getRelativePath().isEmpty()) {
                    this.setRelativePath("");
                }
                this.setClientRoot("");
            } else {
                this.setClientRoot(SelectConnectionWizardPage.this.getActiveRoot(connection));
            }
            this.clientRelPathText.setEnabled(!this.getClientRoot().isEmpty());
        }

        public IPath getTargetClientPath() {
            String root = this.getClientRoot();
            if (P4CoreUtils.isWindows() && SelectConnectionWizardPage.NULL_ROOT.equalsIgnoreCase(root)) {
                return new Path(this.getRelativePath());
            }
            return new Path(root).append((IPath)new Path(this.getRelativePath()));
        }

        public Composite getClientPathControl() {
            return this.clientPathControl;
        }

        public String getClientRoot() {
            return this.clientRootLabel.getText().trim();
        }

        public String getRelativePath() {
            return this.clientRelPathText.getText().trim();
        }

        public void setClientRoot(String text) {
            if (text == null) {
                text = "";
            }
            this.clientRootLabel.setText(text);
            this.getClientPathControl().layout(true);
        }

        public void setRelativePath(String text) {
            this.clientRelPathText.setText(text);
        }

        private Button getBrowseClientPathButton() {
            return this.browseButton;
        }
    }

    private class ProjectMoveLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        IPath targetFolder;

        private ProjectMoveLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IProject prj = (IProject)element;
            switch (columnIndex) {
                case 1: {
                    return prj.getName();
                }
                case 2: {
                    return prj.getLocation().toOSString();
                }
                case 3: {
                    if (((Boolean)SelectConnectionWizardPage.this.projectMap.get(prj)).booleanValue() && this.targetFolder != null && !this.targetFolder.isEmpty()) {
                        IPath showPath = null;
                        showPath = this.targetFolder.isPrefixOf(prj.getLocation()) ? prj.getLocation() : this.targetFolder.append(prj.getLocation().lastSegment());
                        if (showPath != null) {
                            return showPath.toOSString();
                        }
                    }
                    return null;
                }
            }
            return null;
        }
    }
}

