/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.connection;

import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.ui.IEnableDisplay;
import com.perforce.team.ui.IErrorDisplay;
import com.perforce.team.ui.IErrorProvider;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.connection.Messages;
import com.perforce.team.ui.dialogs.DialogUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class BasicConnectionWidget
implements IErrorProvider,
IEnableDisplay {
    private static final String PORT_ONLY = "\\d+";
    private IErrorDisplay errorDisplay;
    private Text port;
    private Text client;
    private Text user;
    private Combo charset;
    private boolean readOnly = false;
    private String errorMessage = null;

    public BasicConnectionWidget() {
        this(false);
    }

    public BasicConnectionWidget(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public Composite createControl(Composite parent, boolean wrapInGroup) {
        Composite displayArea = new Composite(parent, 0);
        displayArea.setLayout((Layout)new GridLayout(1, true));
        displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite wrapper = displayArea;
        if (wrapInGroup) {
            displayArea.setLayout((Layout)new GridLayout(1, true));
            wrapper = new Group(displayArea, 0);
            ((Group)wrapper).setText(Messages.BasicConnectionWidget_ServerConnection);
            wrapper.setLayout((Layout)new GridLayout(2, false));
            wrapper.setLayoutData((Object)new GridData(4, 4, true, true));
        } else {
            displayArea.setLayout((Layout)new GridLayout(2, false));
        }
        this.port = this.createLabeledText(wrapper, Messages.BasicConnectionWidget_ServerAddress);
        this.port.setEnabled(!this.readOnly);
        this.user = this.createLabeledText(wrapper, Messages.BasicConnectionWidget_User);
        this.user.setEnabled(!this.readOnly);
        this.client = this.createLabeledText(wrapper, Messages.BasicConnectionWidget_Client);
        this.client.setEnabled(!this.readOnly);
        this.charset = this.createLabeledCombo(wrapper, Messages.BasicConnectionWidget_Charset);
        this.charset.setEnabled(!this.readOnly);
        this.charset.select(this.charset.indexOf("none"));
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicConnectionWidget.this.validate();
            }
        };
        this.port.addModifyListener(modifyListener);
        this.user.addModifyListener(modifyListener);
        this.client.addModifyListener(modifyListener);
        this.charset.addModifyListener(modifyListener);
        if (!this.readOnly) {
            this.port.setFocus();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.port, "com.perforce.team.ui.share_project_port");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.user, "com.perforce.team.ui.share_project_user");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.client, "com.perforce.team.ui.share_project_client");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.charset, "com.perforce.team.ui.share_project_charset");
        return displayArea;
    }

    public void setConnectionParameters(ConnectionParameters params) {
        String select;
        this.port.setText(params.getPortNoNull());
        this.client.setText(params.getClientNoNull());
        this.user.setText(params.getUserNoNull());
        String charsetStr = params.getCharset();
        if (charsetStr != null && (select = P4UIUtils.getDisplayCharset(charsetStr)) != null) {
            this.charset.setText(select);
        }
    }

    private Text createLabeledText(Composite parent, String text) {
        DialogUtils.createLabel(parent, text);
        return DialogUtils.createTextField(parent, 200, true);
    }

    private Combo createLabeledCombo(Composite parent, String text) {
        DialogUtils.createLabel(parent, text);
        return DialogUtils.createCombo(parent, P4UIUtils.getDisplayCharsets(), true);
    }

    public ConnectionParameters getConnectionParameters() {
        String portText;
        ConnectionParameters params = new ConnectionParameters();
        String originalText = portText = this.port.getText().trim();
        if (portText.startsWith(":")) {
            portText = portText.substring(1);
        }
        portText = portText.matches(PORT_ONLY) ? "localhost:" + portText : originalText;
        params.setPort(portText);
        params.setClient(this.client.getText().trim());
        params.setUser(this.user.getText().trim());
        params.setCharset(P4UIUtils.getP4Charset(this.charset.getText()));
        return params;
    }

    public void setPort(String port) {
        if (port != null && this.port != null && !this.port.isDisposed()) {
            this.port.setText(port);
        }
    }

    public void setClient(String client) {
        if (client != null && this.client != null && !this.client.isDisposed()) {
            this.client.setText(client);
        }
    }

    public void setUser(String user) {
        if (user != null && this.user != null && !this.user.isDisposed()) {
            this.user.setText(user);
        }
    }

    public void setCharset(String charset) {
        if (charset != null && this.charset != null && !this.charset.isDisposed()) {
            this.charset.setText(charset);
        }
    }

    @Override
    public void setErrorDisplay(IErrorDisplay display) {
        this.errorDisplay = display;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void validate() {
        this.errorMessage = this.validatePort();
        if (this.errorMessage == null) {
            if (this.user.getText().trim().length() == 0) {
                this.errorMessage = Messages.BasicConnectionWidget_MustSpecifyUser;
            } else if (this.client.getText().trim().length() == 0) {
                this.errorMessage = Messages.BasicConnectionWidget_MustSpecifyClient;
            } else if (this.charset.getText().length() > 0 && !PerforceCharsets.isSupported((String)P4UIUtils.getP4Charset(this.charset.getText()))) {
                this.errorMessage = Messages.BasicConnectionWidget_MustSpecifyCharset;
            }
        }
        if (this.errorDisplay != null) {
            this.errorDisplay.setErrorMessage(this.errorMessage, this);
        }
    }

    private String validatePort() {
        String port = this.port.getText().trim();
        if (port.isEmpty()) {
            return Messages.BasicConnectionWidget_MustSpecifyPort;
        }
        Pattern p = Pattern.compile("((ssl):)?([^:]+):([\\d]+)");
        Matcher m = p.matcher(port);
        if (!m.matches()) {
            return Messages.BasicConnectionWidget_InvalidServerAddress;
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        if (this.port != null && !this.port.isDisposed()) {
            return this.port.isEnabled();
        }
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.port != null && !this.port.isDisposed()) {
            this.port.setEnabled(enabled);
            this.user.setEnabled(enabled);
            this.client.setEnabled(enabled);
            this.charset.setEnabled(enabled);
        }
    }
}

