/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.changelists;

import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.BaseErrorProvider;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.DescriptionViewer;
import com.perforce.team.ui.changelists.Messages;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class PendingCombo
extends BaseErrorProvider {
    private Combo combo;
    private DescriptionViewer comment;
    private IP4PendingChangelist[] changes;
    private int pendingId = -1;
    private String pendingComment = "";
    private String label = Messages.PendingCombo_PendingChangelist;
    private boolean resize = true;
    private IP4Resource resource;
    private int initialSelectedChangeListId;
    private PendingComboSelectionAdapter selectionAdapter;

    public PendingCombo(IP4Resource resource) {
        this(null, resource);
    }

    public PendingCombo(String label, IP4Resource resource) {
        this.resource = resource;
        if (label != null) {
            this.label = label;
        }
    }

    public Combo getCombo() {
        return this.combo;
    }

    public void createControl(Composite parent) {
        this.createControl(parent, null);
    }

    public void createControl(Composite parent, String description) {
        this.createControl(parent, 1, description);
    }

    public void createControl(Composite parent, int hSpan) {
        this.createControl(parent, hSpan, -1);
    }

    public void createControl(Composite parent, int hSpan, String initialDescription) {
        this.createControl(parent, hSpan, -1, initialDescription);
    }

    public void createControl(Composite parent, int hSpan, int selectedId) {
        this.createControl(parent, hSpan, selectedId, null);
    }

    public void createControl(Composite parent, int hSpan, int selectedId, String initialDescription) {
        this.createControl(parent, hSpan, selectedId, initialDescription, true);
    }

    public void createControl(Composite parent, int hSpan, int selectedId, String initialDescription, boolean resizeShell) {
        this.initialSelectedChangeListId = selectedId;
        this.resize = resizeShell;
        Composite changelist = new Composite(parent, 0);
        GridData cData = new GridData(4, 4, true, false);
        cData.horizontalSpan = hSpan;
        changelist.setLayoutData((Object)cData);
        GridLayout cLayout = new GridLayout(2, false);
        changelist.setLayout((Layout)cLayout);
        Label changelistLabel = new Label(changelist, 16384);
        changelistLabel.setText(this.label);
        this.combo = new Combo(changelist, 12);
        this.combo.setLayoutData((Object)new GridData(4, 4, true, false));
        this.combo.add(Messages.PendingCombo_New);
        Label description = new Label(changelist, 0);
        GridData descriptionData = new GridData(4, 0x1000000, false, false);
        descriptionData.exclude = true;
        description.setText(Messages.PendingCombo_Description);
        description.setLayoutData((Object)descriptionData);
        description.setVisible(false);
        this.comment = new DescriptionViewer((IP4Resource)this.resource.getConnection());
        if (initialDescription != null) {
            this.pendingComment = initialDescription;
        }
        this.comment.createControl(changelist, this.pendingComment);
        this.comment.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                PendingCombo.this.pendingComment = PendingCombo.this.comment.getDocument().get();
                PendingCombo.this.validate();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        StyledText styledText = this.comment.getViewer().getTextWidget();
        GridData commentData = (GridData)styledText.getLayoutData();
        commentData.heightHint = P4UIUtils.computePixelHeight(this.comment.getViewer().getTextWidget().getFont(), 5);
        commentData.exclude = true;
        styledText.setLayoutData((Object)commentData);
        styledText.setVisible(false);
        this.bindPendingComboSelectionAdapter(new PendingComboSelectionAdapter(description, commentData, descriptionData, parent, styledText));
        this.initControl();
    }

    public PendingComboSelectionAdapter getPendingComboSelectionAdapter() {
        return this.selectionAdapter;
    }

    public void bindPendingComboSelectionAdapter(PendingComboSelectionAdapter selectionAdpater) {
        this.selectionAdapter = selectionAdpater;
        this.combo.addSelectionListener((SelectionListener)selectionAdpater);
    }

    @Override
    public void validate() {
        this.errorMessage = !this.combo.isEnabled() || this.combo.getSelectionIndex() == 0 && this.pendingComment.length() == 0 ? Messages.PendingCombo_EnterChangelistDescription : null;
        super.validate();
    }

    private void initControl() {
        this.combo.setEnabled(false);
        P4Runner.schedule((IP4Runnable)new P4Runnable(){

            public String getTitle() {
                return "Initialize pending combo...";
            }

            public void run(IProgressMonitor monitor) {
                PendingCombo.this.changes = PendingCombo.this.resource.getConnection().getCachedPendingChangelists();
                Arrays.sort(PendingCombo.this.changes, new Comparator<IP4PendingChangelist>(){

                    @Override
                    public int compare(IP4PendingChangelist o1, IP4PendingChangelist o2) {
                        return o1.getId() - o2.getId();
                    }
                });
                if (PendingCombo.this.changes.length > 0) {
                    PendingCombo.this.pendingId = PendingCombo.this.changes[0].getId();
                }
                PerforceUIPlugin.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!PendingCombo.this.combo.isDisposed()) {
                            int select = 1;
                            boolean activeSet = false;
                            IP4PendingChangelist[] iP4PendingChangelistArray = PendingCombo.this.changes;
                            int n = iP4PendingChangelistArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IP4PendingChangelist list = iP4PendingChangelistArray[n2];
                                PendingCombo.this.combo.add(PendingCombo.this.getText(list));
                                if (list.isActive()) {
                                    select = PendingCombo.this.combo.getItemCount() - 1;
                                    PendingCombo.this.pendingId = list.getId();
                                    activeSet = true;
                                } else if (!activeSet && PendingCombo.this.initialSelectedChangeListId == list.getId()) {
                                    select = PendingCombo.this.combo.getItemCount() - 1;
                                    PendingCombo.this.pendingId = list.getId();
                                }
                                ++n2;
                            }
                            PendingCombo.this.combo.setEnabled(true);
                            PendingCombo.this.combo.select(select);
                            PendingCombo.this.validate();
                        }
                    }
                });
            }
        });
    }

    private String getText(IP4PendingChangelist change) {
        if (change.getId() == 0) {
            return Messages.PendingCombo_Default;
        }
        StringBuilder desc = new StringBuilder();
        desc.append(Messages.PendingCombo_Change);
        desc.append(change.getId());
        String description = change.getShortDescription();
        if (description.length() > 0) {
            desc.append(' ');
            desc.append('{');
            desc.append(' ');
            desc.append(description);
            desc.append(' ');
            desc.append('}');
            desc.append(' ');
        }
        return desc.toString();
    }

    public String getDescription() {
        return this.pendingComment;
    }

    public int getSelected() {
        return this.pendingId;
    }

    public class PendingComboSelectionAdapter
    extends SelectionAdapter {
        private final Label description;
        private final GridData commentData;
        private final GridData descriptionData;
        private final Composite parent;
        private final StyledText styledText;

        public PendingComboSelectionAdapter(Label description, GridData commentData, GridData descriptionData, Composite parent, StyledText styledText) {
            this.description = description;
            this.commentData = commentData;
            this.descriptionData = descriptionData;
            this.parent = parent;
            this.styledText = styledText;
        }

        public PendingComboSelectionAdapter(PendingComboSelectionAdapter selectionAdapter) {
            this(selectionAdapter.description, selectionAdapter.commentData, selectionAdapter.descriptionData, selectionAdapter.parent, selectionAdapter.styledText);
        }

        public void widgetSelected(SelectionEvent e) {
            boolean isNewChangeList;
            int index = PendingCombo.this.combo.getSelectionIndex();
            boolean layout = false;
            boolean bl = isNewChangeList = index == 0;
            if (isNewChangeList) {
                PendingCombo.this.pendingId = -2;
                layout = !this.styledText.isVisible();
                this.toggleDescription(true);
                this.callbackIfIsNewChangeList();
            } else {
                IP4PendingChangelist p4PendingChangelist = PendingCombo.this.changes[index - 1];
                PendingCombo.this.pendingId = p4PendingChangelist.getId();
                layout = this.styledText.isVisible();
                this.toggleDescription(false);
                if (p4PendingChangelist.isDefault()) {
                    this.callbackIfIsDefaultChangeList();
                } else {
                    this.callbackIfIsNormalChangeList();
                }
            }
            if (layout) {
                this.parent.layout(true, true);
                if (PendingCombo.this.resize) {
                    Shell shell = this.parent.getShell();
                    Point size = shell.getSize();
                    Point newSize = shell.computeSize(-1, -1, true);
                    size.y = newSize.y;
                    shell.setSize(size);
                }
            }
            if (this.styledText.isVisible()) {
                this.styledText.setFocus();
            }
            PendingCombo.this.validate();
        }

        private void toggleDescription(boolean isNewChangeList) {
            this.commentData.exclude = !isNewChangeList;
            this.descriptionData.exclude = !isNewChangeList;
            this.styledText.setVisible(isNewChangeList);
            this.description.setVisible(isNewChangeList);
        }

        protected void callbackIfIsNewChangeList() {
        }

        protected void callbackIfIsDefaultChangeList() {
        }

        protected void callbackIfIsNormalChangeList() {
        }
    }
}

