/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.changelists;

import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.ui.BaseHyperlinkDetector;
import com.perforce.team.ui.changelists.Messages;
import com.perforce.team.ui.p4java.actions.ViewChangelistAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class ChangelistHyperlinkDetector
extends BaseHyperlinkDetector {
    public static final String CHANGELIST_REGEX = "(^|\\W)(c|C)hange(list)?( )?#?(\\d+)";
    private Pattern changelistRegex = Pattern.compile("(^|\\W)(c|C)hange(list)?( )?#?(\\d+)");

    private IHyperlink createHyperlink(final IRegion region, final IP4Connection connection, String id) {
        if (connection != null) {
            try {
                final int clId = Integer.parseInt(id);
                if (clId > 0) {
                    return new IHyperlink(){

                        public void open() {
                            ChangelistHyperlinkDetector.this.openChangelist(clId, connection);
                        }

                        public String getTypeLabel() {
                            return null;
                        }

                        public String getHyperlinkText() {
                            return MessageFormat.format(Messages.ChangelistHyperlinkDetector_ViewChangelist, clId);
                        }

                        public IRegion getHyperlinkRegion() {
                            return region;
                        }
                    };
                }
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        return null;
    }

    private void openChangelist(int id, IP4Connection connection) {
        ViewChangelistAction view = new ViewChangelistAction();
        view.view(id, connection);
    }

    @Override
    protected Collection<IHyperlink> generateHyperlinks(String value, int regionOffset, int positionOffset) {
        Matcher matcher = this.changelistRegex.matcher(value);
        ArrayList<IHyperlink> links = null;
        while (matcher.find()) {
            IP4Connection connection;
            Region match;
            IHyperlink link;
            String id;
            int length = matcher.group().length();
            int start = matcher.start();
            String prefix = matcher.group(1);
            if (prefix != null && prefix.length() > 0) {
                ++start;
                --length;
            }
            if (!this.accept(positionOffset, start, length) || (id = matcher.group(5)) == null || (link = this.createHyperlink((IRegion)(match = new Region(start += regionOffset, length)), connection = this.getConnection(), id)) == null) continue;
            if (links == null) {
                links = new ArrayList<IHyperlink>();
            }
            links.add(link);
        }
        return links;
    }
}

