/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.changelists;

import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.changelists.ChangelistDecorator;
import com.perforce.team.ui.changelists.DecoratedChangelistLabelProvider;
import com.perforce.team.ui.changelists.Folder;
import com.perforce.team.ui.changelists.FolderFileLabelProvider;
import com.perforce.team.ui.changelists.Messages;
import com.perforce.team.ui.changelists.StyledChangelistLabelProvider;
import com.perforce.team.ui.diff.DiffSorter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ChangelistFileWidget {
    public static final String TYPE_PREFERENCE = "com.perforce.team.ui.changelists.TYPE_PREFERENCE";
    private Folder.Type type = Folder.Type.COMPRESSED;
    private IP4Resource[] files = new IP4Resource[0];
    private Composite displayArea;
    protected FolderFileLabelProvider labelProvider;
    private TreeViewer viewer;
    private Folder[] tree;
    private Folder[] compressed;

    public ChangelistFileWidget() {
        this.type = this.getTypePreference();
    }

    public IP4Resource[] getFiles() {
        return this.files;
    }

    public int getFileCount() {
        return this.viewer.getTree().getItemCount();
    }

    public void setFiles(IP4Resource[] files) {
        if (files != null) {
            this.files = files;
            this.tree = null;
            this.compressed = null;
        }
    }

    public void generateFileTree() {
        Object[] modelFiles;
        if (this.tree == null && (modelFiles = this.files) != null) {
            this.tree = Folder.buildTree(modelFiles, Folder.Type.TREE);
        }
    }

    public void generateCompressedFileTree() {
        Object[] modelFiles;
        if (this.compressed == null && (modelFiles = this.files) != null) {
            this.compressed = Folder.buildTree(modelFiles, Folder.Type.COMPRESSED);
            Folder.compressFolders(this.compressed);
        }
    }

    public void createControl(Composite parent) {
        this.createControl(parent, null);
    }

    protected ITreeContentProvider createContentProvider(TreeViewer viewer) {
        return new PerforceContentProvider((StructuredViewer)viewer, true, this);
    }

    protected ILabelProvider createDecoratedLabelProvider(TreeViewer viewer) {
        ChangelistDecorator decorator = new ChangelistDecorator(true);
        this.labelProvider = this.createLabelProvider(viewer);
        StyledChangelistLabelProvider styledProvider = new StyledChangelistLabelProvider(this.labelProvider);
        DecoratedChangelistLabelProvider decorated = new DecoratedChangelistLabelProvider(this.labelProvider, styledProvider, decorator);
        decorated.setAddDecorations(false);
        return decorated;
    }

    protected FolderFileLabelProvider createLabelProvider(TreeViewer viewer) {
        return new FolderFileLabelProvider(this.type);
    }

    protected void configureViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
    }

    protected TreeViewer createViewer(Composite parent) {
        return new TreeViewer(parent, 2818);
    }

    protected void fillToolbar(ToolBar toolbar) {
        ToolItem flatMode = new ToolItem(toolbar, 16);
        Image flatImage = PerforceUIPlugin.getDescriptor("normal/flat_layout.png").createImage();
        P4UIUtils.registerDisposal((Widget)flatMode, (Resource)flatImage);
        flatMode.setImage(flatImage);
        flatMode.setToolTipText(Messages.ChangelistFileWidget_FlatMode);
        flatMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangelistFileWidget.this.setType(Folder.Type.FLAT);
            }
        });
        if (this.type == Folder.Type.FLAT) {
            flatMode.setSelection(true);
        }
        ToolItem treeMode = new ToolItem(toolbar, 16);
        Image treeImage = PerforceUIPlugin.getDescriptor("normal/tree_layout.png").createImage();
        P4UIUtils.registerDisposal((Widget)treeMode, (Resource)treeImage);
        treeMode.setImage(treeImage);
        treeMode.setToolTipText(Messages.ChangelistFileWidget_TreeMode);
        treeMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangelistFileWidget.this.setType(Folder.Type.TREE);
            }
        });
        if (this.type == Folder.Type.TREE) {
            treeMode.setSelection(true);
        }
        ToolItem compressedMode = new ToolItem(toolbar, 16);
        Image compressedImage = PerforceUIPlugin.getDescriptor("normal/compressed_folders_layout.png").createImage();
        P4UIUtils.registerDisposal((Widget)compressedMode, (Resource)compressedImage);
        compressedMode.setImage(compressedImage);
        compressedMode.setToolTipText(Messages.ChangelistFileWidget_CompressedMode);
        compressedMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangelistFileWidget.this.setType(Folder.Type.COMPRESSED);
            }
        });
        if (this.type == Folder.Type.COMPRESSED) {
            compressedMode.setSelection(true);
        }
        new ToolItem(toolbar, 2);
        this.createExpandOptions(toolbar);
    }

    protected void createExpandOptions(ToolBar toolbar) {
        ToolItem expand = new ToolItem(toolbar, 8);
        Image expandImage = PerforceUIPlugin.getDescriptor("normal/expandall.png").createImage();
        P4UIUtils.registerDisposal((Widget)expand, (Resource)expandImage);
        expand.setImage(expandImage);
        expand.setToolTipText(Messages.ChangelistFileWidget_ExpandAll);
        expand.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangelistFileWidget.this.viewer.expandAll();
            }
        });
        ToolItem collapse = new ToolItem(toolbar, 8);
        collapse.setToolTipText(Messages.ChangelistFileWidget_CollapseAll);
        Image collapseImage = PerforceUIPlugin.getDescriptor("normal/collapseall.png").createImage();
        P4UIUtils.registerDisposal((Widget)collapse, (Resource)collapseImage);
        collapse.setImage(collapseImage);
        collapse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChangelistFileWidget.this.viewer.collapseAll();
            }
        });
    }

    protected void createToolbar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 0x800040);
        this.fillToolbar(toolbar);
    }

    public void createControl(Composite parent, ViewerFilter filter) {
        this.displayArea = new Composite(parent, 0);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createToolbar(this.displayArea);
        this.viewer = this.createViewer(this.displayArea);
        if (filter != null) {
            this.viewer.addFilter(filter);
        }
        GridData vData = new GridData(4, 4, true, true);
        vData.heightHint = 80;
        this.viewer.getTree().setLayoutData((Object)vData);
        this.viewer.setSorter((ViewerSorter)new DiffSorter());
        this.viewer.setContentProvider((IContentProvider)this.createContentProvider(this.viewer));
        this.viewer.setLabelProvider((IBaseLabelProvider)this.createDecoratedLabelProvider(this.viewer));
        this.configureViewer(this.viewer);
    }

    public void setType(Folder.Type type) {
        if (type != null && type != this.type) {
            this.type = type;
            if (this.labelProvider != null) {
                this.labelProvider.setType(this.type);
            }
            this.refreshInput();
            this.saveTypePreference();
        }
    }

    public void refreshInput() {
        Object[] input = null;
        IP4Resource[] modelFiles = this.files;
        if (modelFiles != null) {
            switch (this.type) {
                case FLAT: {
                    input = modelFiles;
                    break;
                }
                case TREE: {
                    input = this.tree;
                    break;
                }
                case COMPRESSED: {
                    input = this.compressed;
                    break;
                }
            }
        }
        if (input == null) {
            input = PerforceContentProvider.EMPTY;
        }
        this.viewer.setInput((Object)input);
        this.updateExpansionState();
    }

    protected void updateExpansionState() {
        TreeItem[] treeItemArray = this.getViewer().getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.expand(item);
            ++n2;
        }
    }

    protected void expand(TreeItem item) {
        if (item.getData() instanceof Folder) {
            this.getViewer().expandToLevel(item.getData(), 1);
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                this.expand(child);
                ++n2;
            }
        }
    }

    public Folder.Type getType() {
        return this.type;
    }

    public Composite getControl() {
        return this.displayArea;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public Tree getTree() {
        return this.viewer.getTree();
    }

    public void refresh() {
        this.viewer.refresh();
    }

    protected Folder.Type getTypePreference() {
        Folder.Type type = Folder.Type.FLAT;
        String value = PerforceUIPlugin.getPlugin().getPreferenceStore().getString(this.getTypePreferenceKey());
        try {
            type = Folder.Type.valueOf(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    protected void saveTypePreference() {
        Folder.Type type = this.getType();
        if (type != null) {
            PerforceUIPlugin.getPlugin().getPreferenceStore().setValue(this.getTypePreferenceKey(), type.toString());
        }
    }

    protected String getTypePreferenceKey() {
        return TYPE_PREFERENCE;
    }

    public void showLoading() {
        IContentProvider provider = this.viewer.getContentProvider();
        if (provider instanceof PerforceContentProvider) {
            this.viewer.setInput((Object)new PerforceContentProvider.Loading());
        }
    }
}

