/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.branches;

import com.perforce.p4java.core.IBranchMapping;
import com.perforce.p4java.core.IBranchSpec;
import com.perforce.p4java.core.IMapEntry;
import com.perforce.p4java.core.ViewMap;
import com.perforce.p4java.impl.generic.core.BranchSpec;
import com.perforce.team.ui.branches.BranchWidget;
import com.perforce.team.ui.dialogs.P4FormDialog;
import java.util.StringTokenizer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class BaseBranchDialog
extends P4FormDialog {
    private BranchWidget widget;

    public BaseBranchDialog(Shell parent) {
        super(parent);
        this.setModalResizeStyle();
    }

    public BaseBranchDialog(Shell parent, String title) {
        super(parent, title);
        this.setModalResizeStyle();
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        Composite displayArea = new Composite(c, 0);
        displayArea.setLayout((Layout)new GridLayout(1, true));
        GridData daData = new GridData(4, 4, true, true);
        daData.minimumWidth = 600;
        displayArea.setLayoutData((Object)daData);
        this.widget = new BranchWidget(displayArea);
        this.widget.addFormNameValidation(this);
        this.fillWidget(this.widget);
        return c;
    }

    private ViewMap<IBranchMapping> getBranchView() {
        ViewMap view = new ViewMap();
        StringTokenizer tokenizer = new StringTokenizer(this.widget.getView(), "\r\n");
        int count = 0;
        while (tokenizer.hasMoreElements()) {
            view.addEntry((IMapEntry)new BranchSpec.BranchViewMapping(count, tokenizer.nextToken()));
            ++count;
        }
        return view;
    }

    protected IBranchSpec getLatestSpec() {
        BranchSpec spec = new BranchSpec();
        spec.setName(this.widget.getBranchName());
        spec.setLocked(this.widget.isLocked());
        spec.setDescription(this.widget.getDescription());
        spec.setBranchView(this.getBranchView());
        spec.setOwnerName(this.widget.getOwner());
        return spec;
    }

    protected abstract void fillWidget(BranchWidget var1);

    @Override
    protected String getModelLabel() {
        return "branch";
    }
}

