/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.actions;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.actions.stub.TeamActionCopy;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IWorkbenchPage;

public abstract class PerforceTeamAction
extends TeamActionCopy {
    private static WeakHashMap<IAction, PerforceTeamAction> storedActions = new WeakHashMap();

    protected IP4Resource getP4Resource(Object obj) {
        return (IP4Resource)P4CoreUtils.convert((Object)obj, IP4Resource.class);
    }

    protected IP4File getP4File(Object obj) {
        return (IP4File)P4CoreUtils.convert((Object)obj, IP4File.class);
    }

    @Override
    protected IResource getResource(Object obj) {
        return (IResource)P4CoreUtils.convert((Object)obj, IResource.class);
    }

    @Override
    protected Shell getShell() {
        Shell s = super.getShell();
        if (s != null) {
            return s;
        }
        s = P4UIUtils.getShell();
        if (s != null) {
            return s;
        }
        if (Display.getCurrent() != null) {
            return Display.getCurrent().getActiveShell();
        }
        return null;
    }

    @Override
    protected IStructuredSelection getSelection() {
        return super.getSelection();
    }

    @Override
    protected IProject[] getSelectedProjects() {
        return super.getSelectedProjects();
    }

    @Override
    protected IResource[] getSelectedResources() {
        return super.getSelectedResources();
    }

    @Override
    protected IWorkbenchPage getTargetPage() {
        return super.getTargetPage();
    }

    public static void refreshActionState() {
        for (IAction delegate : storedActions.keySet()) {
            PerforceTeamAction action = storedActions.get(delegate);
            action.setActionEnablement(delegate);
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (action != null) {
            storedActions.put(action, this);
        }
    }

    @Override
    protected void setActionEnablement(IAction action) {
        try {
            action.setEnabled(this.isEnabledEx());
        }
        catch (TeamException e) {
            if (e.getStatus().getCode() == 274) {
                action.setEnabled(true);
            }
            action.setEnabled(false);
            PerforceProviderPlugin.log((IStatus)e.getStatus());
        }
    }

    protected Hashtable<RepositoryProvider, List<IResource>> getProviderMapping() {
        return this.getProviderMapping(this.getSelectedResources());
    }

    @Override
    protected Hashtable<RepositoryProvider, List<IResource>> getProviderMapping(IResource[] resources) {
        Hashtable<RepositoryProvider, List<IResource>> result = new Hashtable<RepositoryProvider, List<IResource>>();
        int i = 0;
        while (i < resources.length) {
            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resources[i].getProject());
            List<IResource> list = result.get(provider);
            if (list == null) {
                list = new ArrayList<IResource>();
                result.put(provider, list);
            }
            list.add(resources[i]);
            ++i;
        }
        return result;
    }

    @Override
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        this.run(action);
    }

    protected abstract boolean isEnabledEx() throws TeamException;

    @Override
    public abstract void run(IAction var1);
}

