/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.PropertyTesters;

import com.perforce.p4java.core.IStreamSummary;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.streams.StreamsView;
import com.perforce.team.ui.streams.StreamsViewControl;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.preference.IPreferenceStore;

public class StreamPropertyTester
extends PropertyTester {
    public static String CAN_COPY_TO_STREAM = "canCopyToStream";
    public static String CAN_MERGE_TO_STREAM = "canMergeToStream";
    public static String CAN_CREATE_STREAM_FROM = "canCreateStreamFrom";
    public static String CAN_WORKIN = "canWorkinStream";
    public static String CAN_RELOAD = "canReload";
    public static String CAN_UNLOAD = "canUnload";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean enable = false;
        if (receiver instanceof IP4Stream) {
            IP4Stream p4stream = (IP4Stream)receiver;
            IStreamSummary targetStream = p4stream.getStreamSummary();
            String clientStream = p4stream.getConnection().getClient().getStream();
            IP4Connection conn = p4stream.getConnection();
            if (CAN_COPY_TO_STREAM.equals(property) || CAN_MERGE_TO_STREAM.equals(property)) {
                if (CAN_COPY_TO_STREAM.equals(property) && targetStream.getType() == IStreamSummary.Type.TASK) {
                    return false;
                }
                String parent = targetStream.getParent();
                if (CAN_MERGE_TO_STREAM.equals(property) && targetStream.getType() == IStreamSummary.Type.TASK && ("none".equals(parent) || StringUtils.isEmpty((CharSequence)parent))) {
                    return false;
                }
                if (targetStream.getStream().equals(clientStream)) {
                    enable = true;
                } else if (conn != null && conn.isSandbox()) {
                    enable = true;
                } else {
                    IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
                    String opt = store.getString("pref_client_switch_on_stream_option");
                    if ("diffStreamSameClient".equals(opt)) {
                        enable = true;
                    }
                }
            } else if (CAN_CREATE_STREAM_FROM.equals(property)) {
                if (IStreamSummary.Type.TASK != targetStream.getType()) {
                    enable = true;
                }
            } else if (CAN_RELOAD.equals(property)) {
                StreamsViewControl control;
                StreamsView view;
                if (IStreamSummary.Type.TASK == targetStream.getType() && (view = StreamsView.findView()) != null && (control = view.getPerforceViewControl()) != null && control.isShownUnloadedOnly()) {
                    enable = true;
                }
            } else if (CAN_UNLOAD.equals(property)) {
                if (IStreamSummary.Type.TASK == targetStream.getType()) {
                    enable = true;
                }
            } else if (CAN_WORKIN.equals(property) && !targetStream.getStream().equals(clientStream)) {
                enable = true;
            }
        }
        return enable;
    }
}

