/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.P4SecureStore;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.PerforceTeamProvider;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.synchronize.P4ChangeSetManager;
import com.perforce.team.ui.FileModificationValidatorManager;
import com.perforce.team.ui.LogListener;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceMarkerManager;
import com.perforce.team.ui.decorator.PerforceDecorator;
import com.perforce.team.ui.p4java.actions.RefreshAction;
import com.perforce.team.ui.refactor.MoveDeleteManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.util.Tracing;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

public class PerforceUIPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String ID = "com.perforce.team.ui";
    public static final String IGNORE_SSL = "IGNORE_SSL";
    public static final String CONTEXT_PENDING_VIEW = "com.perforce.team.ui.PendingChangelistView";
    private Map<String, ImageDescriptor> imageDescriptors = new HashMap<String, ImageDescriptor>(32);
    private static PerforceUIPlugin instance;
    private PerforceMarkerManager markerManager;
    private LogListener logListener;
    private IExecutionListener refreshListener = new IExecutionListener(){

        public void notHandled(String commandId, NotHandledException exception) {
        }

        public void postExecuteFailure(String commandId, ExecutionException exception) {
        }

        public void postExecuteSuccess(String commandId, Object returnValue) {
            if ("org.eclipse.ui.file.refresh".equals(commandId)) {
                final ISelection selection = PerforceUIPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection();
                Tracing.printTrace((String)"REFRESH:postExec", (String)("Selection= " + PerforceUIPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection()));
                try {
                    if (PerforceUIPlugin.refreshRevisionOnRefresh()) {
                        PerforceUIPlugin.getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    RefreshAction refresh = new RefreshAction();
                                    refresh.setAsync(false);
                                    refresh.selectionChanged(null, selection);
                                    refresh.run(null);
                                }
                                catch (Exception e) {
                                    PerforceProviderPlugin.logWarning((Throwable)e);
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    PerforceProviderPlugin.logWarning((Throwable)e);
                }
            }
        }

        public void preExecute(String commandId, ExecutionEvent event) {
            Tracing.printTrace((String)"REFRESH:preExec", (String)("Selection= " + PerforceUIPlugin.getActiveWorkbenchWindow().getSelectionService().getSelection()));
        }
    };

    public PerforceUIPlugin() {
        instance = this;
        this.logListener = new LogListener();
    }

    public static ImageDescriptor getDescriptor(String id) {
        return PerforceUIPlugin.getPlugin().getImageDescriptor(id);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.logListener.init();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        this.markerManager = new PerforceMarkerManager();
        workspace.addResourceChangeListener((IResourceChangeListener)this.markerManager, 16);
        workspace.addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                PerforceUIPlugin.this.updateDecorator(event);
            }
        }, 1);
        PerforceTeamProvider.registerFileModicationsValidator((FileModificationValidator)new FileModificationValidatorManager());
        PerforceTeamProvider.registerMoveDeleteHook((IMoveDeleteHook)new MoveDeleteManager());
    }

    private void updateDecorator(IResourceChangeEvent event) {
        IResourceDelta[] resourceDelta = event.getDelta().getAffectedChildren();
        int i = 0;
        while (i < resourceDelta.length) {
            PerforceDecorator decorator;
            boolean fopened;
            IResourceDelta delta = resourceDelta[i];
            int flags = delta.getFlags();
            IResource resource = delta.getResource();
            boolean bl = fopened = (flags & 0x4000) != 0;
            if (resource instanceof IProject && fopened && (decorator = PerforceDecorator.getActivePerforceDecorator()) != null) {
                decorator.resourceStateChanged(new IResource[]{resource});
            }
            ++i;
        }
    }

    public void stop(BundleContext context) throws Exception {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener((IResourceChangeListener)this.markerManager);
        PerforceTeamProvider.registerFileModicationsValidator(null);
        P4ChangeSetManager.getChangeSetManager().dispose();
        this.removeRefreshListener();
        super.stop(context);
    }

    public static PerforceUIPlugin getPlugin() {
        return instance;
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static boolean isUIThread() {
        return Display.findDisplay((Thread)Thread.currentThread()) != null;
    }

    public static void asyncExec(Runnable code) {
        PerforceUIPlugin.getDisplay().asyncExec(code);
    }

    public static void syncExec(Runnable code) {
        PerforceUIPlugin.getDisplay().syncExec(code);
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PerforceUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = PerforceUIPlugin.getActiveWorkbenchWindow();
        return window == null ? null : window.getActivePage();
    }

    public static ILabelDecorator getLabelDecorator() {
        return PerforceUIPlugin.getPlugin().getWorkbench().getDecoratorManager().getLabelDecorator();
    }

    public void saveSettings() {
        super.saveDialogSettings();
    }

    public static void saveDirtyResources(IWorkbenchPage page, String[] paths) {
        IEditorPart[] editors = page.getDirtyEditors();
        HashMap<IFile, IEditorPart> editorLookup = new HashMap<IFile, IEditorPart>();
        int i = 0;
        while (i < editors.length) {
            IEditorInput input = editors[i].getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)input).getFile();
                editorLookup.put(file, editors[i]);
            }
            ++i;
        }
        IFile[] resourceFiles = PerforceProviderPlugin.getWorkspaceFiles((String[])paths);
        int i2 = 0;
        while (i2 < resourceFiles.length) {
            IEditorPart editor = (IEditorPart)editorLookup.get(resourceFiles[i2]);
            if (editor != null) {
                page.saveEditor(editor, true);
            }
            ++i2;
        }
    }

    public static void saveDirtyResources(IWorkbenchPage page, IP4File[] p4Files) {
        if (p4Files != null) {
            IP4File[] iP4FileArray = p4Files;
            int n = p4Files.length;
            int n2 = 0;
            while (n2 < n) {
                IP4File file = iP4FileArray[n2];
                PerforceUIPlugin.saveDirtyResources(page, file.getLocalFiles());
                ++n2;
            }
        }
    }

    public static void saveDirtyResources(IWorkbenchPage page, IFile[] files) {
        if (files != null) {
            List<IFile> list = Arrays.asList(files);
            IEditorPart[] editors = page.getDirtyEditors();
            int i = 0;
            while (i < editors.length) {
                IFile file;
                IEditorInput input = editors[i].getEditorInput();
                if (input instanceof IFileEditorInput && list.contains(file = ((IFileEditorInput)input).getFile())) {
                    page.saveEditor(editors[i], true);
                }
                ++i;
            }
        }
    }

    public static void log(IStatus status) {
        PerforceUIPlugin.getPlugin().getLog().log(status);
    }

    public static void handleError(String message, Throwable throwable, boolean show) {
        Status status = new Status(4, ID, message, throwable);
        int style = 1;
        if (show) {
            style |= 2;
        }
        StatusManager.getManager().handle((IStatus)status, style);
    }

    public static void showError(String message, Throwable throwable) {
        Status status = new Status(4, ID, message, throwable);
        StatusManager.getManager().handle((IStatus)status, 2);
    }

    private void createImageDescriptor(String id, URL root) {
        try {
            URL url = new URL(root, "icons/" + id);
            this.imageDescriptors.put(id, ImageDescriptor.createFromURL((URL)url));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public ImageDescriptor getImageDescriptor(String id) {
        if (this.imageDescriptors.get(id) == null) {
            URL root = this.getBundle().getEntry("/");
            this.createImageDescriptor(id, root);
        }
        return this.imageDescriptors.get(id);
    }

    public static Image getImage(String pluginRelativePath) {
        String resourcePath;
        ImageRegistry registry = JFaceResources.getImageRegistry();
        Image image = registry.get(resourcePath = "com.perforce.team.ui/" + pluginRelativePath);
        if (image == null) {
            try {
                URL url = new URL(PerforceUIPlugin.getPlugin().getBundle().getEntry("/"), pluginRelativePath);
                if (url != null) {
                    image = new Image((Device)Display.getCurrent(), url.openStream());
                }
                registry.put(resourcePath, image);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return image;
    }

    public static void storePasswordInUI(final ConnectionParameters params) {
        P4UIUtils.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    String pw = params.peekPassword();
                    String key = params.getStorageKey();
                    if (params.savePassword() && pw != null && !pw.isEmpty()) {
                        P4SecureStore.INSTANCE.put(key, pw, true);
                    }
                }
                catch (StorageException e) {
                    PerforceProviderPlugin.logError((Throwable)e);
                    try {
                        P4SecureStore.INSTANCE.remove(params.getStorageKey());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void earlyStartup() {
        this.registerRefreshListener();
    }

    private void registerRefreshListener() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        if (commandService != null) {
            commandService.addExecutionListener(this.refreshListener);
        }
    }

    private void removeRefreshListener() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        if (commandService != null) {
            commandService.removeExecutionListener(this.refreshListener);
        }
    }

    public static boolean refreshRevisionOnRefresh() {
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        return store.getBoolean("pref_refresh_revision_on_refresh");
    }
}

