/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui;

import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Connection;
import com.perforce.team.core.p4java.P4Depot;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4IntegrationOptions;
import com.perforce.team.core.p4java.P4IntegrationOptions2;
import com.perforce.team.core.p4java.P4IntegrationOptions3;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.ui.Messages;
import com.perforce.team.ui.P4ConnectionManager;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.decorator.PerforceDecorator;
import com.perforce.team.ui.dialogs.SwitchClientConfirmDialog;
import com.perforce.team.ui.p4java.actions.SyncAction;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;

public class P4TeamUtils {
    public static boolean shareProject(IProject project, ConnectionParameters params) {
        boolean ret = false;
        if (project != null && params != null) {
            PerforceDecorator decorator;
            try {
                PerforceDecorator.suspendDecoration();
                ret = PerforceProviderPlugin.manageProject((IProject)project, (ConnectionParameters)params);
                if (ret) {
                    P4ConnectionManager.getManager().getConnection(project);
                }
            }
            finally {
                PerforceDecorator.unsuspendDecoration();
            }
            if (ret && (decorator = PerforceDecorator.getActivePerforceDecorator()) != null) {
                decorator.resourceStateChanged(new IResource[]{project});
            }
        }
        return ret;
    }

    public static void syncWorkspace(IP4Connection connection, boolean force) {
        SyncAction action = new SyncAction();
        action.setAsync(true);
        action.setForce(true);
        connection.clearCache();
        action.setCollection(action.getCollection(connection.getMappedProjects()));
        action.runAction();
    }

    public static P4IntegrationOptions createDefaultIntegration(IP4Connection connection) {
        Object options = null;
        IServer server = connection.getServer();
        String stream = connection.getClient().getStream();
        if (stream != null && !stream.trim().isEmpty()) {
            options = new P4IntegrationOptions3();
        } else {
            int serverVer = server.getServerVersionNumber();
            String level = null;
            try {
                IServerInfo info = server.getServerInfo();
                level = info.getIntegEngine();
            }
            catch (Exception e) {
                PerforceProviderPlugin.logError((String)e.getLocalizedMessage());
                PerforceUIPlugin.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError(null, (String)Messages.P4TeamUtils_Error, (String)Messages.P4TeamUtils_CannotRetrieveEngineInfo);
                    }
                });
            }
            options = level == null ? (serverVer < 20111 ? new P4IntegrationOptions2() : new P4IntegrationOptions3()) : ("2".equals(level.trim()) ? new P4IntegrationOptions2() : ("3".equals(level.trim()) ? new P4IntegrationOptions3() : null));
        }
        return options;
    }

    public static String getStream(IP4Resource resource) {
        if (resource == null) {
            return null;
        }
        if (resource.getParent() instanceof P4Depot) {
            P4Depot depot = (P4Depot)resource.getParent();
            if (depot.getType() == IDepot.DepotType.STREAM) {
                return "//" + depot.getName() + "/" + resource.getName();
            }
        } else if (resource.getParent() instanceof P4Connection) {
            String[] segments;
            String path;
            P4Connection conn = (P4Connection)resource.getParent();
            if (!StringUtils.isEmpty((CharSequence)conn.getClient().getStream()) && (path = resource.getActionPath(IP4Resource.Type.REMOTE)) != null && (segments = path.substring(2).split("/")).length >= 2) {
                return "//" + segments[0] + "/" + segments[1];
            }
            return null;
        }
        return P4TeamUtils.getStream((IP4Resource)resource.getParent());
    }

    public static boolean processClientChange(IP4Connection connection, Shell shell, boolean force, String promptMsg) {
        boolean switched = false;
        IPreferenceStore store = PerforceUIPlugin.getPlugin().getPreferenceStore();
        String switchOpt = store.getString("pref_client_switch_option");
        if (!"never".equals(switchOpt)) {
            if ("prompt".equals(switchOpt)) {
                final SwitchClientConfirmDialog switchDlg = new SwitchClientConfirmDialog(shell);
                if (promptMsg != null) {
                    switchDlg.setDescription(promptMsg);
                }
                final boolean[] sync = new boolean[1];
                if (shell.getDisplay().getThread() == Thread.currentThread()) {
                    if (switchDlg.open() == 0) {
                        sync[0] = switchDlg.isAutoSync();
                    }
                } else {
                    PerforceUIPlugin.syncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (switchDlg.open() == 0) {
                                sync[0] = switchDlg.isAutoSync();
                            }
                        }
                    });
                }
                if (sync[0]) {
                    P4TeamUtils.syncWorkspace(connection, force);
                    switched = true;
                }
            } else if ("always".equals(switchOpt)) {
                P4TeamUtils.syncWorkspace(connection, force);
                switched = true;
            }
        }
        if (switched) {
            P4Collection collection = new P4Collection();
            collection.add((IP4Resource)connection);
            collection.refreshLocalResources(2);
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, (IP4Resource)connection));
        }
        return switched;
    }
}

