/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelveFile;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.P4Resource;
import com.perforce.team.core.p4java.P4ShelvedChangelist;
import java.io.InputStream;
import java.util.Date;

public class P4ShelveFile
extends P4Resource
implements IP4ShelveFile {
    public static final String SHELVE_SPECIFIER = "@=";
    private IP4ShelvedChangelist shelvedList;
    private IChangelist list;
    private IP4File file;

    public P4ShelveFile(IChangelist list, IP4File file, boolean readOnly) {
        this.list = list;
        this.file = file;
        this.shelvedList = new P4ShelvedChangelist(this.getConnection(), list, readOnly);
        this.readOnly = readOnly;
    }

    public Object getAdapter(Class adapter) {
        if (IP4File.class == adapter) {
            return this.file;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IP4ShelveFile)) {
            return false;
        }
        return super.equals(obj) && this.getId() == ((IP4ShelveFile)obj).getId();
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 31 + this.getId();
    }

    @Override
    public IP4File getFile() {
        return this.file;
    }

    @Override
    public int getId() {
        return this.list.getId();
    }

    @Override
    public Date getDate() {
        return this.list.getDate();
    }

    @Override
    public String getDescription() {
        return this.list.getDescription();
    }

    @Override
    public String getUser() {
        return this.list.getUsername();
    }

    @Override
    public String getWorkspace() {
        return this.list.getClientId();
    }

    @Override
    public InputStream getRemoteContents() {
        return this.file.getRemoteContents(this.getRevision());
    }

    @Override
    public String getActionPath() {
        return this.file.getActionPath();
    }

    @Override
    public String getActionPath(IP4Resource.Type preferredType) {
        return this.file.getActionPath(preferredType);
    }

    @Override
    public IClient getClient() {
        return this.file.getClient();
    }

    @Override
    public String getClientPath() {
        return this.file.getClientPath();
    }

    @Override
    public IP4Connection getConnection() {
        return this.file.getConnection();
    }

    @Override
    public String getLocalPath() {
        return this.file.getLocalPath();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public IP4Container getParent() {
        return this.file.getParent();
    }

    @Override
    public String getRemotePath() {
        return this.file.getRemotePath();
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public void refresh(int depth) {
        this.refresh();
    }

    @Override
    public void refresh() {
    }

    @Override
    public String getRevision() {
        return SHELVE_SPECIFIER + this.list.getId();
    }

    @Override
    public IP4ShelvedChangelist getChangelist() {
        return this.shelvedList;
    }

    @Override
    public IFileSpec[] unshelve() {
        return this.unshelve(-1);
    }

    @Override
    public IFileSpec[] unshelve(int toChangelist) {
        return this.unshelve(toChangelist, false);
    }

    public String toString() {
        return this.file.toString();
    }

    @Override
    public IFileSpec[] unshelve(int toChangelist, boolean overwrite) {
        return this.shelvedList.unshelve(new IP4ShelveFile[]{this}, toChangelist, overwrite);
    }

    @Override
    public boolean isFile() {
        return true;
    }
}

