/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.FileStatOutputOptions;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.option.changelist.SubmitOptions;
import com.perforce.p4java.server.CmdSpec;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.callback.IStreamingCallback;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.Policy;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.Messages;
import com.perforce.team.core.p4java.P4Changelist;
import com.perforce.team.core.p4java.P4ClientOperation;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.core.p4java.P4Job;
import com.perforce.team.core.p4java.P4ProgressListener;
import com.perforce.team.core.p4java.P4ShelvedChangelist;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class P4PendingChangelist
extends P4Changelist
implements IP4PendingChangelist {
    private IP4ShelvedChangelist shelved;
    private final String changelistUser;
    private final String changelistClient;
    private boolean hasReview;

    public P4PendingChangelist(IP4Connection connection, IChangelist list, boolean onClient) {
        super(connection, list);
        boolean bl = this.readOnly = !onClient;
        if (list != null) {
            if (connection.isShelvingSupported()) {
                this.shelved = new P4ShelvedChangelist(connection, list, this.readOnly);
            }
            this.changelistUser = list.getUsername();
            this.changelistClient = list.getClientId();
        } else {
            this.changelistUser = null;
            this.changelistClient = null;
        }
    }

    @Override
    public void setHasReview(boolean hasReview) {
        this.hasReview = hasReview;
    }

    @Override
    public boolean hasReview() {
        return this.hasReview;
    }

    @Override
    public String getClientName() {
        return this.changelistClient;
    }

    @Override
    public String getUserName() {
        return this.changelistUser;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof IP4PendingChangelist && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public IP4Resource[] getFiles() {
        return this.getPendingFiles();
    }

    @Override
    public IP4File[] getPendingFiles() {
        ArrayList<IP4File> files = new ArrayList<IP4File>();
        IP4Resource[] iP4ResourceArray = this.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File) {
                files.add((IP4File)resource);
            }
            ++n2;
        }
        return files.toArray(new IP4File[files.size()]);
    }

    @Override
    public IP4Resource[] members() {
        if (this.isOnClient()) {
            IP4Connection connection = this.getConnection();
            if (connection != null) {
                return connection.getOpenedManager().getResources(this.getId());
            }
            return IP4Resource.EMPTY;
        }
        return super.members();
    }

    @Override
    public int size() {
        IP4Connection connection;
        if (this.isOnClient() && (connection = this.getConnection()) != null) {
            return connection.getOpenedManager().getSize(this.getId());
        }
        return super.size();
    }

    @Override
    public void reopen(IP4Resource[] resources) {
        final int id = this.getId();
        if (resources != null && id > -1) {
            ArrayList<String> paths = new ArrayList<String>();
            IP4Resource[] iP4ResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                String path = resource.getActionPath();
                if (path != null) {
                    paths.add(path);
                }
                ++n2;
            }
            final List<IFileSpec> specs = P4FileSpecBuilder.makeFileSpecList(paths.toArray(new String[0]));
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    client.reopenFiles(specs, id, null);
                }
            };
            this.runOperation(operation);
        }
    }

    @Override
    public boolean removeFile(IP4File file) {
        boolean removed = false;
        if (this.isOnClient()) {
            IP4Connection connection = this.getConnection();
            if (connection != null) {
                removed = connection.getOpenedManager().remove(this.getId(), file);
            }
        } else {
            removed = this.cachedFiles.remove(file);
        }
        return removed;
    }

    @Override
    public void addFile(IP4File file) {
        if (this.isOnClient()) {
            IP4Connection connection = this.getConnection();
            if (connection != null) {
                connection.getOpenedManager().addFile(this.getId(), file);
            }
        } else {
            this.cachedFiles.add(file);
        }
    }

    @Override
    public int submit(String description, IP4File[] subset, IProgressMonitor monitor) {
        return this.submit(description, subset, null, monitor);
    }

    @Override
    public int submit(String description, IP4File[] files, IP4Job[] jobs, IProgressMonitor monitor) {
        return this.submit(false, description, files, jobs, monitor);
    }

    @Override
    public int submit(boolean reopen, String description, IP4File[] files, IP4Job[] jobs, IProgressMonitor monitor) {
        return this.submit(reopen, description, files, jobs, null, monitor);
    }

    @Override
    public void revert() {
        final int id = this.getId();
        if (this.isOnClient() && id > -1) {
            final List<IFileSpec> specs = P4FileSpecBuilder.makeFileSpecList(new String[]{"//..."});
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    client.revertFiles(specs, false, id, false, false);
                }
            };
            this.runOperation(operation);
        }
    }

    private void sendSubmitJobEvent(IP4Job[] jobs) {
        if (jobs != null && jobs.length > 0) {
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.SUBMIT_JOB, jobs));
        }
    }

    private void sendSubmitChangelistEvent(List<IP4Resource> resources) {
        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.SUBMIT_CHANGELIST, resources.toArray(new IP4Resource[resources.size()])));
    }

    @Override
    public int submit(final boolean reopen, final String description, final IP4File[] files, final IP4Job[] jobs, final String jobStatus, final IProgressMonitor monitor) {
        monitor.beginTask("submit", 500);
        monitor.worked(100);
        final int[] submittedId = new int[]{-1};
        final IP4Connection connection = this.getConnection();
        if (!this.isReadOnly() && connection != null && files != null && files.length > 0) {
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    IServer server = client.getServer();
                    if (server != null) {
                        IP4Resource file;
                        int n;
                        IP4Resource[] iP4ResourceArray;
                        ArrayList<IP4File> remaining = new ArrayList<IP4File>();
                        IP4File[] iP4FileArray = files;
                        int n2 = files.length;
                        int n3 = 0;
                        while (n3 < n2) {
                            IP4File file2 = iP4FileArray[n3];
                            remaining.add(file2);
                            ++n3;
                        }
                        String[] paths = new String[files.length];
                        int i = 0;
                        while (i < paths.length) {
                            paths[i] = files[i].getRemotePath();
                            ++i;
                        }
                        List<IFileSpec> specs = P4FileSpecBuilder.makeFileSpecList(paths);
                        IChangelist created = null;
                        int currentId = -1;
                        if (P4PendingChangelist.this.changelist != null) {
                            currentId = P4PendingChangelist.this.changelist.getId();
                            created = P4PendingChangelist.this.changelist;
                            if (description != null) {
                                created.setDescription(description);
                            }
                        } else {
                            Changelist cl = new Changelist();
                            cl.setId(0);
                            cl.setClientId(client.getName());
                            cl.setDescription(description);
                            cl.setUsername(server.getUserName());
                            created = cl;
                        }
                        if (server instanceof Server && created instanceof Changelist) {
                            ((Changelist)created).setServerImpl((Server)server);
                        }
                        List current = created.getFiles(false);
                        current.clear();
                        for (IFileSpec spec : specs) {
                            spec.setDepotPath(spec.getOriginalPathString());
                        }
                        current.addAll(specs);
                        final ArrayList<IFileSpec> submittedSpecs = new ArrayList<IFileSpec>();
                        final IChangelist cl = created;
                        Tracing.printExecTime3(Policy.DEBUG, "SUBMIT", "P4 submit", new Tracing.IRunnable(){

                            @Override
                            public void run() throws Throwable {
                                int key = P4CoreUtils.getRandomInt();
                                SubmitOptions opt = new SubmitOptions();
                                opt.setReOpen(reopen);
                                P4ProgressListener handler = P4CoreUtils.createStreamCallback(connection, CmdSpec.SUBMIT, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                                if (jobs == null || jobs.length == 0) {
                                    cl.submit(opt, (IStreamingCallback)handler, key);
                                    submittedSpecs.addAll(handler.getFileSpecs());
                                } else {
                                    ArrayList<String> jobIds = new ArrayList<String>();
                                    IP4Job[] iP4JobArray = jobs;
                                    int n = jobs.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        IP4Job job = iP4JobArray[n2];
                                        String id = job.getId();
                                        if (id != null) {
                                            jobIds.add(job.getId());
                                        }
                                        ++n2;
                                    }
                                    opt.setJobStatus(jobStatus);
                                    opt.setJobIds(jobIds);
                                    cl.submit(opt, (IStreamingCallback)handler, key);
                                    submittedSpecs.addAll(handler.getFileSpecs());
                                }
                            }
                        });
                        boolean errors = false;
                        for (IFileSpec spec : submittedSpecs) {
                            if (spec.getOpStatus() != FileSpecOpStatus.ERROR) continue;
                            errors = true;
                            break;
                        }
                        if (!errors) {
                            P4Collection submitted = P4Collection.createCollection(connection, submittedSpecs);
                            iP4ResourceArray = submitted.members();
                            n = iP4ResourceArray.length;
                            int n4 = 0;
                            while (n4 < n) {
                                IP4Resource resource = iP4ResourceArray[n4];
                                remaining.remove(resource);
                                ++n4;
                            }
                            if (!submitted.isEmpty()) {
                                monitor.setTaskName(Messages.P4PendingChangelist_RefreshSubmitted);
                                monitor.worked(100);
                                submitted.refresh();
                                iP4ResourceArray = submitted.members();
                                n = iP4ResourceArray.length;
                                n4 = 0;
                                while (n4 < n) {
                                    file = iP4ResourceArray[n4];
                                    if (file instanceof IP4File && !((IP4File)file).isOpened()) {
                                        P4PendingChangelist.this.removeFile((IP4File)file);
                                    }
                                    ++n4;
                                }
                                P4PendingChangelist.this.sendSubmitJobEvent(jobs);
                                P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.SUBMITTED, submitted));
                                P4PendingChangelist submittedList = new P4PendingChangelist(connection, created, true);
                                ArrayList<P4PendingChangelist> submittedLists = new ArrayList<P4PendingChangelist>(2);
                                if (P4PendingChangelist.this.changelist != null && currentId != created.getId()) {
                                    submittedLists.add(P4PendingChangelist.this);
                                }
                                submittedLists.add(submittedList);
                                monitor.setTaskName(Messages.P4PendingChangelist_SendSubmitChangelistEvent);
                                monitor.worked(100);
                                P4PendingChangelist.this.sendSubmitChangelistEvent(submittedLists);
                                List<IFileSpec> changelistSpecs = P4FileSpecBuilder.getInvalidFileSpecs(submittedSpecs);
                                for (IFileSpec spec : changelistSpecs) {
                                    int lastSpace;
                                    String message = spec.getStatusMessage();
                                    if (message == null || !message.startsWith("Submitted") || (lastSpace = message.lastIndexOf(32)) < 0) continue;
                                    message = message.substring(lastSpace);
                                    try {
                                        submittedId[0] = Integer.parseInt(message.trim());
                                        if (submittedId[0] <= 0) continue;
                                        break;
                                    }
                                    catch (NumberFormatException e) {
                                        PerforceProviderPlugin.logError(e);
                                    }
                                }
                                if (currentId > 0) {
                                    connection.removeChangelist(currentId);
                                }
                                if (submittedId[0] > 0) {
                                    submitted.sync("@" + submittedId[0] + ",@" + submittedId[0], (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                                    connection.removeChangelist(submittedId[0]);
                                }
                            }
                        }
                        if (!remaining.isEmpty()) {
                            P4Collection failed = new P4Collection(remaining.toArray(new IP4Resource[0]));
                            iP4ResourceArray = failed.members();
                            n = iP4ResourceArray.length;
                            int n5 = 0;
                            while (n5 < n) {
                                file = iP4ResourceArray[n5];
                                if (file instanceof IP4File && !((IP4File)file).isOpened()) {
                                    P4PendingChangelist.this.removeFile((IP4File)file);
                                }
                                ++n5;
                            }
                            int failedId = P4PendingChangelist.this.findFailedListId(submittedSpecs);
                            if (failedId > 0 && failedId != currentId) {
                                connection.loadPendingChangelist(failedId);
                            }
                            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.SUBMIT_FAILED, failed));
                        }
                        P4PendingChangelist.this.handleErrors(submittedSpecs.toArray(new IFileSpec[0]));
                    }
                }
            };
            this.runOperation(operation);
        }
        monitor.done();
        return submittedId[0];
    }

    private int findFailedListId(List<IFileSpec> specs) {
        int id = -1;
        for (IFileSpec spec : specs) {
            String message;
            if (FileSpecOpStatus.ERROR != spec.getOpStatus() || (message = spec.getStatusMessage()) == null || !message.contains("Submit failed") && !message.contains("Submit aborted")) continue;
            int idPos = message.indexOf("p4 submit -c");
            int endPos = message.lastIndexOf(39);
            if (idPos <= -1 || endPos <= -1) continue;
            try {
                String idSection = message.substring(idPos + "p4 submit -c".length(), endPos);
                id = Integer.parseInt(idSection.trim());
                break;
            }
            catch (IndexOutOfBoundsException iobe) {
                PerforceProviderPlugin.logError(Messages.P4PendingChangelist_ErrorSubmit, iobe);
                id = -1;
            }
            catch (NumberFormatException nfe) {
                PerforceProviderPlugin.logError(Messages.P4PendingChangelist_ErrorFindingID, nfe);
                id = -1;
            }
        }
        return id;
    }

    @Override
    public void delete(int changelist) {
        final int id = this.getId();
        if (this.isOnClient() && id > -1) {
            P4ClientOperation op = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    String message = client.getServer().deletePendingChangelist(id);
                    if (message != null && message.contains("Change " + id + " deleted")) {
                        IP4Connection connection = P4PendingChangelist.this.getConnection();
                        if (connection != null) {
                            connection.removeChangelist(P4PendingChangelist.this);
                        }
                        P4PendingChangelist.this.changelist = null;
                    }
                }
            };
            this.runOperation(op);
        }
    }

    @Override
    public boolean isOnClient() {
        return !this.readOnly;
    }

    @Override
    public void updateServerDescription(String description) {
        IChangelist list = this.changelist;
        if (list != null && description != null) {
            boolean retry = true;
            while (retry && list != null) {
                retry = false;
                list.setDescription(description);
                try {
                    list.getFiles(true);
                    list.update();
                    P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.CHANGED, this));
                }
                catch (P4JavaException e) {
                    retry = this.handleError(e);
                    if (retry) {
                        list = this.changelist;
                    }
                    PerforceProviderPlugin.logError(e);
                }
            }
        }
    }

    @Override
    public IP4Resource[] getAllMembers() {
        ArrayList<IP4Resource> all = new ArrayList<IP4Resource>();
        if (this.isOnClient()) {
            IP4Connection connection = this.getConnection();
            if (connection != null) {
                all.addAll(Arrays.asList(connection.getOpenedManager().getResources(this.getId())));
            }
        } else {
            all.addAll(this.cachedFiles);
        }
        if (this.shelved != null) {
            all.add(this.shelved);
        }
        return all.toArray(new IP4Resource[all.size()]);
    }

    private void refreshShelvedFiles(IP4Connection connection) throws P4JavaException {
        IChangelist list = this.changelist;
        if (connection.isShelvingSupported() && list != null) {
            this.shelved = new P4ShelvedChangelist(connection, list, this.isReadOnly());
            this.shelved.refresh();
            list.setShelved(this.shelved.members().length > 0);
        }
    }

    private void refreshClientFiles(IP4Connection connection, IServer server, int id, Set<IP4Resource> resources) throws P4JavaException {
        FileStatOutputOptions options = new FileStatOutputOptions();
        options.setMappedFiles(true);
        options.setOpenedFiles(true);
        List<IFileSpec> fileSpecs = P4FileSpecBuilder.makeFileSpecList(new String[]{connection.getRootSpec()});
        List files = server.getExtendedFiles(fileSpecs, 0, -1, id, options, null);
        for (IExtendedFileSpec file : files) {
            if (!this.isValidFileSpec(file)) continue;
            IP4File p4File = null;
            if (!this.readOnly) {
                p4File = this.getConnection().getFile((IFileSpec)file);
            }
            if (p4File == null) {
                p4File = new P4File((IFileSpec)file, this, this.readOnly);
            }
            p4File.setFileSpec((IFileSpec)file);
            resources.add(p4File);
        }
    }

    private void refreshOtherFiles(IP4Connection connection, IServer server, Set<IP4Resource> resources) throws P4JavaException {
        ArrayList<FileSpec> fileSpecs = new ArrayList<FileSpec>();
        String path = null;
        HashMap<String, IP4File> foundFiles = new HashMap<String, IP4File>();
        for (IFileSpec spec : this.changelist.getFiles(true)) {
            path = spec.getDepotPathString();
            if (path == null) continue;
            P4File file = new P4File(spec, this, this.readOnly);
            foundFiles.put(path, file);
            fileSpecs.add(new FileSpec(path));
        }
        if (!fileSpecs.isEmpty()) {
            List files = server.getExtendedFiles(fileSpecs, 0, -1, -1, null, null);
            for (IExtendedFileSpec file : files) {
                if (!this.isValidFileSpec(file)) continue;
                IP4File p4File = null;
                if (!this.readOnly) {
                    p4File = this.getConnection().getFile((IFileSpec)file);
                }
                if (p4File == null) {
                    p4File = new P4File((IFileSpec)file, this, this.readOnly);
                }
                p4File.setFileSpec((IFileSpec)file);
                path = p4File.getRemotePath();
                if (path == null) continue;
                foundFiles.put(path, p4File);
            }
        }
        resources.addAll(foundFiles.values());
    }

    @Override
    public void refresh() {
        final IP4Connection connection = this.getConnection();
        final int id = this.getId();
        if (connection != null && id > 0) {
            P4ClientOperation op = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    IServer server = client.getServer();
                    if (server != null) {
                        P4PendingChangelist.this.changelist = server.getChangelist(id);
                        HashSet<IP4Resource> resources = new HashSet<IP4Resource>();
                        List jobs = P4PendingChangelist.this.changelist.getJobs();
                        for (IJob job : jobs) {
                            P4Job p4Job = new P4Job(job, P4PendingChangelist.this.getConnection(), P4PendingChangelist.this);
                            resources.add(p4Job);
                        }
                        P4PendingChangelist.this.refreshShelvedFiles(connection);
                        if (P4PendingChangelist.this.isOnClient()) {
                            P4PendingChangelist.this.refreshClientFiles(connection, server, id, resources);
                            connection.getOpenedManager().replaceResources(id, resources);
                        } else {
                            P4PendingChangelist.this.refreshOtherFiles(connection, server, resources);
                            P4PendingChangelist.this.cachedFiles = resources;
                        }
                        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, P4PendingChangelist.this));
                    }
                }
            };
            this.runOperation(op);
        }
        this.needsRefresh = false;
    }

    @Override
    public boolean isActive() {
        IP4Connection connection = this.getConnection();
        if (connection != null) {
            return this.equals(connection.getActivePendingChangelist());
        }
        return false;
    }

    @Override
    public void makeActive() {
        if (this.isOnClient()) {
            IP4Connection connection = this.getConnection();
            connection.setActivePendingChangelist(this.getId());
        }
    }

    @Override
    public boolean isDeleteable() {
        return !this.isReadOnly() && !this.isDefault() && !this.needsRefresh() && this.members().length == 0;
    }

    @Override
    public boolean isShelved() {
        return this.changelist != null ? this.changelist.isShelved() : false;
    }

    @Override
    public void deleteShelved() {
        this.deleteShelve(null);
    }

    @Override
    public void shelve(IP4File[] files) {
        this.updateShelvedFiles(files);
    }

    @Override
    public void replaceShelvedFiles() {
        final int id = this.getId();
        final IP4Connection connection = this.getConnection();
        if (id > 0 && connection != null) {
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    if (connection.isShelvingSupported()) {
                        client.shelveChangelist(id, null, false, true, false);
                        if (P4PendingChangelist.this.isShelved()) {
                            P4PendingChangelist.this.refreshShelvedFiles(connection);
                            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.UPDATE_SHELVE, P4PendingChangelist.this));
                        } else {
                            P4PendingChangelist.this.refresh();
                            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.CREATE_SHELVE, P4PendingChangelist.this));
                        }
                    }
                }
            };
            this.runOperation(operation);
        }
    }

    @Override
    public void updateShelvedFiles() {
        this.updateShelvedFiles(null);
    }

    @Override
    public void deleteShelve(IP4Resource[] resources) {
        final int id = this.getId();
        final IP4Connection connection = this.getConnection();
        if (id > 0 && connection != null) {
            ArrayList<String> paths = new ArrayList<String>();
            if (resources != null) {
                IP4Resource[] iP4ResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource resource = iP4ResourceArray[n2];
                    String path = resource.getActionPath(IP4Resource.Type.REMOTE);
                    if (path != null) {
                        paths.add(path);
                    }
                    ++n2;
                }
            }
            final List<IFileSpec> specs = P4FileSpecBuilder.makeFileSpecList(paths.toArray(new String[paths.size()]));
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    if (connection.isShelvingSupported()) {
                        IFileSpec last;
                        List deleteSpecs = client.shelveChangelist(id, specs, false, false, true);
                        boolean deleted = false;
                        if (deleteSpecs.size() > 0 && (last = (IFileSpec)deleteSpecs.get(deleteSpecs.size() - 1)).getOpStatus() == FileSpecOpStatus.INFO) {
                            String message = last.getStatusMessage();
                            deleted = message.contains("Shelve " + id + " deleted.");
                        }
                        P4PendingChangelist.this.refreshShelvedFiles(connection);
                        if (deleted) {
                            IChangelist list = P4PendingChangelist.this.changelist;
                            if (list.isShelved() && list instanceof Changelist) {
                                ((Changelist)list).setShelved(false);
                                P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, P4PendingChangelist.this));
                            }
                            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.DELETE_SHELVE, P4PendingChangelist.this));
                        } else {
                            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.UPDATE_SHELVE, P4PendingChangelist.this));
                        }
                    }
                }
            };
            this.runOperation(operation);
        }
    }

    @Override
    public void updateShelvedFiles(IP4Resource[] resources) {
        final int id = this.getId();
        final IP4Connection connection = this.getConnection();
        if (id > 0 && connection != null) {
            ArrayList<String> paths = new ArrayList<String>();
            if (resources != null) {
                IP4Resource[] iP4ResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource resource = iP4ResourceArray[n2];
                    String path = resource.getActionPath(IP4Resource.Type.REMOTE);
                    if (path != null) {
                        paths.add(path);
                    }
                    ++n2;
                }
            }
            final List<IFileSpec> specs = P4FileSpecBuilder.makeFileSpecList(paths.toArray(new String[paths.size()]));
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    if (connection.isShelvingSupported()) {
                        client.shelveChangelist(id, specs, true, false, false);
                        if (P4PendingChangelist.this.isShelved()) {
                            P4PendingChangelist.this.refreshShelvedFiles(connection);
                            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.UPDATE_SHELVE, P4PendingChangelist.this));
                        } else {
                            P4PendingChangelist.this.refresh();
                            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.CREATE_SHELVE, P4PendingChangelist.this));
                        }
                    }
                }
            };
            this.runOperation(operation);
        }
    }

    @Override
    public IP4ShelvedChangelist getShelvedChanges() {
        return this.shelved;
    }

    @Override
    public void addJob(IP4Job job) {
        if (this.isOnClient()) {
            IP4Connection connection = this.getConnection();
            if (connection != null) {
                connection.getOpenedManager().addJob(this.getId(), job);
            }
        } else {
            super.addJob(job);
        }
    }

    @Override
    public void removeJob(IP4Job job) {
        if (this.isOnClient()) {
            IP4Connection connection = this.getConnection();
            if (connection != null) {
                connection.getOpenedManager().remove(this.getId(), job);
            }
        } else {
            super.removeJob(job);
        }
    }

    public String toString() {
        return ("P4PendingChangelist:[" + this.getDescription() + "]").replaceAll("[\n|\r]", "");
    }
}

