/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.option.client.IntegrateFilesOptions;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.P4IntegrationOptions2;
import com.perforce.team.core.p4java.P4IntegrationOptions3;

public abstract class P4IntegrationOptions {
    private boolean trySafeResolve;
    private int maxFiles = -1;
    private boolean integrateAroundDeleted;
    private boolean useHaveRev;
    private boolean displayBaseDetails;
    private boolean dontCopyToClient;
    private boolean force;
    private boolean reverseMapping;

    public IntegrateFilesOptions createIntegrateFilesOptions(int changeListId, boolean showActionsOnly) {
        IntegrateFilesOptions opt = new IntegrateFilesOptions();
        opt.setChangelistId(changeListId);
        opt.setShowActionsOnly(showActionsOnly);
        opt.setForceIntegration(this.isForce());
        opt.setUseHaveRev(this.isUseHaveRev());
        opt.setDisplayBaseDetails(this.isDisplayBaseDetails());
        opt.setReverseMapping(this.isReverseMapping());
        opt.setDontCopyToClient(this.isDontCopyToClient());
        opt.setMaxFiles(this.getMaxFiles());
        return opt;
    }

    public P4IntegrationOptions() {
        this.useHaveRev = false;
        this.dontCopyToClient = false;
        this.force = false;
        this.displayBaseDetails = false;
        this.reverseMapping = false;
        this.trySafeResolve = false;
        this.integrateAroundDeleted = false;
    }

    public P4IntegrationOptions(boolean useHaveRev, boolean displayBaseDetails, boolean dontCopyToClient, boolean force, boolean reverseMapping, boolean trySafeResolve) {
        this.useHaveRev = useHaveRev;
        this.displayBaseDetails = displayBaseDetails;
        this.dontCopyToClient = dontCopyToClient;
        this.force = force;
        this.reverseMapping = reverseMapping;
        this.trySafeResolve = trySafeResolve;
    }

    public boolean isTrySafeResolve() {
        return this.trySafeResolve;
    }

    public void setTrySafeResolve(boolean trySafeResolve) {
        this.trySafeResolve = trySafeResolve;
    }

    public boolean isUseHaveRev() {
        return this.useHaveRev;
    }

    public void setUseHaveRev(boolean useHaveRev) {
        this.useHaveRev = useHaveRev;
    }

    public boolean isDisplayBaseDetails() {
        return this.displayBaseDetails;
    }

    public void setDisplayBaseDetails(boolean displayBaseDetails) {
        this.displayBaseDetails = displayBaseDetails;
    }

    public boolean isDontCopyToClient() {
        return this.dontCopyToClient;
    }

    public void setDontCopyToClient(boolean dontCopyToClient) {
        this.dontCopyToClient = dontCopyToClient;
    }

    public boolean isForce() {
        return this.force;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isIntegrateAroundDeleted() {
        return this.integrateAroundDeleted;
    }

    public void setIntegrateAroundDeleted(boolean integrateAroundDeleted) {
        this.integrateAroundDeleted = integrateAroundDeleted;
    }

    public boolean isReverseMapping() {
        return this.reverseMapping;
    }

    public void setReverseMapping(boolean reverseMapping) {
        this.reverseMapping = reverseMapping;
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public void setMaxFiles(int maxFiles) {
        this.maxFiles = maxFiles;
    }

    public static P4IntegrationOptions createInstance(IServer server) {
        int serverVer = server.getServerVersionNumber();
        String level = null;
        try {
            IServerInfo info = server.getServerInfo();
            level = info.getIntegEngine();
        }
        catch (Exception e) {
            PerforceProviderPlugin.logError(e.getLocalizedMessage());
        }
        if (level == null) {
            if (serverVer < 20111) {
                return new P4IntegrationOptions2();
            }
            return new P4IntegrationOptions3();
        }
        if ("2".equals(level.trim())) {
            return new P4IntegrationOptions2();
        }
        if ("3".equals(level.trim())) {
            return new P4IntegrationOptions3();
        }
        return new P4IntegrationOptions3();
    }
}

