/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.ChangelistStatus;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.file.FileStatOutputOptions;
import com.perforce.p4java.core.file.IExtendedFileSpec;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.P4ClientOperation;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.core.p4java.P4PendingChangelist;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import java.util.ArrayList;
import java.util.List;

public class P4DefaultChangelist
extends P4PendingChangelist {
    private String description = null;
    private String username = null;
    private String clientname = null;
    private IClient wrappedClient = null;

    public P4DefaultChangelist(IP4Connection connection, IClient client, boolean needsRefresh) {
        this(connection, client, needsRefresh, false);
    }

    public P4DefaultChangelist(IP4Connection connection, IClient client, boolean needsRefresh, boolean onClient) {
        super(connection, null, onClient);
        this.wrappedClient = client;
        this.needsRefresh = needsRefresh;
        if (onClient && this.wrappedClient != null) {
            this.username = this.wrappedClient.getOwnerName();
            this.clientname = this.wrappedClient.getName();
        }
    }

    public P4DefaultChangelist(IP4Connection connection, IClient client, boolean needsRefresh, boolean onClient, boolean useConnection) {
        this(connection, client, needsRefresh, onClient);
        if (useConnection && connection != null) {
            this.username = connection.getParameters().getUser();
            this.clientname = connection.getParameters().getClient();
        }
    }

    @Override
    public IP4Resource[] getAllMembers() {
        return this.members();
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public ChangelistStatus getStatus() {
        return ChangelistStatus.PENDING;
    }

    public void updateUserClient(IFileSpec file) {
        if (file != null) {
            if (file.getUserName() != null) {
                this.username = file.getUserName();
            }
            if (file.getClientName() != null) {
                this.clientname = file.getClientName();
            }
        }
    }

    @Override
    public String getName() {
        String name = "Default";
        if (this.clientname != null && this.username != null) {
            name = String.valueOf(name) + " - " + this.username + "@" + this.clientname;
        }
        return name;
    }

    @Override
    public IClient getClient() {
        String name;
        if (!this.isReadOnly() && this.wrappedClient != null && (name = this.wrappedClient.getName()) != null && name.equals(this.clientname)) {
            return this.wrappedClient;
        }
        return super.getClient();
    }

    @Override
    public String getClientName() {
        return this.clientname;
    }

    @Override
    public String getUserName() {
        return this.username;
    }

    @Override
    public void setDescription(String description) {
        if (this.isOnClient()) {
            this.description = description;
        }
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    private boolean userMatchesAction(String user, IExtendedFileSpec spec) {
        boolean matches = false;
        matches = user == null ? true : (this.isCaseSensitive() ? user.equals(spec.getActionOwner()) : user.equalsIgnoreCase(spec.getActionOwner()));
        return matches;
    }

    @Override
    public void refresh() {
        final IP4Connection connection = this.getConnection();
        if (this.isOnClient() && connection != null) {
            P4ClientOperation op = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    IServer server = client.getServer();
                    if (server != null) {
                        IChangelist defaultP4JList = server.getChangelist(0);
                        if (defaultP4JList != null) {
                            P4DefaultChangelist.this.setDescription(defaultP4JList.getDescription());
                        }
                        FileStatOutputOptions options = new FileStatOutputOptions();
                        options.setMappedFiles(true);
                        options.setOpenedFiles(true);
                        List files = server.getExtendedFiles(P4FileSpecBuilder.makeFileSpecList(new String[]{connection.getRootSpec()}), 0, -1, 0, options, null);
                        String user = P4DefaultChangelist.this.getUserName();
                        ArrayList<IP4Resource> resources = new ArrayList<IP4Resource>();
                        for (IExtendedFileSpec file : files) {
                            if (!P4DefaultChangelist.this.isValidFileSpec(file) || !P4DefaultChangelist.this.userMatchesAction(user, file)) continue;
                            IP4File p4File = null;
                            if (!P4DefaultChangelist.this.readOnly) {
                                p4File = P4DefaultChangelist.this.getConnection().getFile((IFileSpec)file);
                            }
                            if (p4File == null) {
                                p4File = new P4File((IFileSpec)file, P4DefaultChangelist.this, P4DefaultChangelist.this.readOnly);
                            }
                            p4File.setFileSpec((IFileSpec)file);
                            resources.add(p4File);
                        }
                        connection.getOpenedManager().replaceResources(P4DefaultChangelist.this.getId(), resources);
                        P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, P4DefaultChangelist.this));
                    }
                }
            };
            this.runOperation(op);
        }
        this.needsRefresh = false;
    }

    @Override
    public boolean isShelved() {
        return false;
    }

    @Override
    public String toString() {
        return ("P4DefaultChangelist:[" + this.getDescription() + "]").replaceAll("[\n|\r]", "");
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof P4DefaultChangelist && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

