/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.client.IClientSummary;
import com.perforce.p4java.core.ChangelistStatus;
import com.perforce.p4java.core.IBranchSpec;
import com.perforce.p4java.core.IBranchSpecSummary;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.IDepot;
import com.perforce.p4java.core.IFileDiff;
import com.perforce.p4java.core.IFileLineMatch;
import com.perforce.p4java.core.IFix;
import com.perforce.p4java.core.IJob;
import com.perforce.p4java.core.IJobSpec;
import com.perforce.p4java.core.ILabel;
import com.perforce.p4java.core.ILabelSummary;
import com.perforce.p4java.core.IStream;
import com.perforce.p4java.core.IStreamSummary;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileRevisionData;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.ConfigException;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.Label;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.impl.mapbased.rpc.OneShotServerImpl;
import com.perforce.p4java.impl.mapbased.server.Server;
import com.perforce.p4java.option.client.CopyFilesOptions;
import com.perforce.p4java.option.client.IntegrateFilesOptions;
import com.perforce.p4java.option.client.MergeFilesOptions;
import com.perforce.p4java.option.client.PopulateFilesOptions;
import com.perforce.p4java.option.client.ResolveFilesAutoOptions;
import com.perforce.p4java.option.server.GetClientsOptions;
import com.perforce.p4java.option.server.GetStreamsOptions;
import com.perforce.p4java.option.server.MatchingLinesOptions;
import com.perforce.p4java.option.server.ReloadOptions;
import com.perforce.p4java.option.server.StreamOptions;
import com.perforce.p4java.option.server.UnloadOptions;
import com.perforce.p4java.server.AuthTicketsHelper;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.IServerAddress;
import com.perforce.p4java.server.IServerInfo;
import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.p4java.server.callback.ICommandCallback;
import com.perforce.team.core.ConnectionParameters;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.PerforceTeamProvider;
import com.perforce.team.core.Tracing;
import com.perforce.team.core.p4java.IErrorHandler;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Changelist;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Container;
import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Folder;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Label;
import com.perforce.team.core.p4java.IP4PendingChangelist;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.core.p4java.IP4ShelvedChangelist;
import com.perforce.team.core.p4java.IP4Stream;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.Messages;
import com.perforce.team.core.p4java.P4Branch;
import com.perforce.team.core.p4java.P4ClientOperation;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4DefaultChangelist;
import com.perforce.team.core.p4java.P4Depot;
import com.perforce.team.core.p4java.P4Event;
import com.perforce.team.core.p4java.P4File;
import com.perforce.team.core.p4java.P4FileIntegration;
import com.perforce.team.core.p4java.P4Folder;
import com.perforce.team.core.p4java.P4IntegrationOptions;
import com.perforce.team.core.p4java.P4Job;
import com.perforce.team.core.p4java.P4Label;
import com.perforce.team.core.p4java.P4PendingChangelist;
import com.perforce.team.core.p4java.P4Resource;
import com.perforce.team.core.p4java.P4Revision;
import com.perforce.team.core.p4java.P4ServerOperation;
import com.perforce.team.core.p4java.P4ShelvedChangelist;
import com.perforce.team.core.p4java.P4Stream;
import com.perforce.team.core.p4java.P4SubmittedChangelist;
import com.perforce.team.core.p4java.P4Workspace;
import com.perforce.team.core.p4java.PendingResourceManager;
import com.perforce.team.core.p4java.ServerNotSupportedException;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class P4Connection
extends P4Resource
implements IP4Connection {
    protected IClient client = null;
    protected IServer server = null;
    protected IServerInfo serverInfo;
    protected boolean offline = false;
    protected boolean connected = false;
    private ConnectionParameters params = null;
    private String currentDirectory = null;
    private ServerNotSupportedException serverException = null;
    private IJobSpec jobSpec = null;
    private int currentPending = -1;
    private P4Depot[] cached = null;
    private P4Depot specDepot = null;
    private boolean disposed = false;
    private boolean showClientOnly = false;
    private boolean showDeleted = false;
    private long loginTime = -1L;
    private boolean loggedIn = false;
    private int serverVersion = 0;
    private PendingResourceManager openedManager = new PendingResourceManager();
    private Map<Integer, IP4PendingChangelist> changelists = Collections.synchronizedMap(new HashMap());
    private Map<String, IP4Resource> resources = Collections.synchronizedMap(new HashMap());
    private Map<String, Object> attributes = Collections.synchronizedMap(new HashMap());

    public static boolean testEqual(IP4Connection c1, IP4Connection c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 != null && c2 != null) {
            return c1.equals(c2);
        }
        return false;
    }

    public P4Connection(ConnectionParameters params) {
        if (params == null) {
            params = new ConnectionParameters();
        }
        this.params = params;
    }

    @Override
    public IClient getClient() {
        if (this.client == null) {
            this.connect();
        }
        return this.client;
    }

    @Override
    public void connect() {
        IServer server = this.getServer();
        if (server != null) {
            boolean retry = true;
            while (retry) {
                retry = false;
                try {
                    this.refreshClient();
                    this.serverInfo = server.getServerInfo();
                    this.serverVersion = this.parseServerVersion(this.getVersion());
                    if (this.getVersion() != null && !this.isSupported()) {
                        throw this.createUnsupportedException();
                    }
                    if (this.client != null) {
                        this.connected = true;
                        this.offline = false;
                        continue;
                    }
                    this.connected = false;
                }
                catch (P4JavaException e) {
                    retry = this.handleError(e);
                    if (retry) {
                        server = this.getServer();
                    } else {
                        this.connected = false;
                    }
                    PerforceProviderPlugin.logError(e);
                }
                catch (P4JavaError e) {
                    this.connected = false;
                    PerforceProviderPlugin.logError(e);
                }
            }
        } else {
            this.connected = false;
        }
    }

    @Override
    public boolean refreshClient() {
        IServer server = this.getServer();
        boolean retry = true;
        while (retry && server != null) {
            retry = false;
            try {
                IClient newClient;
                this.client = newClient = server.getClient(this.params.getClient());
                if (newClient == null) {
                    throw new ConfigException("Client '" + this.params.getClient() + "' does not exist");
                }
                if (newClient != null) {
                    server.setCurrentClient(newClient);
                }
                this.updateWorkingDirectory(server, newClient);
            }
            catch (P4JavaException e) {
                retry = this.handleError(e);
                if (retry) {
                    server = this.getServer();
                }
                PerforceProviderPlugin.logError(e);
            }
            catch (P4JavaError e) {
                PerforceProviderPlugin.logError(e);
            }
            catch (Exception e) {
                PerforceProviderPlugin.logError(e);
            }
            if (retry) continue;
            return this.client != null;
        }
        return false;
    }

    private void updateWorkingDirectory(IServer server, IClient client) {
        String rootToUse;
        block4: {
            rootToUse = null;
            try {
                List altRoots;
                File rootTest;
                String root;
                if (client == null || (root = client.getRoot()) == null || (rootTest = new File(root)).isAbsolute() && rootTest.exists() || (altRoots = client.getAlternateRoots()) == null) break block4;
                for (String alt : altRoots) {
                    File altTest;
                    if (alt == null || !(altTest = new File(alt)).isAbsolute()) continue;
                    if (rootToUse == null) {
                        rootToUse = alt;
                    }
                    if (!altTest.exists()) continue;
                    rootToUse = alt;
                    break;
                }
            }
            catch (Exception e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        this.currentDirectory = rootToUse;
        server.setWorkingDirectory(this.currentDirectory);
    }

    protected int parseServerVersion(String ver) {
        int version = -1;
        if (ver != null) {
            int end;
            int idx = ver.indexOf(47) + 1;
            int start = ver.indexOf(47, idx) + 1;
            String s = ver.substring(start, end = ver.indexOf(47, start));
            if (s.length() > 6) {
                s = s.substring(0, 6);
            }
            version = (int)(Float.parseFloat(s) * 10.0f);
        }
        return version;
    }

    @Override
    public boolean isSupported() {
        return this.parseServerVersion(this.getVersion()) >= 20052;
    }

    @Override
    public String getVersion() {
        if (this.serverInfo != null) {
            return this.serverInfo.getServerVersion();
        }
        return null;
    }

    protected ServerNotSupportedException createUnsupportedException() {
        if (this.serverException == null) {
            this.serverException = new ServerNotSupportedException("Only server versions 2005.2+ are supported by P4Eclipse");
        }
        return this.serverException;
    }

    @Override
    public boolean handleError(P4JavaException exception) {
        boolean retry = false;
        if (exception != null && this.errorHandler != null && !this.isOffline()) {
            retry = this.errorHandler.shouldRetry(this, exception);
        }
        return retry;
    }

    @Override
    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    @Override
    public List<IDepot> getDepots() {
        final ArrayList<IDepot> depots = new ArrayList<IDepot>();
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                if (!(server instanceof IOptionsServer)) {
                    return;
                }
                List founded = ((IOptionsServer)server).getDepots();
                if (founded != null) {
                    depots.addAll(founded);
                }
            }
        };
        this.runOperation(operation);
        return depots;
    }

    @Override
    public IJobSpec getJobSpec() {
        if (this.jobSpec == null) {
            this.refreshJobSpec();
        }
        return this.jobSpec;
    }

    @Override
    public void refreshJobSpec() {
        P4ServerOperation op = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                P4Connection.this.jobSpec = server.getJobSpec();
            }
        };
        this.runOperation(op);
    }

    @Override
    public PendingResourceManager getOpenedManager() {
        return this.openedManager;
    }

    @Override
    public IServer getServer() {
        if (this.server == null) {
            this.refreshServer();
        }
        return this.server;
    }

    @Override
    public boolean refreshServer() {
        IServer current = this.server;
        this.server = null;
        if (!this.isOffline() && !this.disposed) {
            boolean retry = true;
            while (retry) {
                retry = false;
                try {
                    IServer newServer = this.createServer(current);
                    newServer.connect();
                    this.server = newServer;
                    this.serverInfo = newServer.getServerInfo();
                    String ticket = this.server.getAuthTicket();
                    try {
                        if (ticket != null || (ticket = AuthTicketsHelper.getTicketValue((String)ConnectionParameters.getTicketUser(this.params, this.server), (String)this.serverInfo.getServerAddress(), (String)P4Connection.getP4TicketsOSLocation())) == null) continue;
                        this.server.setAuthTicket(ticket);
                    }
                    catch (Throwable t) {
                        PerforceProviderPlugin.logWarning(t);
                    }
                }
                catch (P4JavaException e2) {
                    ServerNotSupportedException e2;
                    String message = e2.getMessage();
                    if (message != null && message.indexOf("unsupported P4 server version") != -1) {
                        e2 = this.createUnsupportedException();
                    }
                    retry = this.handleError(e2);
                    PerforceProviderPlugin.logError((Throwable)((Object)e2));
                }
                catch (URISyntaxException e1) {
                    PerforceProviderPlugin.logError(e1);
                }
                catch (P4JavaError e) {
                    PerforceProviderPlugin.logError(e);
                }
            }
            return this.server != null;
        }
        return false;
    }

    public IServer createServer(IServer current) throws P4JavaException, URISyntaxException {
        String charset;
        String serverUri = this.uriFromP4Port(this.params.getPortNoNull());
        IServer newServer = P4Workspace.createServer(serverUri);
        newServer.registerCallback((ICommandCallback)P4Workspace.getWorkspace().getCallback());
        newServer.registerSSOCallback(P4Workspace.getWorkspace().getSSOCallback(), this.params.getPort());
        newServer.setUserName(ConnectionParameters.getTicketUser(this.params, current));
        String ticket = null;
        ticket = current != null && current.getAuthTicket() != null ? current.getAuthTicket() : this.params.getAuthTicket();
        newServer.setAuthTicket(ticket);
        if (this.client != null) {
            newServer.setCurrentClient(this.client);
        }
        if ((charset = this.params.getCharset()) != null && !charset.equalsIgnoreCase("none") && PerforceCharsets.isSupported((String)charset)) {
            newServer.setCharsetName(this.params.getCharset());
        }
        return newServer;
    }

    private String uriFromP4Port(String p4port) {
        Pattern p = Pattern.compile("((ssl|rsh):)?(.*)");
        Matcher m = p.matcher(p4port);
        m.matches();
        String expectedProtocol = m.group(2);
        return StringUtils.join((Object[])new String[]{this.getProtocol(expectedProtocol), m.group(3)});
    }

    protected String getProtocol(String expectedProtocol) {
        boolean isRSH = "rsh".equalsIgnoreCase(expectedProtocol);
        return isRSH ? StringUtils.join((Object[])new String[]{IServerAddress.Protocol.P4JRSH.toString(), "://"}) : StringUtils.join((Object[])new String[]{OneShotServerImpl.PROTOCOL_NAME, expectedProtocol, "://"});
    }

    public static String getP4TicketsOSLocation() {
        String location = null;
        String os = System.getProperty("os.name");
        String home = System.getProperty("user.home");
        if (home != null && os != null) {
            StringBuilder builtLocation = new StringBuilder(home);
            builtLocation.append(File.separatorChar);
            if (os.toLowerCase(Locale.ENGLISH).contains("windows")) {
                builtLocation.append("p4tickets.txt");
            } else {
                builtLocation.append(".p4tickets");
            }
            location = builtLocation.toString();
        }
        return location;
    }

    @Override
    public IServerInfo getServerInfo() {
        return this.serverInfo;
    }

    @Override
    public P4Depot getSpecDepot() {
        return this.specDepot;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    @Override
    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    @Override
    public boolean isOffline() {
        return this.offline;
    }

    @Override
    public void clearCache() {
        this.resources.clear();
    }

    @Override
    public IP4Resource[] copyStream(final P4FileIntegration integration, String description, final CopyFilesOptions options) {
        P4Collection integrated = new P4Collection();
        if (integration != null) {
            if (-2 == options.getChangelistId()) {
                if (!options.isNoUpdate()) {
                    IP4PendingChangelist newList;
                    String newDescription = description;
                    if (newDescription == null) {
                        newDescription = "Copy stream change";
                    }
                    if ((newList = this.createChangelist(newDescription, null)) != null) {
                        options.setChangelistId(newList.getId());
                    }
                    if (options.getChangelistId() < 0) {
                        return new IP4Resource[0];
                    }
                } else {
                    options.setChangelistId(0);
                }
            }
            final ArrayList integSpecs = new ArrayList();
            P4ClientOperation op = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    String start = null;
                    String end = null;
                    String target = null;
                    if (integration != null) {
                        start = integration.getStart();
                        end = integration.getEnd();
                        target = integration.getTarget();
                    }
                    if (end != null) {
                        if (target == null) {
                            target = "//...";
                        }
                        target = start != null ? String.valueOf(target) + start + "," + end : String.valueOf(target) + end;
                    }
                    FileSpec toSpec = null;
                    if (target != null) {
                        toSpec = new FileSpec(target);
                    }
                    ArrayList<FileSpec> toSpecs = new ArrayList<FileSpec>();
                    toSpecs.add(toSpec);
                    integSpecs.addAll(client.copyFiles(null, toSpecs, options));
                }
            };
            this.runOperation(op);
            if (!integSpecs.isEmpty()) {
                for (IFileSpec integ : integSpecs) {
                    if (FileSpecOpStatus.VALID != integ.getOpStatus()) continue;
                    IP4Resource resource = null;
                    if (options.isNoUpdate()) {
                        resource = new P4File(integ, this);
                        ((IP4File)resource).setIntegrationSpecs(new IFileSpec[]{integ});
                    } else {
                        String path = integ.getToFile();
                        if (path == null) {
                            path = integ.getDepotPathString();
                        }
                        if (path != null && (resource = this.getResource(path)) == null) {
                            resource = new P4File(integ, this);
                            this.updateResource(resource);
                        }
                    }
                    integrated.add(resource);
                }
                if (!options.isNoUpdate() && !integrated.isEmpty()) {
                    integrated.refresh();
                    integrated.addToChangelistModel(this.getPendingChangelist(options.getChangelistId()));
                    P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.OPENED, integrated));
                    integrated.refreshLocalResources(2);
                }
                this.handleErrors(integSpecs.toArray(new IFileSpec[0]));
            }
        }
        return integrated.members();
    }

    @Override
    public IP4PendingChangelist createChangelist(String description, IP4File[] files) {
        return this.createChangelist(description, files, null);
    }

    @Override
    public IP4Resource getResource(String localOrDepotPath) {
        IP4Resource res;
        if (P4Connection.shouldConvertPath(localOrDepotPath)) {
            localOrDepotPath = P4Connection.convertPath(localOrDepotPath);
        }
        if ((res = this.resources.get(localOrDepotPath)) != null && res.getRemotePath() == null && res.getLocalPath() == null) {
            this.resources.remove(localOrDepotPath);
            return null;
        }
        return res;
    }

    @Override
    public void updateResource(IP4Resource resource) {
        if (this.updateResourceThenCheckNotify(resource)) {
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.ADDED, resource));
        }
    }

    @Override
    public boolean updateResourceThenCheckNotify(IP4Resource resource) {
        boolean notify = false;
        if (resource != null && !resource.isReadOnly()) {
            String local = resource.getLocalPath();
            String depot = resource.getRemotePath();
            if (local != null) {
                if (P4Connection.shouldConvertPath(local)) {
                    local = P4Connection.convertPath(local);
                }
                if (!this.resources.containsKey(local)) {
                    notify = true;
                }
                this.updateCache(local, resource);
            }
            if (depot != null) {
                if (!this.resources.containsKey(depot)) {
                    notify = true;
                }
                this.updateCache(depot, resource);
            }
        }
        return notify;
    }

    private void updateCache(String key, IP4Resource value) {
        this.resources.put(key, value);
    }

    @Override
    public IP4PendingChangelist getPendingChangelist(int changelistId) {
        return this.getPendingChangelist(changelistId, false);
    }

    @Override
    public void handleErrors(IFileSpec[] specs) {
        IErrorHandler handler = this.errorHandler;
        if (handler != null) {
            IFileSpec[] iFileSpecArray = specs;
            int n = specs.length;
            int n2 = 0;
            while (n2 < n) {
                IFileSpec spec = iFileSpecArray[n2];
                if (this.isErrorSpec(spec)) {
                    this.errorHandler.handleErrorSpecs(specs);
                    break;
                }
                ++n2;
            }
        }
    }

    @Override
    public IP4Branch createBranch(IBranchSpec spec) throws P4JavaException {
        IServer server;
        P4Branch newP4Branch = null;
        if (spec != null && (server = this.getServer()) != null) {
            try {
                server.createBranchSpec(spec);
                newP4Branch = new P4Branch(this, (IBranchSpecSummary)spec, true);
            }
            catch (P4JavaError error) {
                PerforceProviderPlugin.logError(error);
            }
        }
        return newP4Branch;
    }

    @Override
    public IP4PendingChangelist createChangelist(String description, IP4File[] files, IP4Job[] jobs) {
        P4PendingChangelist list = null;
        IClient client = this.getClient();
        if (client != null) {
            Changelist cl = new Changelist();
            cl.setId(-1);
            cl.setClientId(client.getName());
            cl.setDescription(description);
            cl.setUsername(client.getServer().getUserName());
            try {
                IChangelist created = client.createChangelist((IChangelist)cl);
                if (created != null && created.getId() > 0) {
                    list = new P4PendingChangelist(this, created, true);
                    if (list.getId() > 0) {
                        this.changelists.put(list.getId(), list);
                    }
                    P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.CREATE_CHANGELIST, list));
                    P4Collection collection = new P4Collection(files);
                    if (!collection.isEmpty()) {
                        collection.reopen(list);
                    }
                    if (jobs != null && jobs.length > 0) {
                        new P4Collection(jobs).fix(list);
                    }
                }
            }
            catch (P4JavaException e) {
                this.handleError(e);
                PerforceProviderPlugin.logError(e);
            }
            catch (P4JavaError e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        return list;
    }

    @Override
    public void createClient(final IClient client) {
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                if (!(server instanceof IOptionsServer)) {
                    return;
                }
                server.createClient(client);
            }
        };
        this.runOperation(operation);
    }

    @Override
    public IP4Job createJob(Map<String, Object> jobFields) throws P4JavaException {
        IServer server;
        P4Job newP4Job = null;
        if (jobFields != null && (server = this.getServer()) != null) {
            try {
                IJob newP4JJob = server.createJob(jobFields);
                newP4Job = new P4Job(newP4JJob, this);
            }
            catch (P4JavaError error) {
                PerforceProviderPlugin.logError(error);
            }
        }
        return newP4Job;
    }

    @Override
    public void createStream(final IStream stream) {
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                if (server instanceof IOptionsServer) {
                    ((IOptionsServer)server).createStream(stream);
                }
            }
        };
        this.runOperation(operation);
    }

    @Override
    public void deleteStream(final String streamPath, final StreamOptions opts) {
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                if (server instanceof IOptionsServer) {
                    ((IOptionsServer)server).deleteStream(streamPath, opts);
                }
            }
        };
        this.runOperation(operation);
    }

    @Override
    public void dispose() {
        this.resources.clear();
        this.changelists.clear();
        this.openedManager.clear();
        this.disposed = true;
        this.server = null;
        this.client = null;
        this.cached = null;
        this.needsRefresh = true;
    }

    @Override
    public boolean equals(Object otherConnection) {
        if (this == otherConnection) {
            return true;
        }
        return otherConnection instanceof IP4Connection && this.params != null && this.params.equals(((P4Connection)otherConnection).getParameters());
    }

    @Override
    public ConnectionParameters getParameters() {
        return this.params;
    }

    @Override
    public List<Map<String, Object>> execMapCmdList(final String name, final String[] strings, final HashMap<String, Object> hashMap) {
        final ArrayList<Map<String, Object>> retMaps = new ArrayList<Map<String, Object>>();
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                if (!(server instanceof IOptionsServer)) {
                    return;
                }
                List result = ((IOptionsServer)server).execMapCmdList(name, strings, (Map)hashMap);
                if (result != null) {
                    retMaps.addAll(result);
                }
            }
        };
        this.runOperation(operation);
        return retMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IP4File[] findFiles(String startsWithPath) {
        ArrayList<IP4File> found = new ArrayList<IP4File>();
        if (startsWithPath != null) {
            if (startsWithPath.endsWith(IP4Container.DIR_ELLIPSIS)) {
                startsWithPath = startsWithPath.substring(0, startsWithPath.length() - IP4Container.DIR_ELLIPSIS.length() + 1);
            } else if (startsWithPath.endsWith("/...")) {
                startsWithPath = startsWithPath.substring(0, startsWithPath.length() - "/...".length() + 1);
            }
            if (P4Connection.shouldConvertPath(startsWithPath)) {
                startsWithPath = P4Connection.convertPath(startsWithPath);
            }
            String[] keys = null;
            Map<String, IP4Resource> map = this.resources;
            synchronized (map) {
                keys = this.resources.keySet().toArray(new String[0]);
            }
            String[] stringArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource;
                String key = stringArray[n2];
                if (key.startsWith(startsWithPath) && (resource = this.getResource(key)) instanceof IP4File) {
                    found.add((IP4File)resource);
                }
                ++n2;
            }
        }
        return found.toArray(new IP4File[found.size()]);
    }

    public static boolean shouldConvertPath(String path) {
        return path != null && P4CoreUtils.isWindows() && path.indexOf(58) != -1;
    }

    public static String convertPath(String localPath) {
        if (localPath == null) {
            return null;
        }
        String local = P4Connection.convertDiskLabel(localPath);
        File file = new File(local);
        try {
            String localName;
            String fileName;
            String converted = file.getCanonicalPath();
            int nameIndex = converted.lastIndexOf(File.separatorChar);
            if (nameIndex > -1 && nameIndex + 1 < converted.length() && (fileName = file.getName()).equals(localName = converted.substring(nameIndex + 1))) {
                local = converted;
            }
        }
        catch (IOException e) {
            PerforceProviderPlugin.logError(e);
        }
        return local;
    }

    public static String convertDiskLabel(String path) {
        Matcher matcher;
        Tracing.printTrace("CONVERT DISK LABEL", path);
        Pattern p = Pattern.compile("([a-zA-Z]:)(\\\\|\\/)");
        String newPath = path;
        if (P4Connection.shouldConvertPath(path) && (matcher = p.matcher(path)).find()) {
            String group0 = matcher.group(0);
            String group1 = matcher.group(1);
            String group2 = matcher.group(2);
            newPath = path.replace(group0, String.valueOf(group1.toLowerCase()) + group2);
        }
        return newPath;
    }

    @Override
    public String getActionPath() {
        return "";
    }

    @Override
    public String getActionPath(IP4Resource.Type type) {
        return this.getActionPath();
    }

    @Override
    public IP4PendingChangelist getActivePendingChangelist() {
        return this.getPendingChangelist(this.currentPending);
    }

    @Override
    public String getAddress() {
        if (this.serverInfo != null) {
            return this.serverInfo.getServerAddress();
        }
        if (this.params != null) {
            return this.params.getPortNoNull();
        }
        return null;
    }

    @Override
    public IClientSummary[] getAllClients() {
        final ArrayList clients = new ArrayList();
        P4ServerOperation op = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                clients.addAll(server.getClients(null, null, -1));
            }
        };
        this.runOperation(op);
        return clients.toArray(new IClientSummary[0]);
    }

    @Override
    public IP4File[] getAllLocalFiles() {
        return new IP4File[0];
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public IP4Branch getBranch(final String branchName) {
        final IP4Branch[] branch = new IP4Branch[1];
        if (branchName != null) {
            P4ServerOperation operation = new P4ServerOperation(){

                @Override
                public void run(IServer server) throws P4JavaException, P4JavaError {
                    IBranchSpec p4jBranch = server.getBranchSpec(branchName);
                    if (p4jBranch != null) {
                        branch[0] = new P4Branch(P4Connection.this, (IBranchSpecSummary)p4jBranch, false);
                    }
                }
            };
            this.runOperation(operation);
        }
        return branch[0];
    }

    @Override
    public IP4Branch[] getBranches() {
        return this.getBranches(null, -1, null);
    }

    @Override
    public IP4Branch[] getBranches(int size) {
        return this.getBranches(null, size, null);
    }

    @Override
    public IP4Branch[] getBranches(String user, int size) {
        return this.getBranches(user, size, null);
    }

    @Override
    public IP4Branch[] getBranches(final String user, final int size, final String nameFilter) {
        final ArrayList branches = new ArrayList();
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                int version = P4Connection.this.getIntVersion();
                String name = nameFilter;
                if (version < 20081) {
                    name = null;
                }
                int maxReturns = size;
                if (version < 20061) {
                    maxReturns = -1;
                }
                boolean serverFilter = true;
                String userName = user;
                if (user != null && version < 20062) {
                    userName = null;
                    serverFilter = false;
                }
                List branchSpecs = server.getBranchSpecs(userName, name, maxReturns);
                if (serverFilter) {
                    for (IBranchSpecSummary branchSpec : branchSpecs) {
                        if (branchSpec == null) continue;
                        branches.add(new P4Branch(P4Connection.this.getConnection(), branchSpec, true));
                    }
                } else {
                    for (IBranchSpecSummary branchSpec : branchSpecs) {
                        if (branchSpec == null || !user.equals(branchSpec.getOwnerName())) continue;
                        branches.add(new P4Branch(P4Connection.this.getConnection(), branchSpec, true));
                    }
                }
            }
        };
        this.runOperation(operation);
        return branches.toArray(new IP4Branch[0]);
    }

    @Override
    public int getIntVersion() {
        if (this.serverVersion == 0) {
            this.serverVersion = this.parseServerVersion(this.getVersion());
        }
        return this.serverVersion;
    }

    @Override
    public IP4Connection getConnection() {
        return this;
    }

    @Override
    public IP4PendingChangelist[] getCachedPendingChangelists() {
        if (this.changelists.isEmpty()) {
            this.getPendingChangelists(false);
        }
        return this.changelists.values().toArray(new IP4PendingChangelist[0]);
    }

    @Override
    public IP4PendingChangelist[] getPendingChangelists(boolean all, int maxFetchCount) {
        IClient client = this.getClient();
        boolean retry = true;
        while (retry && client != null) {
            retry = false;
            IP4PendingChangelist[] previousLists = this.changelists.values().toArray(new IP4PendingChangelist[0]);
            HashMap<Integer, IP4PendingChangelist> newLists = new HashMap<Integer, IP4PendingChangelist>();
            String clientName = all ? null : client.getName();
            String userName = null;
            try {
                HashMap<String, IP4PendingChangelist> namesToLists = new HashMap<String, IP4PendingChangelist>();
                this.loadExistingChangelist(maxFetchCount, client, clientName, userName, namesToLists, newLists);
                if (!newLists.containsKey(0)) {
                    P4DefaultChangelist defaultChangelist = new P4DefaultChangelist(this, client, false, true, true);
                    newLists.put(0, defaultChangelist);
                    String hash = this.hashChangelist(this.getParameters().getClient(), this.getParameters().getUser(), 0);
                    namesToLists.put(hash, defaultChangelist);
                }
                this.changelists = newLists;
                HashSet<IP4File> current = new HashSet<IP4File>();
                HashSet<IP4File> newFiles = new HashSet<IP4File>();
                this.loadOpenedFiles(maxFetchCount, client, all, namesToLists, current, newFiles);
                P4DefaultChangelist defaultChangelist = (P4DefaultChangelist)newLists.get(0);
                if (defaultChangelist != null) {
                    defaultChangelist.refresh();
                }
                this.refreshMissingFiles(previousLists, current);
                this.refreshNewFiles(newFiles);
                return namesToLists.values().toArray(new P4PendingChangelist[0]);
            }
            catch (P4JavaException e) {
                retry = this.handleError(e);
                if (retry) {
                    client = this.getClient();
                }
                PerforceProviderPlugin.logError(e);
            }
            catch (P4JavaError e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        return new P4PendingChangelist[0];
    }

    @Override
    public IP4PendingChangelist[] getPendingChangelists(boolean all) {
        return this.getPendingChangelists(all, 0);
    }

    private void loadExistingChangelist(IClient p4jClient, String clientName, String userName, Map<String, IP4PendingChangelist> namesToLists, Map<Integer, IP4PendingChangelist> lists) throws P4JavaException {
        IServer server = p4jClient.getServer();
        List changelists = server.getChangelists(150, null, clientName, userName, true, false, true, true);
        for (IChangelistSummary change : changelists) {
            Changelist fullChange = new Changelist(change, server, false);
            String hash = this.hashChangelist(change.getClientId(), change.getUsername(), change.getId());
            boolean onClient = this.clientMatches((IChangelist)fullChange, p4jClient) && this.userMatches((IChangelist)fullChange, p4jClient);
            P4PendingChangelist changelist = new P4PendingChangelist(this, (IChangelist)fullChange, onClient);
            namesToLists.put(hash, changelist);
            if (!onClient) continue;
            lists.put(changelist.getId(), changelist);
        }
    }

    private void loadExistingChangelist(int maxItems, IClient p4jClient, String clientName, String userName, Map<String, IP4PendingChangelist> namesToLists, Map<Integer, IP4PendingChangelist> lists) throws P4JavaException {
        IServer server = p4jClient.getServer();
        List changelists = server.getChangelists(maxItems, null, clientName, userName, true, false, true, true);
        for (IChangelistSummary change : changelists) {
            Changelist fullChange = new Changelist(change, server, false);
            String hash = this.hashChangelist(change.getClientId(), change.getUsername(), change.getId());
            boolean onClient = this.clientMatches((IChangelist)fullChange, p4jClient) && this.userMatches((IChangelist)fullChange, p4jClient);
            P4PendingChangelist changelist = new P4PendingChangelist(this, (IChangelist)fullChange, onClient);
            namesToLists.put(hash, changelist);
            if (!onClient) continue;
            lists.put(changelist.getId(), changelist);
        }
    }

    protected boolean clientMatches(IChangelist list, IClient client) {
        String clientId = list.getClientId();
        if (clientId != null) {
            if (this.isCaseSensitive()) {
                return clientId.equals(client.getName());
            }
            return clientId.equalsIgnoreCase(client.getName());
        }
        return false;
    }

    protected boolean userMatches(IChangelist list, IClient client) {
        String user = list.getUsername();
        if (user != null) {
            if (this.isCaseSensitive()) {
                return user.equals(client.getOwnerName());
            }
            return user.equalsIgnoreCase(client.getOwnerName());
        }
        return false;
    }

    private String hashChangelist(String client, String user, int id) {
        String hash = String.valueOf(user) + "@" + client + "@" + id;
        if (!this.isCaseSensitive()) {
            hash = hash.toLowerCase();
        }
        return hash;
    }

    @Override
    public boolean isCaseSensitive() {
        IServer server = this.getServer();
        return server != null ? server.isCaseSensitive() : true;
    }

    private void loadOpenedFiles(IClient p4jClient, boolean all, Map<String, IP4PendingChangelist> namesToLists, Set<IP4File> current, Set<IP4File> newFiles) throws P4JavaException {
        List<IFileSpec> openedFiles = p4jClient.getServer().getOpenedFiles(new ArrayList(), all, all ? null : p4jClient.getName(), 150, -1);
        if (!(openedFiles = P4FileSpecBuilder.getValidFileSpecs(openedFiles)).isEmpty()) {
            for (IFileSpec file : openedFiles) {
                String hash;
                IP4PendingChangelist list;
                boolean userMatches = this.userMatches(file);
                boolean clientMatches = this.clientMatches(file);
                IP4File p4File = null;
                p4File = userMatches && clientMatches ? this.getFile(file) : new P4File(file, this, true);
                if (p4File != null) {
                    current.add(p4File);
                    if (userMatches && clientMatches && !p4File.isOpened()) {
                        newFiles.add(p4File);
                    }
                }
                if ((list = namesToLists.get(hash = this.hashChangelist(file.getClientName(), file.getUserName(), file.getChangelistId()))) == null && file.getChangelistId() == 0) {
                    list = userMatches && clientMatches ? new P4DefaultChangelist(this, p4jClient, false, true) : new P4DefaultChangelist(this, null, false, false);
                    ((P4DefaultChangelist)list).updateUserClient(file);
                    namesToLists.put(hash, list);
                }
                if (list == null || p4File == null) continue;
                list.addFile(p4File);
            }
        }
    }

    private void loadOpenedFiles(int maxFetchAmount, IClient p4jClient, boolean all, Map<String, IP4PendingChangelist> namesToLists, Set<IP4File> current, Set<IP4File> newFiles) throws P4JavaException {
        List<IFileSpec> openedFiles = p4jClient.getServer().getOpenedFiles(new ArrayList(), all, all ? null : p4jClient.getName(), maxFetchAmount, -1);
        if (!(openedFiles = P4FileSpecBuilder.getValidFileSpecs(openedFiles)).isEmpty()) {
            for (IFileSpec file : openedFiles) {
                String hash;
                IP4PendingChangelist list;
                boolean userMatches = this.userMatches(file);
                boolean clientMatches = this.clientMatches(file);
                IP4File p4File = null;
                p4File = userMatches && clientMatches ? this.getFile(file) : new P4File(file, this, true);
                if (p4File != null) {
                    current.add(p4File);
                    if (userMatches && clientMatches && !p4File.isOpened()) {
                        newFiles.add(p4File);
                    }
                }
                if ((list = namesToLists.get(hash = this.hashChangelist(file.getClientName(), file.getUserName(), file.getChangelistId()))) == null && file.getChangelistId() == 0) {
                    list = userMatches && clientMatches ? new P4DefaultChangelist(this, p4jClient, false, true) : new P4DefaultChangelist(this, null, false, false);
                    ((P4DefaultChangelist)list).updateUserClient(file);
                    namesToLists.put(hash, list);
                }
                if (list == null || p4File == null) continue;
                list.addFile(p4File);
            }
        }
    }

    protected boolean userMatches(IFileSpec spec) {
        return this.isOwner(spec.getUserName());
    }

    @Override
    public boolean isOwner(String user) {
        if (user == null) {
            return false;
        }
        if (this.isCaseSensitive()) {
            return user.equals(this.params.getUser());
        }
        return user.equalsIgnoreCase(this.params.getUser());
    }

    protected boolean clientMatches(IFileSpec spec) {
        String client = spec.getClientName();
        if (client != null) {
            if (this.isCaseSensitive()) {
                return client.equals(this.params.getClient());
            }
            return client.equalsIgnoreCase(this.params.getClient());
        }
        return false;
    }

    @Override
    public IP4File getFile(IFileSpec spec) {
        IP4File p4File = null;
        if (spec != null) {
            P4File testFile = new P4File(spec, null);
            IP4Resource resource = this.getResource(testFile.getActionPath());
            if (resource instanceof IP4File) {
                p4File = (IP4File)resource;
            } else {
                p4File = new P4File(spec, this);
                this.updateResource(p4File);
            }
        }
        return p4File;
    }

    private void refreshMissingFiles(IP4PendingChangelist[] previous, Set<IP4File> current) {
        if (previous != null && current != null) {
            HashSet<IP4File> missing = new HashSet<IP4File>();
            IP4PendingChangelist[] iP4PendingChangelistArray = previous;
            int n = previous.length;
            int n2 = 0;
            while (n2 < n) {
                IP4File[] files;
                IP4PendingChangelist list = iP4PendingChangelistArray[n2];
                IP4File[] iP4FileArray = files = list.getPendingFiles();
                int n3 = files.length;
                int n4 = 0;
                while (n4 < n3) {
                    IP4File file = iP4FileArray[n4];
                    if (!current.contains(file)) {
                        missing.add(file);
                    }
                    ++n4;
                }
                ++n2;
            }
            if (!missing.isEmpty()) {
                P4Collection collection = new P4Collection(missing.toArray(new IP4File[0]));
                collection.refresh();
            }
        }
    }

    private void refreshNewFiles(Set<IP4File> newFiles) {
        if (!newFiles.isEmpty()) {
            P4Collection collection = new P4Collection(newFiles.toArray(new IP4File[0]));
            collection.refresh();
        }
    }

    @Override
    public String getClientName() {
        if (this.client != null) {
            return this.client.getName();
        }
        if (this.params != null) {
            return this.params.getClientNoNull();
        }
        return null;
    }

    @Override
    public String getClientPath() {
        return null;
    }

    @Override
    public String getClientRoot() {
        if (this.client != null) {
            return this.client.getRoot();
        }
        return null;
    }

    @Override
    public List<IClientSummary> getClients(final GetClientsOptions opts) {
        final ArrayList<IClientSummary> clients = new ArrayList<IClientSummary>();
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                if (!(server instanceof IOptionsServer)) {
                    return;
                }
                List founded = ((IOptionsServer)server).getClients(opts);
                if (founded != null) {
                    clients.addAll(founded);
                }
            }
        };
        this.runOperation(operation);
        return clients;
    }

    @Override
    public String getDate() {
        if (this.serverInfo != null) {
            return this.serverInfo.getServerDate();
        }
        return null;
    }

    @Override
    public P4Depot getDepot(String name) {
        P4Depot depot = null;
        if (name != null) {
            IP4Resource[] iP4ResourceArray = this.members();
            int n = iP4ResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Resource resource = iP4ResourceArray[n2];
                if (name.equals(resource.getName())) {
                    depot = (P4Depot)resource;
                    break;
                }
                ++n2;
            }
        }
        return depot;
    }

    @Override
    public IP4Resource[] members() {
        if (this.isOffline()) {
            return new IP4Resource[0];
        }
        if (this.needsRefresh && this.cached == null) {
            this.refresh();
        }
        return this.cached != null ? this.cached : new IP4Resource[]{};
    }

    @Override
    public void refresh() {
        if (!this.isOffline()) {
            IServer server = this.getServer();
            if (server != null) {
                try {
                    this.refreshClient();
                    this.serverInfo = server.getServerInfo();
                    this.serverVersion = this.parseServerVersion(this.getVersion());
                }
                catch (P4JavaException e) {
                    this.handleError(e);
                    PerforceProviderPlugin.logError(e);
                }
                catch (P4JavaError e) {
                    PerforceProviderPlugin.logError(e);
                }
                final ArrayList metadata = new ArrayList();
                P4ServerOperation depotOp = new P4ServerOperation(){

                    @Override
                    public void run(IServer server) throws P4JavaException, P4JavaError {
                        metadata.addAll(server.getDepots());
                    }
                };
                this.runOperation(depotOp);
                P4Depot[] depots = new P4Depot[metadata.size()];
                int i = 0;
                while (i < depots.length) {
                    IDepot depot = (IDepot)metadata.get(i);
                    depots[i] = new P4Depot(depot, this);
                    if (IDepot.DepotType.SPEC == depot.getDepotType()) {
                        this.specDepot = depots[i];
                    }
                    ++i;
                }
                this.cached = depots;
            }
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, this));
        }
        this.needsRefresh = false;
    }

    @Override
    public IFileSpec[] getDifferingFiles(String[] paths) {
        IClient client = this.getClient();
        IFileSpec[] specs = null;
        if (client != null) {
            try {
                specs = client.getDiffFiles(P4FileSpecBuilder.makeFileSpecList(paths), 0, false, false, false, false, true, false, false).toArray(new IFileSpec[0]);
            }
            catch (P4JavaException e) {
                PerforceProviderPlugin.logError(e);
            }
            catch (P4JavaError e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        if (specs == null) {
            specs = new IFileSpec[]{};
        }
        return specs;
    }

    @Override
    public IFileDiff[] getDiffs(final String path1, final String path2) {
        final ArrayList diffs = new ArrayList();
        if (path1 != null && path2 != null) {
            P4ServerOperation operation = new P4ServerOperation(){

                @Override
                public void run(IServer server) throws P4JavaException, P4JavaError {
                    List<IFileSpec> specs = P4FileSpecBuilder.makeFileSpecList(new String[]{path1, path2});
                    List serverDiffs = server.getFileDiffs(specs.get(0), specs.get(1), null, null, false, false, false);
                    diffs.addAll(serverDiffs);
                }
            };
            this.runOperation(operation);
        }
        return diffs.toArray(new IFileDiff[diffs.size()]);
    }

    @Override
    public IP4File getFile(String localOrDepotPath) {
        IP4File p4File = null;
        IP4Resource resource = this.getResource(localOrDepotPath);
        if (resource instanceof IP4File) {
            p4File = (IP4File)resource;
        } else {
            p4File = new P4File((IFileSpec)new FileSpec(localOrDepotPath), this);
            p4File.refresh();
            this.updateResource(p4File);
        }
        return p4File;
    }

    @Override
    public IP4File[] getFiles(IFileSpec[] specs) {
        IP4File[] p4Files = new IP4File[]{};
        if (specs != null) {
            p4Files = new IP4File[specs.length];
            ArrayList<IP4File> toNotify = new ArrayList<IP4File>();
            int i = 0;
            while (i < specs.length) {
                P4File testFile = new P4File(specs[i], null);
                IP4Resource resource = this.getResource(testFile.getActionPath());
                if (resource instanceof IP4File) {
                    p4Files[i] = (IP4File)resource;
                } else {
                    p4Files[i] = new P4File(specs[i], this);
                    if (this.updateResourceThenCheckNotify(p4Files[i])) {
                        toNotify.add(p4Files[i]);
                    }
                }
                ++i;
            }
            if (toNotify.size() > 0) {
                P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.ADDED, toNotify.toArray(new IP4File[0])));
            }
        }
        return p4Files;
    }

    @Override
    public List<IP4Stream> getFilteredStreams(final boolean unloaded, final List<String> paths, final String filter, final int size) {
        final ArrayList<IP4Stream> streams = new ArrayList<IP4Stream>();
        P4ClientOperation op = new P4ClientOperation(){

            @Override
            public void run(IClient client) throws P4JavaException, P4JavaError {
                GetStreamsOptions opts = new GetStreamsOptions();
                opts.setUnloaded(unloaded);
                opts.setMaxResults(size);
                opts.setFilter(filter);
                if (P4Connection.this.server instanceof IOptionsServer) {
                    List summaries = ((IOptionsServer)P4Connection.this.server).getStreams(paths, opts);
                    for (IStreamSummary sum : summaries) {
                        P4Stream stream = new P4Stream(P4Connection.this, sum);
                        streams.add(stream);
                    }
                }
            }
        };
        this.runOperation(op);
        return streams;
    }

    @Override
    public Integer[] getFixIds(final String jobId) {
        final ArrayList lists = new ArrayList();
        if (jobId != null) {
            P4ClientOperation op = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List fixes = client.getServer().getFixList(null, -1, jobId, false, 0);
                    for (IFix fix : fixes) {
                        int changelistId = fix.getChangelistId();
                        if (changelistId <= 0) continue;
                        lists.add(changelistId);
                    }
                }

                @Override
                public void exception(P4JavaException exception) {
                    lists.clear();
                }
            };
            this.runOperation(op);
        }
        return lists.toArray(new Integer[lists.size()]);
    }

    @Override
    public Integer[] getFixIds(IP4Job job) {
        return job != null ? this.getFixIds(job.getId()) : new Integer[]{};
    }

    @Override
    public IP4Changelist[] getFixes(IP4Job job) {
        return job != null ? this.getFixes(job.getId()) : new IP4Changelist[]{};
    }

    @Override
    public IP4Changelist[] getFixes(final String jobId) {
        final ArrayList lists = new ArrayList();
        if (jobId != null) {
            P4ClientOperation op = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    List fixes = client.getServer().getFixList(null, -1, jobId, false, 0);
                    for (IFix fix : fixes) {
                        int changelistId = fix.getChangelistId();
                        IP4Changelist list = P4Connection.this.getChangelistById(changelistId);
                        if (list == null) continue;
                        lists.add(list);
                    }
                }

                @Override
                public void exception(P4JavaException exception) {
                    lists.clear();
                }
            };
            this.runOperation(op);
        }
        return lists.toArray(new IP4Changelist[lists.size()]);
    }

    @Override
    public IP4Changelist getChangelistById(int id) {
        return this.getChangelistById(id, null, false);
    }

    @Override
    public IP4Folder getFolder(String depotPath) {
        return this.getFolder(depotPath, true);
    }

    @Override
    public IP4Folder getFolder(String depotPath, boolean refreshIfNotFound) {
        IP4Folder folder = null;
        IP4Resource resource = this.resources.get(depotPath);
        if (resource instanceof IP4Folder) {
            folder = (IP4Folder)resource;
        } else {
            folder = new P4Folder(this, null, depotPath);
            if (refreshIfNotFound) {
                folder.updateLocation();
                this.updateResource(folder);
                folder.refresh();
            } else {
                this.updateResource(folder);
            }
        }
        return folder;
    }

    @Override
    public IP4Revision[] getHistory(final String[] paths, final int max) {
        final ArrayList history = new ArrayList();
        if (paths != null && paths.length > 0) {
            P4ServerOperation operation = new P4ServerOperation(){

                @Override
                public void run(IServer server) throws P4JavaException, P4JavaError {
                    List<IFileSpec> specs = P4FileSpecBuilder.makeFileSpecList(paths);
                    Map historyData = server.getRevisionHistory(specs, max, false, false, true, false);
                    if (historyData != null) {
                        for (List data : historyData.values()) {
                            if (data == null) continue;
                            for (IFileRevisionData rev : data) {
                                history.add(new P4Revision(P4Connection.this, rev));
                            }
                        }
                    }
                }
            };
            this.runOperation(operation);
        }
        return history.toArray(new IP4Revision[history.size()]);
    }

    @Override
    public IP4SubmittedChangelist[] getInterchanges(final String sourcePath, final String targetPath) {
        final IP4Connection connection = this.getConnection();
        final ArrayList lists = new ArrayList();
        if (sourcePath != null && targetPath != null && connection != null) {
            P4ClientOperation operation = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    FileSpec sourceSpec = new FileSpec(sourcePath);
                    FileSpec targetSpec = new FileSpec(targetPath);
                    List interchanges = client.getServer().getInterchanges((IFileSpec)sourceSpec, (IFileSpec)targetSpec, false, true, -1);
                    for (IChangelist list : interchanges) {
                        lists.add(new P4SubmittedChangelist(connection, list));
                    }
                }
            };
            this.runOperation(operation);
        }
        return lists.toArray(new IP4SubmittedChangelist[lists.size()]);
    }

    @Override
    public IP4Job getJob(final String id) {
        final IP4Job[] job = new IP4Job[1];
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                IJob p4jJob = server.getJob(id);
                if (p4jJob != null) {
                    job[0] = new P4Job(p4jJob, P4Connection.this);
                }
            }
        };
        this.runOperation(operation);
        return job[0];
    }

    @Override
    public String[] getJobFields() {
        if (this.jobSpec == null) {
            this.refreshJobSpec();
        }
        ArrayList<String> jobFields = new ArrayList<String>();
        if (this.jobSpec != null) {
            List fields = this.jobSpec.getFields();
            for (IJobSpec.IJobSpecField field : fields) {
                String name = field.getName();
                if (name == null) continue;
                jobFields.add(name);
            }
        }
        return jobFields.toArray(new String[0]);
    }

    @Override
    public IP4Job[] getJobs() {
        return this.getJobs(0);
    }

    @Override
    public IP4Job[] getJobs(int size) {
        return this.getJobs((String[])null, size);
    }

    @Override
    public IP4Job[] getJobs(String path) {
        return this.getJobs(path, 0);
    }

    @Override
    public IP4Job[] getJobs(String[] paths, int size) {
        return this.getJobs(paths, size, null);
    }

    @Override
    public IP4Job[] getJobs(String path, int size) {
        if (path == null) {
            return this.getJobs(size);
        }
        return this.getJobs(new String[]{path}, size);
    }

    @Override
    public IP4Job[] getJobs(final String[] paths, final int size, final String jobViewPath) {
        final ArrayList jobs = new ArrayList();
        P4ServerOperation op = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                List p4jJobs = server.getJobs(P4FileSpecBuilder.makeFileSpecList(paths), size, true, true, false, jobViewPath);
                for (IJob job : p4jJobs) {
                    if (job == null) continue;
                    P4Job p4Job = new P4Job(job, P4Connection.this.getConnection());
                    jobs.add(p4Job);
                }
            }
        };
        this.runOperation(op);
        return jobs.toArray(new IP4Job[0]);
    }

    @Override
    public IP4Label getLabel(final String labelName) {
        final IP4Label[] label = new IP4Label[1];
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                ILabel p4jLabel = server.getLabel(labelName);
                if (p4jLabel != null) {
                    label[0] = new P4Label(p4jLabel, P4Connection.this, false);
                }
            }
        };
        this.runOperation(operation);
        return label[0];
    }

    @Override
    public IP4Label[] getLabels() {
        return this.getLabels(0);
    }

    @Override
    public IP4Label[] getLabels(int size) {
        return this.getLabels((String[])null, size);
    }

    @Override
    public IP4Label[] getLabels(String[] paths) {
        return this.getLabels(paths, 0);
    }

    @Override
    public IP4Label[] getLabels(String path) {
        return this.getLabels(path, 0);
    }

    @Override
    public IP4Label[] getLabels(String[] paths, int size) {
        return this.getLabels(paths, size, null);
    }

    @Override
    public IP4Label[] getLabels(String path, int size) {
        if (path == null) {
            return this.getLabels(size);
        }
        return this.getLabels(new String[]{path}, size);
    }

    @Override
    public IP4Label[] getLabels(String[] paths, int size, String nameFilter) {
        return this.getLabels(null, paths, size, nameFilter);
    }

    @Override
    public IP4Label[] getLabels(final String user, final String[] paths, final int size, final String nameFilter) {
        final ArrayList labels = new ArrayList();
        P4ServerOperation op = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                int serverVersion = P4Connection.this.parseServerVersion(P4Connection.this.getVersion());
                boolean filterUser = false;
                String userMatch = user;
                if (user != null && serverVersion < 20062) {
                    filterUser = true;
                    userMatch = null;
                }
                int max = size;
                if (serverVersion < 20061) {
                    max = -1;
                }
                String nameMatch = nameFilter;
                if (serverVersion < 20081) {
                    nameMatch = null;
                }
                List p4jLabels = server.getLabels(userMatch, max, nameMatch, P4FileSpecBuilder.makeFileSpecList(paths));
                if (!filterUser) {
                    for (ILabelSummary label : p4jLabels) {
                        if (label == null) continue;
                        P4Label p4Label = new P4Label((ILabel)new Label(label), P4Connection.this.getConnection(), true);
                        labels.add(p4Label);
                    }
                } else {
                    for (ILabelSummary label : p4jLabels) {
                        if (label == null || !user.equals(label.getOwnerName())) continue;
                        P4Label p4Label = new P4Label((ILabel)new Label(label), P4Connection.this.getConnection(), true);
                        labels.add(p4Label);
                    }
                }
            }
        };
        this.runOperation(op);
        return labels.toArray(new IP4Label[0]);
    }

    @Override
    public String getLicense() {
        if (this.serverInfo != null) {
            return this.serverInfo.getServerLicense();
        }
        return null;
    }

    @Override
    public String getLocalPath() {
        return null;
    }

    @Override
    public long getLoggedInTime() {
        return this.loginTime;
    }

    @Override
    public IProject[] getMappedProjects() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            PerforceTeamProvider provider = PerforceTeamProvider.getPerforceProvider((IResource)project);
            try {
                if (provider != null && this.params.equals(provider.getProjectProperties(true))) {
                    projects.add(project);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return projects.toArray(new IProject[0]);
    }

    @Override
    public IFileSpec[] getMissingFiles(String[] paths) {
        IClient client = this.getClient();
        IFileSpec[] specs = null;
        if (client != null) {
            try {
                specs = client.getDiffFiles(P4FileSpecBuilder.makeFileSpecList(paths), 0, false, false, false, true, false, false, false).toArray(new IFileSpec[0]);
            }
            catch (P4JavaException e) {
                PerforceProviderPlugin.logError(e);
            }
            catch (P4JavaError e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        if (specs == null) {
            specs = new IFileSpec[]{};
        }
        return specs;
    }

    @Override
    public IP4File[] getOpenedBy(String path) {
        IP4File[] files = new IP4File[]{};
        IServer server = this.getServer();
        if (server != null) {
            if (path == null) {
                path = "";
            }
            List<IFileSpec> specs = P4FileSpecBuilder.makeFileSpecList(new String[]{path});
            try {
                specs = server.getOpenedFiles(specs, true, null, 0, -1);
                specs = P4FileSpecBuilder.getValidFileSpecs(specs);
                files = new IP4File[specs.size()];
                int i = 0;
                while (i < specs.size()) {
                    files[i] = new P4File(specs.get(i), this);
                    ++i;
                }
            }
            catch (P4JavaException e) {
                PerforceProviderPlugin.logError(e);
            }
            catch (P4JavaError e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        return files;
    }

    @Override
    public IClientSummary[] getOwnedClients() {
        final ArrayList clients = new ArrayList();
        P4ServerOperation op = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                int[] version = P4CoreUtils.getVersion(P4Connection.this.getVersion());
                if (version[0] < 2006) {
                    clients.addAll(((Server)server).getClients(new GetClientsOptions()));
                } else {
                    clients.addAll(server.getClients(P4Connection.this.getParameters().getUser(), null, -1));
                }
            }
        };
        this.runOperation(op);
        return clients.toArray(new IClientSummary[0]);
    }

    @Override
    public IClientSummary[] getOwnedLocalClients() {
        final ArrayList clients = new ArrayList();
        P4ServerOperation op = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                block6: {
                    boolean matchUser;
                    List owned;
                    String user;
                    block7: {
                        boolean matchHost;
                        String infoHost;
                        block5: {
                            user = P4Connection.this.getParameters().getUser();
                            infoHost = P4Connection.this.getServerInfoClientHost();
                            owned = null;
                            matchHost = infoHost != null;
                            matchUser = false;
                            if (P4Connection.this.isUserFilterSupported()) {
                                owned = server.getClients(user, null, -1);
                            } else {
                                owned = server.getClients(null, null, -1);
                                matchUser = true;
                            }
                            if (!matchUser || !matchHost) break block5;
                            for (IClientSummary spec : owned) {
                                if (user == null || !user.equals(spec.getOwnerName()) || !P4Connection.this.hostMatches(infoHost, spec.getHostName())) continue;
                                clients.add(spec);
                            }
                            break block6;
                        }
                        if (!matchHost) break block7;
                        for (IClientSummary spec : owned) {
                            if (!P4Connection.this.hostMatches(infoHost, spec.getHostName())) continue;
                            clients.add(spec);
                        }
                        break block6;
                    }
                    if (!matchUser) break block6;
                    for (IClientSummary spec : owned) {
                        if (user == null || !user.equals(spec.getOwnerName())) continue;
                        clients.add(spec);
                    }
                }
            }
        };
        this.runOperation(op);
        return clients.toArray(new IClientSummary[0]);
    }

    @Override
    public String getServerInfoClientHost() {
        if (this.serverInfo != null) {
            return this.serverInfo.getClientHost();
        }
        return null;
    }

    private boolean isUserFilterSupported() {
        return this.parseServerVersion(this.getVersion()) >= 20062;
    }

    private boolean hostMatches(String infoHost, String clientHost) {
        return infoHost.equals(clientHost) || clientHost == null || "".equals(clientHost);
    }

    @Override
    public IP4Container getParent() {
        return null;
    }

    @Override
    public IP4PendingChangelist getPendingChangelist(int changelistId, boolean fetchIfNotFound) {
        return this.getPendingChangelist(changelistId, fetchIfNotFound, false);
    }

    @Override
    public IP4PendingChangelist getPendingChangelist(int changelistId, boolean fetchIfNotFound, boolean ignoreErrors) {
        if (this.changelists.isEmpty()) {
            this.getPendingChangelists(false);
        }
        IP4PendingChangelist list = this.changelists.get(changelistId);
        if (changelistId > 0 && list != null && list.getChangelist() == null) {
            this.changelists.remove(changelistId);
            list = null;
        }
        if (fetchIfNotFound && list == null) {
            this.loadPendingChangelist(changelistId, ignoreErrors);
            list = this.changelists.get(changelistId);
        }
        return list;
    }

    private void loadPendingChangelist(int id, boolean ignoreErrors) {
        IP4PendingChangelist pending;
        IP4Changelist list = this.getChangelistById(id, ChangelistStatus.PENDING, true, ignoreErrors);
        if (list instanceof IP4PendingChangelist && (pending = (IP4PendingChangelist)list).isOnClient() && pending.getChangelist() != null) {
            this.changelists.put(id, pending);
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.REFRESHED, pending));
        }
    }

    @Override
    public IP4Changelist getChangelistById(final int id, final ChangelistStatus type, final boolean checkClient, final boolean ignoreErrors) {
        final IP4Changelist[] list = new IP4Changelist[1];
        P4ClientOperation op = new P4ClientOperation(){

            @Override
            public void run(IClient client) throws P4JavaException, P4JavaError {
                block6: {
                    try {
                        IChangelist p4jList = client.getServer().getChangelist(id);
                        if (p4jList != null && (type == null || p4jList.getStatus() == type)) {
                            if (p4jList.getStatus() == ChangelistStatus.PENDING) {
                                boolean onClient = checkClient && P4Connection.this.clientMatches(p4jList, client) && P4Connection.this.userMatches(p4jList, client);
                                list[0] = new P4PendingChangelist(P4Connection.this, p4jList, onClient);
                            } else if (p4jList.getStatus() == ChangelistStatus.SUBMITTED) {
                                list[0] = new P4SubmittedChangelist(P4Connection.this, p4jList);
                            }
                        }
                    }
                    catch (P4JavaException e) {
                        if (ignoreErrors) break block6;
                        throw e;
                    }
                }
            }
        };
        this.runOperation(op);
        return list[0];
    }

    @Override
    public IP4PendingChangelist getPendingChangelistById(int id) {
        return (IP4PendingChangelist)this.getChangelistById(id, ChangelistStatus.PENDING, false);
    }

    @Override
    public IP4Changelist getChangelistById(int id, ChangelistStatus type, boolean checkClient) {
        return this.getChangelistById(id, type, checkClient, false);
    }

    @Override
    public String getRemotePath() {
        return null;
    }

    @Override
    public IP4Resource getResource(IResource resource) {
        IP4Resource p4Resource;
        String path;
        if (resource == null) {
            return null;
        }
        IPath resourcePath = resource.getLocation();
        if (resourcePath == null) {
            return null;
        }
        String convertedPath = path = resourcePath.makeAbsolute().toOSString();
        if (P4Connection.shouldConvertPath(path)) {
            convertedPath = P4Connection.convertPath(path);
        }
        if ((p4Resource = this.getResource(convertedPath)) == null) {
            IContainer parent;
            if (resource instanceof IContainer) {
                p4Resource = new P4Folder(this, path, null);
                this.updateResource(p4Resource);
                p4Resource.refresh();
            } else if (resource instanceof IFile && (parent = resource.getParent()) != null) {
                IP4Resource parentResource = this.getResource((IResource)parent);
                if (parentResource instanceof IP4Container) {
                    IP4Container folder = (IP4Container)parentResource;
                    if (folder.needsRefresh()) {
                        folder.refresh();
                    }
                    p4Resource = this.getResource(convertedPath);
                }
                if (p4Resource == null) {
                    p4Resource = new P4File(this, path);
                    if (resource.isLinked()) {
                        p4Resource.refresh();
                    }
                }
            }
        }
        return p4Resource;
    }

    @Override
    public String getRoot() {
        if (this.serverInfo != null) {
            return this.serverInfo.getServerRoot();
        }
        return null;
    }

    @Override
    public String getRootSpec() {
        return "//" + this.getParameters().getClientNoNull() + "/...";
    }

    @Override
    public String getServerInfoClientAddress() {
        if (this.serverInfo != null) {
            return this.serverInfo.getClientAddress();
        }
        return null;
    }

    @Override
    public String getServerInfoClientName() {
        if (this.serverInfo != null) {
            return this.serverInfo.getClientName();
        }
        return null;
    }

    @Override
    public String getServerInfoClientRoot() {
        if (this.serverInfo != null) {
            return this.serverInfo.getClientRoot();
        }
        return null;
    }

    @Override
    public IP4ShelvedChangelist[] getShelvedChangelists() {
        return this.getShelvedChangelists(0);
    }

    @Override
    public IP4ShelvedChangelist[] getShelvedChangelists(int size) {
        return this.getShelvedChangelists((String[])null, size);
    }

    @Override
    public IP4ShelvedChangelist[] getShelvedChangelists(String[] paths) {
        return this.getShelvedChangelists(paths, 0);
    }

    @Override
    public IP4ShelvedChangelist[] getShelvedChangelists(String path) {
        return this.getShelvedChangelists(path, 0);
    }

    @Override
    public IP4ShelvedChangelist[] getShelvedChangelists(String[] paths, int size) {
        return this.getShelvedChangelists(paths, size, null, null);
    }

    @Override
    public IP4ShelvedChangelist[] getShelvedChangelists(String path, int size) {
        if (path == null) {
            return this.getShelvedChangelists(size);
        }
        return this.getShelvedChangelists(new String[]{path}, size);
    }

    @Override
    public IP4ShelvedChangelist[] getShelvedChangelists(final String[] paths, final int size, final String user, final String clientWorkspace) {
        final ArrayList changes = new ArrayList();
        P4ClientOperation op = new P4ClientOperation(){

            @Override
            public void run(IClient client) throws P4JavaException, P4JavaError {
                if (P4Connection.this.isShelvingSupported()) {
                    IServer server = client.getServer();
                    List changelists = server.getChangelists(size, P4FileSpecBuilder.makeFileSpecList(paths), clientWorkspace, user, false, IChangelist.Type.SHELVED, true);
                    for (IChangelistSummary change : changelists) {
                        Changelist fullChange;
                        P4ShelvedChangelist changelist = new P4ShelvedChangelist(P4Connection.this, (IChangelist)fullChange, !P4Connection.this.userClientMatches((IChangelist)(fullChange = new Changelist(change, server, false)), client));
                        changes.add(changelist);
                    }
                }
            }
        };
        this.runOperation(op);
        return changes.toArray(new IP4ShelvedChangelist[0]);
    }

    @Override
    public boolean isShelvingSupported() {
        return this.parseServerVersion(this.getVersion()) >= 20092;
    }

    protected boolean userClientMatches(IChangelist list, IClient client) {
        return this.userMatches(list, client) && this.clientMatches(list, client);
    }

    @Override
    public IP4Stream getStream(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        IServer server = this.getServer();
        if (server instanceof IOptionsServer) {
            try {
                IStream stream = ((IOptionsServer)server).getStream(path);
                return new P4Stream(this, (IStreamSummary)stream);
            }
            catch (P4JavaException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public IStreamSummary getStreamSummary(final String streamPath) {
        final IStreamSummary[] result = new IStreamSummary[1];
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                if (server instanceof IOptionsServer) {
                    result[0] = ((IOptionsServer)server).getStream(streamPath);
                }
            }
        };
        this.runOperation(operation);
        return result[0];
    }

    @Override
    public List<String> getStreamViewMapping(final String streamPath) {
        final ArrayList<String> list = new ArrayList<String>();
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                if (!(server instanceof OneShotServerImpl)) {
                    return;
                }
                Pattern pattern = Pattern.compile("^View(\\d)+");
                List result = ((OneShotServerImpl)server).execQuietMapCmdList("stream", new String[]{"-o", "-v", streamPath}, null);
                for (Map map : result) {
                    Object[] keySet = map.keySet().toArray(new String[0]);
                    Arrays.sort(keySet);
                    int i = 0;
                    while (i < keySet.length) {
                        Object key = keySet[i];
                        if (pattern.matcher((CharSequence)key).matches()) {
                            list.add((String)map.get(key));
                        }
                        ++i;
                    }
                }
            }
        };
        this.runOperation(operation);
        return list;
    }

    @Override
    public List<IStreamSummary> getStreams(final List<String> paths, final GetStreamsOptions opts) {
        final ArrayList<IStreamSummary> streams = new ArrayList<IStreamSummary>();
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                if (!(server instanceof IOptionsServer)) {
                    return;
                }
                List founded = ((IOptionsServer)server).getStreams(paths, opts);
                if (founded != null) {
                    streams.addAll(founded);
                }
            }
        };
        this.runOperation(operation);
        return streams;
    }

    @Override
    public IP4SubmittedChangelist getSubmittedChangelistById(int id) {
        return this.getSubmittedChangelistById(id, false);
    }

    @Override
    public IP4SubmittedChangelist getSubmittedChangelistById(int id, boolean ignoreErrors) {
        return (IP4SubmittedChangelist)this.getChangelistById(id, ChangelistStatus.SUBMITTED, ignoreErrors);
    }

    @Override
    public IP4SubmittedChangelist[] getSubmittedChangelists() {
        return this.getSubmittedChangelists(0);
    }

    @Override
    public IP4SubmittedChangelist[] getSubmittedChangelists(int size) {
        return this.getSubmittedChangelists((String[])null, size);
    }

    @Override
    public IP4SubmittedChangelist[] getSubmittedChangelists(String[] paths) {
        return this.getSubmittedChangelists(paths, 0);
    }

    @Override
    public IP4SubmittedChangelist[] getSubmittedChangelists(String path) {
        return this.getSubmittedChangelists(path, 0);
    }

    @Override
    public IP4SubmittedChangelist[] getSubmittedChangelists(String[] paths, int size) {
        return this.getSubmittedChangelists(paths, size, null, null);
    }

    @Override
    public IP4SubmittedChangelist[] getSubmittedChangelists(String path, int size) {
        if (path == null) {
            return this.getSubmittedChangelists(size);
        }
        return this.getSubmittedChangelists(new String[]{path}, size);
    }

    @Override
    public IP4SubmittedChangelist[] getSubmittedChangelists(final String[] paths, final int size, final String user, final String clientWorkspace) {
        final ArrayList changes = new ArrayList();
        P4ClientOperation op = new P4ClientOperation(){

            @Override
            public void run(IClient client) throws P4JavaException, P4JavaError {
                IServer server = client.getServer();
                List changelists = server.getChangelists(size, P4FileSpecBuilder.makeFileSpecList(paths), clientWorkspace, user, false, true, false, true);
                for (IChangelistSummary change : changelists) {
                    P4SubmittedChangelist changelist = new P4SubmittedChangelist(P4Connection.this, (IChangelist)new Changelist(change, server, false));
                    changes.add(changelist);
                }
            }
        };
        this.runOperation(op);
        return changes.toArray(new IP4SubmittedChangelist[0]);
    }

    @Override
    public String getUptime() {
        if (this.serverInfo != null) {
            return this.serverInfo.getServerUptime();
        }
        return null;
    }

    @Override
    public String getUser() {
        if (this.server != null) {
            return this.server.getUserName();
        }
        if (this.params != null) {
            return this.params.getUserNoNull();
        }
        return null;
    }

    @Override
    public boolean hasMappedProjects() {
        boolean mapped = false;
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            PerforceTeamProvider provider = PerforceTeamProvider.getPerforceProvider((IResource)project);
            try {
                if (provider != null && this.params.equals(provider.getProjectProperties(true))) {
                    mapped = true;
                    break;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
        return mapped;
    }

    @Override
    public boolean hasServer() {
        return this.server != null;
    }

    @Override
    public int hashCode() {
        if (this.params != null) {
            return this.params.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public IP4Resource[] integrate(P4FileIntegration integration, String branch, int changelist, String description, boolean all, P4IntegrationOptions options, boolean isAddPreviouslyLinkedJobs) {
        List<IFileSpec> integSpecs;
        int pendingId = this.getPendingChangelistId(changelist, description, false);
        if (pendingId < 0) {
            return new IP4Resource[0];
        }
        P4Collection integrated = new P4Collection();
        if ((integration != null || StringUtils.isNotBlank((CharSequence)branch)) && !(integSpecs = this.executeIntegrateCmd(integration, options, pendingId, branch, false)).isEmpty()) {
            integrated.addAll(this.getIntegratedResource(all, integSpecs));
            this.refreshAfterIntegrated(options, pendingId, integrated);
            this.handleErrors(integSpecs.toArray(new IFileSpec[0]));
            if (isAddPreviouslyLinkedJobs) {
                this.addPreviouslyLinkedJobsToNewChangeList(integSpecs, pendingId);
            }
        }
        return integrated.members();
    }

    private int getPendingChangelistId(int changelist, String description, boolean preview) {
        int pendingChangelistId = changelist;
        if (-2 == changelist) {
            if (!preview) {
                IP4PendingChangelist newPendingChangelist;
                String descriptionForNewChangelist = description;
                if (descriptionForNewChangelist == null) {
                    descriptionForNewChangelist = INTEGRATE_DEFAULT_DESCRIPTION;
                }
                if ((newPendingChangelist = this.createChangelist(descriptionForNewChangelist, null)) != null) {
                    pendingChangelistId = newPendingChangelist.getId();
                }
            } else {
                pendingChangelistId = 0;
            }
        }
        return pendingChangelistId;
    }

    private List<IFileSpec> executeIntegrateCmd(final P4FileIntegration integration, final P4IntegrationOptions options, final int pendingId, final String branch, final boolean preview) {
        final ArrayList<IFileSpec> integSpecs = new ArrayList<IFileSpec>();
        P4ClientOperation op = new P4ClientOperation(){

            @Override
            public void run(IClient client) throws P4JavaException, P4JavaError {
                FileSpec fromSpec = P4Connection.this.populateFromFileSpecify(integration);
                FileSpec toSpec = P4Connection.this.populateToFileSpecify(integration);
                IntegrateFilesOptions integOpts = options.createIntegrateFilesOptions(pendingId, preview);
                if (StringUtils.isNotBlank((CharSequence)branch) && fromSpec != null && toSpec == null) {
                    integOpts.setBidirectionalInteg(true);
                }
                String targetBranch = branch;
                if (StringUtils.isBlank((CharSequence)branch)) {
                    targetBranch = null;
                }
                integSpecs.addAll(client.integrateFiles((IFileSpec)fromSpec, (IFileSpec)toSpec, targetBranch, integOpts));
            }
        };
        this.runOperation(op);
        return integSpecs;
    }

    private FileSpec populateFromFileSpecify(P4FileIntegration integration) {
        String sourcePath = null;
        String start = null;
        String end = null;
        if (integration != null) {
            sourcePath = integration.getSource();
            start = integration.getStart();
            end = integration.getEnd();
        }
        if (StringUtils.isNotBlank(end)) {
            if (StringUtils.isBlank((CharSequence)sourcePath)) {
                sourcePath = "//...";
            }
            sourcePath = StringUtils.isNotBlank((CharSequence)start) ? String.valueOf(sourcePath) + start + "," + end : String.valueOf(sourcePath) + end;
        }
        if (StringUtils.isNotBlank((CharSequence)sourcePath)) {
            return new FileSpec(sourcePath);
        }
        return null;
    }

    private FileSpec populateToFileSpecify(P4FileIntegration integration) {
        String target = null;
        if (integration != null && StringUtils.isNotBlank((CharSequence)(target = integration.getTarget()))) {
            return new FileSpec(target);
        }
        return null;
    }

    private P4Collection getIntegratedResource(boolean all, List<IFileSpec> integSpecs) {
        P4Collection integrated = new P4Collection();
        for (IFileSpec integ : integSpecs) {
            if (!all && FileSpecOpStatus.VALID != integ.getOpStatus()) continue;
            IP4Resource resource = null;
            String path = integ.getToFile();
            if (StringUtils.isBlank((CharSequence)path)) {
                path = integ.getDepotPathString();
            }
            if (path != null && (resource = this.getResource(path)) == null) {
                resource = new P4File(integ, this);
                this.updateResource(resource);
            }
            integrated.add(resource);
        }
        return integrated;
    }

    private void refreshAfterIntegrated(P4IntegrationOptions options, int pendingId, P4Collection integrated) {
        if (!integrated.isEmpty()) {
            integrated.refresh();
            integrated.addToChangelistModel(this.getPendingChangelist(pendingId));
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.OPENED, integrated));
            integrated.refreshLocalResources(2);
            if (options != null && options.isTrySafeResolve()) {
                P4Collection unresolved = new P4Collection();
                IP4Resource[] iP4ResourceArray = integrated.members();
                int n = iP4ResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Resource resource = iP4ResourceArray[n2];
                    if (resource instanceof IP4File && ((IP4File)resource).isUnresolved()) {
                        unresolved.add(resource);
                    }
                    ++n2;
                }
                unresolved.setType(IP4Resource.Type.LOCAL);
                unresolved.resolve(new ResolveFilesAutoOptions().setSafeMerge(true));
            }
        }
    }

    private void addPreviouslyLinkedJobsToNewChangeList(final List<IFileSpec> integrateToFileSpec, final int pendingChangelistId) {
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                ArrayList<String> fromFileSpecsPathStrings = new ArrayList<String>();
                if (integrateToFileSpec != null && !integrateToFileSpec.isEmpty()) {
                    for (IFileSpec toFileSpec : integrateToFileSpec) {
                        if (FileSpecOpStatus.VALID != toFileSpec.getOpStatus()) continue;
                        fromFileSpecsPathStrings.add(toFileSpec.getFromFile());
                    }
                    IP4Job[] jobs = P4Connection.this.getJobs(fromFileSpecsPathStrings.toArray(new String[fromFileSpecsPathStrings.size()]));
                    HashSet<String> jobIds = new HashSet<String>();
                    IP4Job[] iP4JobArray = jobs;
                    int n = jobs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IP4Job job = iP4JobArray[n2];
                        jobIds.add(job.getId());
                        ++n2;
                    }
                    server.fixJobs(new ArrayList(jobIds), pendingChangelistId, null, false);
                }
            }
        };
        this.runOperation(operation);
    }

    @Override
    public IP4Job[] getJobs(String[] paths) {
        return this.getJobs(paths, 0);
    }

    @Override
    public IP4Resource[] integratePreview(P4FileIntegration integration, String branch, int changelist, String description, boolean all, P4IntegrationOptions options, boolean isAddPreviouslyLinkedJobs) {
        List<IFileSpec> integSpecs;
        int pendingId = this.getPendingChangelistId(changelist, description, true);
        if (pendingId < 0) {
            return new IP4Resource[0];
        }
        P4Collection integrated = new P4Collection();
        if ((integration != null || StringUtils.isNotBlank((CharSequence)branch)) && (integSpecs = this.executeIntegrateCmd(integration, options, pendingId, branch, true)) != null && !integSpecs.isEmpty()) {
            for (IFileSpec integ : integSpecs) {
                if (!all && FileSpecOpStatus.VALID != integ.getOpStatus()) continue;
                P4File resource = null;
                resource = new P4File(integ, this);
                ((IP4File)resource).setIntegrationSpecs(new IFileSpec[]{integ});
                integrated.add(resource);
            }
            this.handleErrors(integSpecs.toArray(new IFileSpec[0]));
        }
        return integrated.members();
    }

    @Override
    public boolean isConnected() {
        return this.connected && this.client != null;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean isMoveServerOnlySupported() {
        return this.parseServerVersion(this.getVersion()) >= 20092;
    }

    @Override
    public boolean isMoveSupported() {
        return this.parseServerVersion(this.getVersion()) >= 20091;
    }

    @Override
    public boolean isPendingLoaded() {
        return !this.changelists.isEmpty();
    }

    @Override
    public boolean isSandbox() {
        if (this.serverInfo == null) {
            this.refresh();
        }
        return this.serverInfo != null && this.serverInfo.getSandboxVersion() != null;
    }

    @Override
    public boolean isSearchSupported() {
        return this.parseServerVersion(this.getVersion()) >= 20101;
    }

    @Override
    public boolean isSecure() {
        return false;
    }

    @Override
    public void loadPendingChangelist(int id) {
        this.loadPendingChangelist(id, false);
    }

    @Override
    public boolean login(String password) {
        IServer server;
        if (!this.isOffline() && !this.disposed && (server = this.getServer()) != null) {
            try {
                if (password == null && this.params != null && this.params.savePassword()) {
                    password = this.params.getPassword();
                }
                if (password != null) {
                    server.login(password);
                    this.loggedIn = true;
                    this.loginTime = System.currentTimeMillis();
                    return true;
                }
            }
            catch (P4JavaException e) {
                PerforceProviderPlugin.logError(e);
            }
            catch (P4JavaError e) {
                PerforceProviderPlugin.logError(e);
            }
        }
        return false;
    }

    @Override
    public void logout() {
        if (this.server != null) {
            try {
                this.server.logout();
            }
            catch (P4JavaException e) {
                PerforceProviderPlugin.logError(e);
            }
            catch (P4JavaError e) {
                PerforceProviderPlugin.logError(e);
            }
        }
    }

    @Override
    public void markLoggedOut() {
        this.loggedIn = false;
    }

    @Override
    public IP4Resource[] mergeStream(final P4FileIntegration integration, String description, final MergeFilesOptions options) {
        P4Collection integrated = new P4Collection();
        if (integration != null) {
            if (-2 == options.getChangelistId()) {
                if (!options.isShowActionsOnly()) {
                    IP4PendingChangelist newList;
                    String newDescription = description;
                    if (newDescription == null) {
                        newDescription = "Merge stream change";
                    }
                    if ((newList = this.createChangelist(newDescription, null)) != null) {
                        options.setChangelistId(newList.getId());
                    }
                    if (options.getChangelistId() < 0) {
                        return new IP4Resource[0];
                    }
                } else {
                    options.setChangelistId(0);
                }
            }
            final ArrayList integSpecs = new ArrayList();
            P4ClientOperation op = new P4ClientOperation(){

                @Override
                public void run(IClient client) throws P4JavaException, P4JavaError {
                    String start = null;
                    String end = null;
                    String target = null;
                    if (integration != null) {
                        start = integration.getStart();
                        end = integration.getEnd();
                        target = integration.getTarget();
                    }
                    if (end != null) {
                        if (target == null) {
                            target = "//...";
                        }
                        target = start != null ? String.valueOf(target) + start + "," + end : String.valueOf(target) + end;
                    }
                    FileSpec toSpec = null;
                    if (target != null) {
                        toSpec = new FileSpec(target);
                    }
                    ArrayList<FileSpec> toSpecs = new ArrayList<FileSpec>();
                    toSpecs.add(toSpec);
                    integSpecs.addAll(client.mergeFiles(null, toSpecs, options));
                }
            };
            this.runOperation(op);
            if (!integSpecs.isEmpty()) {
                for (IFileSpec integ : integSpecs) {
                    if (FileSpecOpStatus.VALID != integ.getOpStatus()) continue;
                    IP4Resource resource = null;
                    if (options.isShowActionsOnly()) {
                        resource = new P4File(integ, this);
                        ((IP4File)resource).setIntegrationSpecs(new IFileSpec[]{integ});
                    } else {
                        String path = integ.getToFile();
                        if (path == null) {
                            path = integ.getDepotPathString();
                        }
                        if (path != null && (resource = this.getResource(path)) == null) {
                            resource = new P4File(integ, this);
                            this.updateResource(resource);
                        }
                    }
                    integrated.add(resource);
                }
                if (!options.isShowActionsOnly() && !integrated.isEmpty()) {
                    integrated.refresh();
                    integrated.addToChangelistModel(this.getPendingChangelist(options.getChangelistId()));
                    P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.OPENED, integrated));
                    integrated.refreshLocalResources(2);
                }
                this.handleErrors(integSpecs.toArray(new IFileSpec[0]));
            }
        }
        return integrated.members();
    }

    @Override
    public IP4Resource[] populate(final String sourcePath, final String targetPath, boolean preview, String description) {
        P4Collection populated = new P4Collection();
        final PopulateFilesOptions options = new PopulateFilesOptions();
        options.setNoUpdate(preview);
        if (!preview) {
            options.setDescription(description);
        }
        options.setShowPopulatedFiles(true);
        final ArrayList populateSpecs = new ArrayList();
        P4ClientOperation op = new P4ClientOperation(){

            @Override
            public void run(IClient client) throws P4JavaException, P4JavaError {
                FileSpec fromSpec = null;
                if (sourcePath != null) {
                    fromSpec = new FileSpec(sourcePath);
                }
                FileSpec toSpec = null;
                if (targetPath != null) {
                    toSpec = new FileSpec(targetPath);
                }
                List files = client.populateFiles((IFileSpec)fromSpec, Arrays.asList(toSpec), options);
                populateSpecs.addAll(files);
            }
        };
        this.runOperation(op);
        if (!populateSpecs.isEmpty()) {
            for (IFileSpec integ : populateSpecs) {
                if (integ.getDepotPath() == null || FileSpecOpStatus.VALID != integ.getOpStatus()) continue;
                IP4Resource resource = null;
                if (preview) {
                    resource = new P4File(integ, this);
                    ((IP4File)resource).setIntegrationSpecs(new IFileSpec[]{integ});
                } else {
                    String path = integ.getToFile();
                    if (path == null) {
                        path = integ.getDepotPathString();
                    }
                    if (path != null && (resource = this.getResource(path)) == null) {
                        resource = new P4File(integ, this);
                        this.updateResource(resource);
                    }
                }
                populated.add(resource);
            }
            if (!preview && !populated.isEmpty()) {
                populated.refresh();
                P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.AVAILABLE, populated));
                populated.refreshLocalResources(2);
            }
            this.handleErrors(populateSpecs.toArray(new IFileSpec[0]));
        }
        return populated.members();
    }

    @Override
    public List<IFileSpec> populateStream(final IStream stream) {
        final ArrayList<IFileSpec> specs = new ArrayList<IFileSpec>();
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                IClient client = P4Connection.this.getClient();
                List list = client.populateFiles(null, null, new PopulateFilesOptions().setStream(stream.getStream()).setReverseMapping(true).setShowPopulatedFiles(true).setDescription(MessageFormat.format(Messages.Stream_Populate, stream.getStream(), stream.getParent())));
                specs.addAll(list);
            }
        };
        this.runOperation(operation);
        return specs;
    }

    @Override
    public File printToTempFile(final String specPath) {
        final File[] tempFile = new File[1];
        if (specPath != null) {
            P4ServerOperation op = new P4ServerOperation(){

                @Override
                public void run(IServer server) throws P4JavaException, P4JavaError {
                    InputStream stream = server.getFileContents(P4FileSpecBuilder.makeFileSpecList(new String[]{specPath}), false, true);
                    if (stream == null) {
                        stream = new ByteArrayInputStream(new byte[0]);
                    }
                    tempFile[0] = P4CoreUtils.createFile(stream);
                }
            };
            this.runOperation(op);
        }
        return tempFile[0];
    }

    @Override
    public void refresh(int depth) {
        this.refresh();
    }

    @Override
    public void reloadStream(final String streamPath, final ReloadOptions opts) {
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                if (server instanceof IOptionsServer) {
                    ((IOptionsServer)server).reload(opts.setStream(streamPath));
                }
            }
        };
        this.runOperation(operation);
    }

    @Override
    public void removeChangelist(IP4PendingChangelist changelist) {
        if (changelist != null) {
            int id = changelist.getId();
            this.changelists.remove(id);
        }
    }

    @Override
    public void removeChangelist(int changelist) {
        this.changelists.remove(changelist);
    }

    @Override
    public IFileLineMatch[] searchDepot(String pattern) {
        return this.searchDepot(pattern, "//...");
    }

    @Override
    public IFileLineMatch[] searchDepot(String pattern, String path) {
        if (path == null) {
            return new IFileLineMatch[0];
        }
        return this.searchDepot(pattern, new String[]{path});
    }

    @Override
    public IFileLineMatch[] searchDepot(String pattern, String[] paths) {
        if (pattern == null || paths == null || paths.length == 0) {
            return new IFileLineMatch[0];
        }
        return this.searchDepot(pattern, null, paths);
    }

    @Override
    public IFileLineMatch[] searchDepot(String pattern, MatchingLinesOptions options, String path) {
        if (pattern == null || path == null) {
            return new IFileLineMatch[0];
        }
        return this.searchDepot(pattern, options, new String[]{path});
    }

    @Override
    public IFileLineMatch[] searchDepot(final String pattern, final MatchingLinesOptions options, final String[] paths) {
        final ArrayList matches = new ArrayList();
        if (pattern != null && paths != null && paths.length > 0) {
            P4ServerOperation operation = new P4ServerOperation(){

                @Override
                public void run(IServer server) throws P4JavaException, P4JavaError {
                    if (!(server instanceof IOptionsServer)) {
                        return;
                    }
                    MatchingLinesOptions grepOptions = options;
                    if (grepOptions == null) {
                        grepOptions = new MatchingLinesOptions();
                    }
                    grepOptions.setIncludeLineNumbers(true);
                    List<IFileSpec> specs = P4FileSpecBuilder.makeFileSpecList(paths);
                    List found = ((IOptionsServer)server).getMatchingLines(specs, pattern, grepOptions);
                    matches.addAll(found);
                }
            };
            this.runOperation(operation);
        }
        return matches.toArray(new IFileLineMatch[matches.size()]);
    }

    @Override
    public void setActivePendingChangelist(int id) {
        int currentId = this.currentPending;
        if (currentId != id) {
            this.currentPending = id;
            IP4PendingChangelist list = this.getPendingChangelist(id);
            IP4PendingChangelist current = this.getPendingChangelist(currentId);
            ArrayList<IP4PendingChangelist> changed = new ArrayList<IP4PendingChangelist>();
            if (list != null) {
                changed.add(list);
            }
            if (current != null) {
                changed.add(current);
            }
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.CHANGED, changed.toArray(new IP4Resource[changed.size()])));
            if (list != null) {
                P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.ACTIVE_CHANGELIST, list));
            } else {
                P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.INACTIVE_CHANGELIST, this));
            }
        }
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public void setOffline(boolean offline) {
        this.offline = offline;
        if (this.offline) {
            this.server = null;
            this.client = null;
            this.connected = false;
        }
    }

    @Override
    public void setShowClientOnly(boolean showClientOnly) {
        boolean refresh = this.showClientOnly ^ showClientOnly;
        this.showClientOnly = showClientOnly;
        if (refresh) {
            this.markForRefresh();
        }
    }

    @Override
    public void setShowFoldersWIthOnlyDeletedFiles(boolean showDeleted) {
        boolean refresh = this.showDeleted ^ showDeleted;
        this.showDeleted = showDeleted;
        if (refresh) {
            this.markForRefresh();
        }
    }

    @Override
    public boolean showClientOnly() {
        return this.showClientOnly;
    }

    @Override
    public boolean showFoldersWithOnlyDeletedFiles() {
        return this.showDeleted;
    }

    @Override
    public int size() {
        return this.cached != null ? this.cached.length : 0;
    }

    public String toString() {
        String value = this.getName();
        if (value == null) {
            value = super.toString();
        }
        return "(" + value + ")";
    }

    @Override
    public String getName() {
        if (this.params != null) {
            StringBuilder name = new StringBuilder(this.params.getPortNoNull());
            name.append(',');
            name.append(' ');
            name.append(this.params.getClientNoNull());
            name.append(',');
            name.append(' ');
            name.append(this.params.getUserNoNull());
            String charset = this.params.getCharsetNoNone();
            if (charset != null) {
                name.append(',');
                name.append(' ');
                name.append(charset);
            }
            return name.toString();
        }
        return null;
    }

    @Override
    public void unloadStream(final String streamPath, final UnloadOptions opts) {
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                if (server instanceof IOptionsServer) {
                    ((IOptionsServer)server).unload(opts.setStream(streamPath).setLocked(true));
                }
            }
        };
        this.runOperation(operation);
    }

    @Override
    public void updateClient(final IClient newClient) {
        if (newClient != null) {
            P4ServerOperation operation = new P4ServerOperation(){

                @Override
                public void run(IServer server) throws P4JavaException, P4JavaError {
                    if (!(server instanceof IOptionsServer)) {
                        return;
                    }
                    server.updateClient(newClient);
                    if (P4Connection.this.client != null && P4Connection.this.client.getName().equals(newClient.getName())) {
                        P4Connection.this.connect();
                    }
                }
            };
            this.runOperation(operation);
        }
    }

    @Override
    public void updateResources(IP4Resource[] resources) {
        ArrayList<IP4Resource> newAdded = new ArrayList<IP4Resource>();
        IP4Resource[] iP4ResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (this.updateResourceThenCheckNotify(resource)) {
                newAdded.add(resource);
            }
            ++n2;
        }
        if (newAdded.size() > 0) {
            P4Workspace.getWorkspace().notifyListeners(new P4Event(P4Event.EventType.ADDED, newAdded.toArray(new IP4Resource[0])));
        }
    }

    @Override
    public void updateRevertedFiles(P4Collection collection) {
        IP4Resource[] iP4ResourceArray = collection.members();
        int n = iP4ResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Resource resource = iP4ResourceArray[n2];
            if (resource instanceof IP4File) {
                this.removeFileFromChangelists((IP4File)resource);
            }
            ++n2;
        }
    }

    @Override
    public void removeFileFromChangelists(IP4File file) {
        if (file != null) {
            for (IP4PendingChangelist list : this.changelists.values()) {
                list.removeFile(file);
            }
        }
    }

    @Override
    public void updateStream(final IStream stream) {
        P4ServerOperation operation = new P4ServerOperation(){

            @Override
            public void run(IServer server) throws P4JavaException, P4JavaError {
                if (!(server instanceof IOptionsServer)) {
                    return;
                }
                ((IOptionsServer)server).updateStream(stream, null);
            }
        };
        this.runOperation(operation);
    }

    protected boolean userClientMatches(IFileSpec spec) {
        return this.clientMatches(spec) && this.userMatches(spec);
    }
}

