/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.p4java;

import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.server.IOptionsServer;
import com.perforce.p4java.server.IServer;
import com.perforce.p4java.server.callback.IStreamingCallback;
import com.perforce.team.core.IP4CommandCallback;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.P4JavaCallback;
import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.Messages;
import com.perforce.team.core.p4java.P4Collection;
import com.perforce.team.core.p4java.P4ProgressListener;
import com.perforce.team.core.p4java.P4Resource;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.core.p4java.P4Workspace;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class P4Command {
    private String command;
    private IP4Connection connection;

    public P4Command(IP4Connection connection, String command) {
        this.connection = connection;
        this.command = command;
    }

    public void run(final boolean refresh, final IP4CommandCallback commandCallback) {
        final IP4Connection p4Connection = this.connection;
        final String p4Command = this.command;
        if (p4Connection == null || p4Command == null) {
            return;
        }
        P4Runner.schedule(new P4Runnable(){

            @Override
            public String getTitle() {
                return MessageFormat.format(Messages.P4Command_0, P4Command.this.command);
            }

            @Override
            public void run(IProgressMonitor monitor) {
                IServer server;
                if (p4Connection != null && !p4Connection.isOffline() && p4Command != null && (server = p4Connection.getServer()) != null) {
                    String[] args = P4Command.this.command.split(" ");
                    ArrayList<String> realArgs = new ArrayList<String>();
                    int i = 0;
                    while (i < args.length) {
                        String arg = args[i].trim();
                        if (!(arg.length() <= 0 || i <= 0 && "p4".equals(arg))) {
                            realArgs.add(args[i].trim());
                        }
                        ++i;
                    }
                    try {
                        String commandName = "";
                        if (realArgs.size() > 0) {
                            commandName = (String)realArgs.remove(0);
                        }
                        monitor.beginTask(commandName, 1000);
                        P4JavaCallback p4jCallback = P4Workspace.getWorkspace().getCallback();
                        if (p4jCallback != null) {
                            StringBuffer executing = new StringBuffer();
                            executing.append(commandName);
                            for (String arg : realArgs) {
                                executing.append(" ");
                                executing.append(arg);
                            }
                            p4jCallback.issuingServerCommand(-1, executing.toString());
                        }
                        List<Object> fileSpecs = new ArrayList();
                        int serverVer = server.getServerVersionNumber();
                        if (serverVer >= 20121 && ("sync".equalsIgnoreCase(commandName) || "submit".equalsIgnoreCase(commandName))) {
                            P4ProgressListener progListener = P4CoreUtils.createStreamCallback(P4Command.this.connection, commandName, (IProgressMonitor)new SubProgressMonitor(monitor, 500));
                            server.execStreamingMapCommand(commandName, realArgs.toArray(new String[0]), null, (IStreamingCallback)progListener, P4CoreUtils.getRandomInt());
                            fileSpecs = progListener.getFileSpecs();
                        } else {
                            if (server instanceof IOptionsServer) {
                                List output = ((IOptionsServer)server).execQuietMapCmdList(commandName, realArgs.toArray(new String[0]), null);
                                if (commandCallback != null) {
                                    commandCallback.callback(output);
                                }
                                fileSpecs = P4CoreUtils.extractFileSpecs(p4Connection, output);
                            }
                            monitor.worked(500);
                        }
                        if (refresh) {
                            monitor.setTaskName("Refresh resources...");
                            P4Command.this.refreshResources(fileSpecs);
                            monitor.worked(500);
                        }
                    }
                    catch (P4JavaException e) {
                        String message = e.getMessage();
                        if (message != null && commandCallback != null) {
                            ArrayList<Map<String, Object>> output = new ArrayList<Map<String, Object>>();
                            output.add(new HashMap());
                            ((Map)output.get(0)).put("Error", message);
                            commandCallback.callbackError(output);
                        }
                        PerforceProviderPlugin.logError(e);
                    }
                    monitor.done();
                }
            }
        });
    }

    private void refreshResources(List<IFileSpec> specs) {
        P4Collection resources = new P4Collection();
        for (IFileSpec spec : specs) {
            if (FileSpecOpStatus.VALID != spec.getOpStatus()) continue;
            String path = spec.getDepotPathString();
            if (path == null) {
                path = P4Resource.normalizeLocalPath(spec);
            }
            resources.add(this.connection.getResource(path));
        }
        resources.refresh();
    }
}

