/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.map;

import com.perforce.team.core.map.MapCharClass;

public class MapChar
implements Comparable<MapChar> {
    public static final String[] MAP_CHAR_NAMES = new String[]{"0", "c", "/", "%", "*", "."};
    public static final int PARAM_BASE_PERCENT = 0;
    public static final int PARAM_BASE_STARS = 10;
    public static final int PARAM_BASE_DOTS = 20;
    public static final int PARAM_BASE_TOP = 23;
    public char c;
    public int paramNumber;
    public MapCharClass cc;

    public boolean set(StringBuilder p, ParseSession session) {
        if (p.length() == 0) {
            this.c = '\u0000';
            this.cc = MapCharClass.cEOS;
            return false;
        }
        this.c = p.charAt(0);
        if (this.c == '/') {
            this.cc = MapCharClass.cSLASH;
            p.deleteCharAt(0);
        } else if (this.c == '.' && p.charAt(1) == '.' && p.charAt(2) == '.') {
            this.cc = MapCharClass.cDOTS;
            this.paramNumber = session.nDots++;
            p.delete(0, 3);
        } else if (this.c == '%' && p.charAt(1) == '%' && p.charAt(2) >= '0' && p.charAt(2) <= '9') {
            this.cc = MapCharClass.cPERC;
            this.paramNumber = (char)(0 + (p.charAt(2) - 48));
            p.delete(0, 3);
        } else if (this.c == '*') {
            this.cc = MapCharClass.cSTAR;
            this.paramNumber = (char)(10 + session.nStars++);
            p.deleteCharAt(0);
        } else {
            this.cc = MapCharClass.cCHAR;
            p.deleteCharAt(0);
        }
        return true;
    }

    public void makeParam(StringBuilder p, MapChar mc2, int wildSlot) {
        if (this.cc == MapCharClass.cDOTS && mc2.cc == MapCharClass.cDOTS) {
            p.append("...");
        } else {
            p.append("%%");
            p.append(++wildSlot);
        }
    }

    public String getName() {
        return MAP_CHAR_NAMES[this.cc.ordinal()];
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MapChar) {
            return this.c == ((MapChar)obj).c;
        }
        return false;
    }

    public int hashCode() {
        return this.c;
    }

    @Override
    public int compareTo(MapChar o) {
        return this.c - o.c;
    }

    public boolean isWild() {
        return this.cc.ordinal() >= MapCharClass.cPERC.ordinal();
    }

    public static class ParseSession {
        int nDots = 0;
        int nStars = 0;
    }
}

