/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse.form;

import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.text.timelapse.INodeModel;
import com.perforce.team.ui.text.timelapse.NodeTickDecorator;
import com.perforce.team.ui.timelapse.ActionTickDecorator;
import com.perforce.team.ui.timelapse.IAuthorProvider;
import com.perforce.team.ui.timelapse.ITickDecorator;
import org.eclipse.swt.graphics.Image;

public class FormTickDecorator
extends NodeTickDecorator {
    private Image baseImage;
    private IAuthorProvider authorProvider = new IAuthorProvider(){

        public String getAuthor(IP4Revision revision) {
            return revision.getAuthor();
        }
    };

    public FormTickDecorator(INodeModel model) {
        super(model);
        this.baseImage = PerforceUIPlugin.getDescriptor((String)"normal/empty.png").createImage();
    }

    @Override
    protected ITickDecorator createActionTickDecorator() {
        return new FormActionTickDecorator(this);
    }

    @Override
    protected boolean isModifiedByOwner(IP4Revision revision) {
        return revision.getConnection().isOwner(this.authorProvider.getAuthor(revision));
    }

    @Override
    public void dispose() {
        this.baseImage.dispose();
        super.dispose();
    }

    @Override
    protected Image getBaseImage(Object node) {
        return this.baseImage;
    }

    public void setAuthorProvider(IAuthorProvider provider) {
        if (provider != null) {
            this.authorProvider = provider;
        }
    }

    private static class FormActionTickDecorator
    extends ActionTickDecorator {
        private FormTickDecorator parent;

        public FormActionTickDecorator(FormTickDecorator parent) {
            this.parent = parent;
        }

        protected boolean isModifiedByOwner(IP4Revision revision) {
            return this.parent.isModifiedByOwner(revision);
        }
    }
}

