/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse.form;

import com.perforce.p4java.server.PerforceCharsets;
import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.text.timelapse.IFilterNodeModel;
import com.perforce.team.ui.text.timelapse.NodeModel;
import com.perforce.team.ui.text.timelapse.form.Form;
import com.perforce.team.ui.text.timelapse.form.FormField;
import com.perforce.team.ui.timelapse.IAuthorProvider;
import com.perforce.team.ui.timelapse.IRevisionInputCache;
import com.perforce.team.ui.timelapse.ITempFileInput;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.ui.IEditorInput;

public class FormNodeModel
extends NodeModel
implements IFilterNodeModel,
IAuthorProvider {
    private Set<String> fieldNames = new TreeSet<String>();
    private Map<IP4Revision, Form> forms = new HashMap<IP4Revision, Form>();

    public FormNodeModel(IP4Revision[] revisions, IRevisionInputCache inputCache) {
        super(revisions, inputCache);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public void clear(IP4Revision revision) {
        super.clear(revision);
    }

    @Override
    protected void deleteTempFile(ITempFileInput tempInput) {
    }

    @Override
    public void findNodes(Object nodeInput, IP4Revision revision) {
        if (nodeInput instanceof Form) {
            Form form = (Form)nodeInput;
            FormField[] formFieldArray = form.getFields();
            int n = formFieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                FormField field = formFieldArray[n2];
                if (field != null) {
                    String name = field.getName();
                    this.fieldNames.add(name);
                    int hash = this.computeHash(field.getValue(), P4CoreUtils.charsetForName((String)PerforceCharsets.getJavaCharsetName((String)revision.getCharset())));
                    this.addRecord(hash, name, null, field, revision);
                }
                ++n2;
            }
        }
    }

    public FormField getFormField(String id, IP4Revision revision) {
        return (FormField)this.getElement(revision, id);
    }

    public FormField getFirstFormField(IP4Revision revision) {
        Form form;
        FormField field = null;
        if (revision != null && (form = this.forms.get(revision)) != null) {
            field = form.getFirst();
        }
        return field;
    }

    @Override
    public Object parseInput(IEditorInput input, IP4Revision revision) {
        Form form = new Form(revision.getConnection());
        form.build(input);
        this.forms.put(revision, form);
        return form;
    }

    @Override
    public String getFilterKey(String filterLabel) {
        return filterLabel;
    }

    @Override
    public Collection<String> getFilterLabels() {
        return this.fieldNames;
    }

    @Override
    public String getHandle(Object element) {
        return element instanceof FormField ? ((FormField)element).getName() : null;
    }

    public String getAuthor(IP4Revision revision) {
        Form form;
        String author = null;
        if (revision != null && (form = this.forms.get(revision)) != null) {
            author = form.getAuthor();
        }
        return author;
    }
}

