/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse;

import com.perforce.team.core.p4java.IP4File;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.text.PerforceUiTextPlugin;
import com.perforce.team.ui.text.TextUtils;
import com.perforce.team.ui.text.timelapse.AgingPainter;
import com.perforce.team.ui.text.timelapse.DiffPainter;
import com.perforce.team.ui.text.timelapse.IColorPainter;
import com.perforce.team.ui.text.timelapse.ITextAnnotateModel;
import com.perforce.team.ui.text.timelapse.LineNumberRuler;
import com.perforce.team.ui.text.timelapse.LowerRevisionRuler;
import com.perforce.team.ui.text.timelapse.LowerUserRuler;
import com.perforce.team.ui.text.timelapse.Messages;
import com.perforce.team.ui.text.timelapse.RevisionRuler;
import com.perforce.team.ui.text.timelapse.TextAnnotateModel;
import com.perforce.team.ui.text.timelapse.UpperRevisionRuler;
import com.perforce.team.ui.text.timelapse.UpperUserRuler;
import com.perforce.team.ui.text.timelapse.UserRuler;
import com.perforce.team.ui.timelapse.IAnnotateModel;
import com.perforce.team.ui.timelapse.TimeLapseEditor;
import com.perforce.team.ui.timelapse.TimeLapseInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.FindReplaceAction;

public abstract class TextTimeLapseEditor
extends TimeLapseEditor {
    public static final String MOST_RECENT_COLOR = "com.perforce.team.ui.text.timelapse.MOST_RECENT_COLOR";
    public static final String LEAST_RECENT_COLOR = "com.perforce.team.ui.text.timelapse.LEAST_RECENT_COLOR";
    public static final String SHOW_AGING = "com.perforce.team.ui.text.timelapse.SHOW_AGING";
    public static final String SHOW_AUTHORS = "com.perforce.team.ui.text.timelapse.SHOW_AUTHORS";
    public static final String SHOW_RANGES = "com.perforce.team.ui.text.timelapse.SHOW_RANGES";
    public static final String WHITESPACE_TYPE = "com.perforce.team.ui.text.timelapse.WHITESPACE_TYPE";
    private static final int BLOCK_IMG_SIZE = 16;
    private ITextAnnotateModel model;
    private boolean aging = false;
    private IP4File.WhitespaceIgnoreType ignoreType;
    private boolean showingAuthors = false;
    private boolean showingRanges = false;
    private int topIndexModelLine = -1;
    protected boolean updatingDoc = false;
    protected boolean redraw = false;
    private IColorPainter currentPainter;
    private IColorPainter diffPainter;
    private AgingPainter agingPainter;
    private RGB leastRecentRgb;
    private RGB mostRecentRgb;
    private Font textFont = null;
    private CompositeRuler ruler = null;
    private LineNumberRuler numbersRuler = null;
    private RevisionRuler lowerRevisionRuler;
    private UserRuler lowerUserRuler;
    private RevisionRuler upperRevisionRuler;
    private UserRuler upperUserRuler;
    private FindReplaceAction findAction;

    protected void fillToolbar(final ToolBar toolbar) {
        super.fillToolbar(toolbar);
        final ToolItem agingItem = new ToolItem(toolbar, 4);
        agingItem.setToolTipText(Messages.TextTimeLapseEditor_TextAging);
        agingItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTimeLapseEditor.this.createAgingMenu(toolbar, agingItem);
            }
        });
        Image agingIcon = PerforceUiTextPlugin.getImageDescriptor("icons/age_icon.png").createImage();
        P4UIUtils.registerDisposal((Widget)agingItem, (Resource)agingIcon);
        agingItem.setImage(agingIcon);
        final ToolItem whitespaceItem = new ToolItem(toolbar, 4);
        whitespaceItem.setToolTipText(Messages.TextTimeLapseEditor_WhitespaceOptions);
        whitespaceItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTimeLapseEditor.this.createWhitespaceMenu(toolbar, whitespaceItem);
            }
        });
        Image whitespaceIcon = PerforceUiTextPlugin.getImageDescriptor("icons/whitespace_mode.png").createImage();
        P4UIUtils.registerDisposal((Widget)whitespaceItem, (Resource)whitespaceIcon);
        whitespaceItem.setImage(whitespaceIcon);
        final ToolItem userItem = new ToolItem(toolbar, 32);
        userItem.setToolTipText(Messages.TextTimeLapseEditor_ShowAuthorsInRuler);
        userItem.setSelection(this.showingAuthors);
        userItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTimeLapseEditor.this.showingAuthors = userItem.getSelection();
                if (TextTimeLapseEditor.this.showingAuthors) {
                    TextTimeLapseEditor.this.createAuthorRulers();
                    TextTimeLapseEditor.this.redrawRulers();
                } else {
                    TextTimeLapseEditor.this.ruler.removeDecorator((IVerticalRulerColumn)TextTimeLapseEditor.this.lowerUserRuler);
                    TextTimeLapseEditor.this.ruler.removeDecorator((IVerticalRulerColumn)TextTimeLapseEditor.this.upperUserRuler);
                }
                TextTimeLapseEditor.this.updatePreferences();
            }
        });
        Image userIcon = PerforceUiTextPlugin.getImageDescriptor("icons/user.png").createImage();
        P4UIUtils.registerDisposal((Widget)userItem, (Resource)userIcon);
        userItem.setImage(userIcon);
        final ToolItem rangeItem = new ToolItem(toolbar, 32);
        rangeItem.setToolTipText(Messages.TextTimeLapseEditor_ShowRangesInRuler);
        rangeItem.setSelection(this.showingRanges);
        rangeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTimeLapseEditor.this.showingRanges = rangeItem.getSelection();
                if (TextTimeLapseEditor.this.showingRanges) {
                    TextTimeLapseEditor.this.createRevisionRulers();
                    TextTimeLapseEditor.this.redrawRulers();
                } else {
                    TextTimeLapseEditor.this.ruler.removeDecorator((IVerticalRulerColumn)TextTimeLapseEditor.this.lowerRevisionRuler);
                    TextTimeLapseEditor.this.ruler.removeDecorator((IVerticalRulerColumn)TextTimeLapseEditor.this.upperRevisionRuler);
                }
                TextTimeLapseEditor.this.updatePreferences();
            }
        });
        Image rangeIcon = PerforceUiTextPlugin.getImageDescriptor("icons/date.png").createImage();
        P4UIUtils.registerDisposal((Widget)rangeItem, (Resource)rangeIcon);
        rangeItem.setImage(rangeIcon);
    }

    private void createWhitespaceMenu(ToolBar toolbar, ToolItem whitespaceItem) {
        Menu menu = new Menu((Control)toolbar);
        MenuItem ignoreAll = new MenuItem(menu, 32);
        ignoreAll.setText(Messages.TextTimeLapseEditor_IgnoreLineEndingAndAllWS);
        ignoreAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTimeLapseEditor.this.updateIgnoreType(IP4File.WhitespaceIgnoreType.ALL);
            }
        });
        MenuItem ignoreNone = new MenuItem(menu, 32);
        ignoreNone.setText(Messages.TextTimeLapseEditor_RecognizeLineEndingAndWS);
        ignoreNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTimeLapseEditor.this.updateIgnoreType(null);
            }
        });
        MenuItem ignoreWhitespace = new MenuItem(menu, 32);
        ignoreWhitespace.setText(Messages.TextTimeLapseEditor_IgnoreLineEndingAndWS);
        ignoreWhitespace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTimeLapseEditor.this.updateIgnoreType(IP4File.WhitespaceIgnoreType.WHITESPACE);
            }
        });
        MenuItem ignoreLineEndings = new MenuItem(menu, 32);
        ignoreLineEndings.setText(Messages.TextTimeLapseEditor_IgnoreLineEnding);
        ignoreLineEndings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTimeLapseEditor.this.updateIgnoreType(IP4File.WhitespaceIgnoreType.LINE_ENDINGS);
            }
        });
        if (this.ignoreType != null) {
            switch (this.ignoreType) {
                case ALL: {
                    ignoreAll.setSelection(true);
                    break;
                }
                case WHITESPACE: {
                    ignoreWhitespace.setSelection(true);
                    break;
                }
                case LINE_ENDINGS: {
                    ignoreLineEndings.setSelection(true);
                    break;
                }
            }
        } else {
            ignoreNone.setSelection(true);
        }
        Rectangle bounds = whitespaceItem.getBounds();
        Point location = toolbar.toDisplay(bounds.x, bounds.y + bounds.height);
        menu.setLocation(location);
        menu.setVisible(true);
    }

    private void updateIgnoreType(IP4File.WhitespaceIgnoreType type) {
        if (this.ignoreType != type) {
            this.ignoreType = type;
            this.updatePreferences();
            this.preserveSelectionLoad();
        }
    }

    private void createAgingMenu(final ToolBar toolbar, ToolItem agingItem) {
        Menu menu = new Menu((Control)toolbar);
        final MenuItem showAging = new MenuItem(menu, 32);
        showAging.setText(Messages.TextTimeLapseEditor_DisplayTextAging);
        showAging.setSelection(this.aging);
        showAging.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextTimeLapseEditor.this.aging = showAging.getSelection();
                TextTimeLapseEditor.this.updatePreferences();
                TextTimeLapseEditor.this.updateAgingColors();
            }
        });
        final IPreferenceStore store = PerforceUiTextPlugin.getDefault().getPreferenceStore();
        Image leastRecentImage = this.createBlockImage(toolbar.getDisplay(), this.leastRecentRgb);
        P4UIUtils.registerDisposal((Widget)menu, (Resource)leastRecentImage);
        Image mostRecentImage = this.createBlockImage(toolbar.getDisplay(), this.mostRecentRgb);
        P4UIUtils.registerDisposal((Widget)menu, (Resource)mostRecentImage);
        MenuItem mostRecentColor = new MenuItem(menu, 8);
        mostRecentColor.setText(Messages.TextTimeLapseEditor_ConfigureMostRexentTextColor);
        mostRecentColor.setImage(mostRecentImage);
        mostRecentColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog dialog = new ColorDialog(toolbar.getShell());
                dialog.setRGB(TextTimeLapseEditor.this.mostRecentRgb);
                RGB newMostRecent = dialog.open();
                if (newMostRecent != null) {
                    PreferenceConverter.setValue((IPreferenceStore)store, (String)TextTimeLapseEditor.MOST_RECENT_COLOR, (RGB)newMostRecent);
                    TextTimeLapseEditor.this.mostRecentRgb = newMostRecent;
                    TextTimeLapseEditor.this.reloadAgingColors();
                }
            }
        });
        MenuItem leastRecentColor = new MenuItem(menu, 8);
        leastRecentColor.setText(Messages.TextTimeLapseEditor_ConfigureLeastRecentTextColor);
        leastRecentColor.setImage(leastRecentImage);
        leastRecentColor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog dialog = new ColorDialog(toolbar.getShell());
                dialog.setRGB(TextTimeLapseEditor.this.leastRecentRgb);
                RGB newLeastRecent = dialog.open();
                if (newLeastRecent != null) {
                    PreferenceConverter.setValue((IPreferenceStore)store, (String)TextTimeLapseEditor.LEAST_RECENT_COLOR, (RGB)newLeastRecent);
                    TextTimeLapseEditor.this.leastRecentRgb = newLeastRecent;
                    TextTimeLapseEditor.this.reloadAgingColors();
                }
            }
        });
        Rectangle bounds = agingItem.getBounds();
        Point location = toolbar.toDisplay(bounds.x, bounds.y + bounds.height);
        menu.setLocation(location);
        menu.setVisible(true);
    }

    private Image createBlockImage(Display display, RGB rgb) {
        Image image = new Image((Device)display, 16, 16);
        GC gc = new GC((Drawable)image);
        Color color = new Color((Device)display, rgb);
        try {
            gc.setBackground(new Color((Device)display, rgb));
            gc.fillRectangle(0, 0, 16, 16);
        }
        finally {
            gc.dispose();
            color.dispose();
        }
        return image;
    }

    private void reloadAgingColors() {
        this.agingPainter.setLeastRecent(this.leastRecentRgb);
        this.agingPainter.setMostRecent(this.mostRecentRgb);
        this.agingPainter.loadColors(this.getRevision());
        this.updateAgingColors();
    }

    private void updateAgingColors() {
        this.resetPainter();
        this.getViewer().getTextWidget().redraw();
        this.getViewer().getTextWidget().update();
        this.redrawRulers();
    }

    protected void createHeader(Composite parent) {
    }

    private void updatePreferences() {
        IPreferenceStore store = PerforceUiTextPlugin.getDefault().getPreferenceStore();
        store.setValue(SHOW_AGING, this.aging);
        store.setValue(SHOW_AUTHORS, this.showingAuthors);
        store.setValue(SHOW_RANGES, this.showingRanges);
        String type = "";
        if (this.ignoreType != null) {
            type = this.ignoreType.toString();
        }
        store.setValue(WHITESPACE_TYPE, type);
    }

    protected void updateDisplay(IAnnotateModel.Type type) {
        super.updateDisplay(type);
        if (this.showingRanges) {
            this.ruler.removeDecorator((IVerticalRulerColumn)this.lowerRevisionRuler);
            this.ruler.removeDecorator((IVerticalRulerColumn)this.upperRevisionRuler);
            this.createRevisionRulers(type);
            this.redrawRulers();
        }
    }

    protected abstract ITextViewer getViewer();

    protected abstract void refresh(IEditorInput var1);

    protected int convertToModelLine(int widgetLine) {
        return widgetLine;
    }

    protected int convertToWidgetLine(int modelLine) {
        return modelLine;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        IPreferenceStore store = PerforceUiTextPlugin.getDefault().getPreferenceStore();
        this.aging = store.getBoolean(SHOW_AGING);
        this.leastRecentRgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)LEAST_RECENT_COLOR);
        this.mostRecentRgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)MOST_RECENT_COLOR);
        this.showingAuthors = store.getBoolean(SHOW_AUTHORS);
        this.showingRanges = store.getBoolean(SHOW_RANGES);
        try {
            this.ignoreType = IP4File.WhitespaceIgnoreType.valueOf((String)store.getString(WHITESPACE_TYPE));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.ignoreType = null;
        }
    }

    protected ITextAnnotateModel createTextAnnotateModel(IP4File file) {
        return new TextAnnotateModel(file, null, ((TimeLapseInput)this.getEditorInput()).useChangelistKeys());
    }

    public ITextAnnotateModel getAnnotateModel() {
        return this.model;
    }

    protected void loadEditor(IP4File file, IProgressMonitor monitor) {
        super.loadEditor(file, monitor);
        monitor.setTaskName(String.valueOf(Messages.TextTimeLapseEditor_LoadP4Annotate) + file.getActionPath());
        if (this.model == null) {
            this.model = this.createTextAnnotateModel(file);
        }
        this.model.clear();
        this.model.load(this.getRevisions(), this.showBranches(), this.getIgnoreType());
    }

    protected IP4File.WhitespaceIgnoreType getIgnoreType() {
        return this.ignoreType;
    }

    protected IStorageEditorInput generateInput(IP4Revision revision) {
        return this.model.generateInput(revision);
    }

    protected void updateDocument(IEditorInput input) {
        ITextViewer viewer = this.getViewer();
        if (viewer != null) {
            if (this.redraw) {
                this.getControl().setRedraw(false);
            }
            try {
                this.updatingDoc = true;
                this.topIndexModelLine = viewer.getTextWidget().getTopIndex();
                this.topIndexModelLine = this.convertToModelLine(this.topIndexModelLine);
                this.refresh(input);
                this.updateColors();
                this.updateRulers();
                this.updatingDoc = false;
                viewer.getTextWidget().redraw();
                this.updateVisibleRange();
                this.redrawRulers();
                this.findAction.update();
            }
            finally {
                if (this.redraw) {
                    this.getControl().setRedraw(true);
                    this.getControl().update();
                }
            }
        }
    }

    protected void setRedraw(boolean redraw) {
        this.getViewer().getTextWidget().setRedraw(redraw);
    }

    protected void updateVisibleRange() {
        if (this.topIndexModelLine > -1) {
            this.setRedraw(false);
            this.getViewer().getTextWidget().setTopIndex(this.convertToWidgetLine(this.topIndexModelLine));
            this.setRedraw(true);
        }
    }

    protected void updateColors() {
        IP4Revision revision = this.getRevision();
        this.agingPainter.loadColors(revision);
        this.diffPainter.loadColors(this.model.getLineRanges(revision));
    }

    protected RGB getEditorRgb(String key) {
        return TextUtils.getEditorRgb(key);
    }

    protected Color getEditorColor(String key) {
        return TextUtils.getEditorColor(key);
    }

    protected ISharedTextColors getSharedTextColors() {
        return TextUtils.getSharedTextColors();
    }

    private void resetPainter() {
        this.currentPainter = this.aging ? this.agingPainter : this.diffPainter;
        this.setRulerPainter(this.currentPainter);
    }

    private void setRulerPainter(IColorPainter painter) {
        if (this.numbersRuler != null) {
            this.numbersRuler.setPainter(painter);
        }
        if (this.lowerRevisionRuler != null) {
            this.lowerRevisionRuler.setPainter(painter);
        }
        if (this.upperRevisionRuler != null) {
            this.upperRevisionRuler.setPainter(painter);
        }
        if (this.lowerUserRuler != null) {
            this.lowerUserRuler.setPainter(painter);
        }
        if (this.upperUserRuler != null) {
            this.upperUserRuler.setPainter(painter);
        }
    }

    private void setRulerFont() {
        if (this.textFont != null) {
            if (this.lowerUserRuler != null) {
                this.lowerUserRuler.setFont(this.textFont);
            }
            if (this.lowerRevisionRuler != null) {
                this.lowerRevisionRuler.setFont(this.textFont);
            }
            if (this.upperUserRuler != null) {
                this.upperUserRuler.setFont(this.textFont);
            }
            if (this.upperRevisionRuler != null) {
                this.upperRevisionRuler.setFont(this.textFont);
            }
            if (this.numbersRuler != null) {
                this.numbersRuler.setFont(this.textFont);
            }
        }
    }

    private void updateRulers() {
        IP4Revision current = this.getRevision();
        if (this.lowerRevisionRuler != null) {
            this.lowerRevisionRuler.setRevision(current);
            this.lowerRevisionRuler.updateSize();
        }
        if (this.upperRevisionRuler != null) {
            this.upperRevisionRuler.setRevision(current);
            this.upperRevisionRuler.updateSize();
        }
        if (this.lowerUserRuler != null) {
            this.lowerUserRuler.setRevision(current);
            this.lowerUserRuler.updateSize();
        }
        if (this.upperUserRuler != null) {
            this.upperUserRuler.setRevision(current);
            this.upperUserRuler.updateSize();
        }
        if (this.numbersRuler != null) {
            this.numbersRuler.updateSize();
        }
    }

    private void createAuthorRulers() {
        this.lowerUserRuler = new LowerUserRuler(this.model);
        this.lowerUserRuler.setBackground(this.getEditorColor("AbstractTextEditor.Color.Background"));
        this.lowerUserRuler.setForeground(this.getEditorColor("AbstractTextEditor.Color.Foreground"));
        this.ruler.addDecorator(this.showingRanges ? 1 : 0, (IVerticalRulerColumn)this.lowerUserRuler);
        this.upperUserRuler = new UpperUserRuler(this.model);
        this.upperUserRuler.setBackground(this.getEditorColor("AbstractTextEditor.Color.Background"));
        this.upperUserRuler.setForeground(this.getEditorColor("AbstractTextEditor.Color.Foreground"));
        this.ruler.addDecorator(this.showingRanges ? 3 : 1, (IVerticalRulerColumn)this.upperUserRuler);
        IP4Revision revision = this.getRevision();
        if (revision != null) {
            this.lowerUserRuler.setRevision(revision);
            this.upperUserRuler.setRevision(revision);
            this.lowerUserRuler.updateSize();
            this.upperUserRuler.updateSize();
        }
        if (this.textFont != null) {
            this.lowerUserRuler.setFont(this.textFont);
            this.upperUserRuler.setFont(this.textFont);
        }
        this.resetPainter();
    }

    private void createRevisionRulers() {
        this.createRevisionRulers(this.getDisplayType());
    }

    private void createRevisionRulers(IAnnotateModel.Type type) {
        this.lowerRevisionRuler = new LowerRevisionRuler(this.model);
        this.lowerRevisionRuler.setType(type);
        this.lowerRevisionRuler.setBackground(this.getEditorColor("AbstractTextEditor.Color.Background"));
        this.lowerRevisionRuler.setForeground(this.getEditorColor("AbstractTextEditor.Color.Foreground"));
        this.ruler.addDecorator(0, (IVerticalRulerColumn)this.lowerRevisionRuler);
        this.upperRevisionRuler = new UpperRevisionRuler(this.model);
        this.upperRevisionRuler.setType(type);
        this.upperRevisionRuler.setBackground(this.getEditorColor("AbstractTextEditor.Color.Background"));
        this.upperRevisionRuler.setForeground(this.getEditorColor("AbstractTextEditor.Color.Foreground"));
        this.ruler.addDecorator(this.showingAuthors ? 2 : 1, (IVerticalRulerColumn)this.upperRevisionRuler);
        IP4Revision revision = this.getRevision();
        if (revision != null) {
            this.lowerRevisionRuler.setRevision(revision);
            this.upperRevisionRuler.setRevision(revision);
            this.lowerRevisionRuler.updateSize();
            this.upperRevisionRuler.updateSize();
        }
        if (this.textFont != null) {
            this.lowerRevisionRuler.setFont(this.textFont);
            this.upperRevisionRuler.setFont(this.textFont);
        }
        this.resetPainter();
    }

    protected void configureViewer(String fontPrefName) {
        ITextViewer viewer = this.getViewer();
        if (viewer != null) {
            GridData viewerData = new GridData(4, 4, true, true);
            if (viewer instanceof Viewer) {
                ((Viewer)viewer).getControl().setLayoutData((Object)viewerData);
            }
            this.textFont = JFaceResources.getFont((String)fontPrefName);
            final StyledText text = viewer.getTextWidget();
            text.setFont(this.textFont);
            viewer.setEditable(false);
            text.setLayoutData((Object)viewerData);
            this.agingPainter = new AgingPainter(this.model, viewer);
            this.diffPainter = new DiffPainter();
            text.addLineBackgroundListener(new LineBackgroundListener(){

                public void lineGetBackground(LineBackgroundEvent event) {
                    int line = text.getLineAtOffset(event.lineOffset);
                    line = TextTimeLapseEditor.this.convertToModelLine(line);
                    event.lineBackground = TextTimeLapseEditor.this.currentPainter.getColor(line);
                }
            });
            this.setRulerFont();
            this.resetPainter();
            this.findAction = new FindReplaceAction(Messages.RESOURCE_BUNDLE, null, (IWorkbenchPart)this);
            this.findAction.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
            this.getEditorSite().getKeyBindingService().registerAction((IAction)this.findAction);
        }
    }

    public Object getAdapter(Class adapter) {
        ITextViewer viewer;
        if (IFindReplaceTarget.class == adapter && (viewer = this.getViewer()) != null) {
            return viewer.getFindReplaceTarget();
        }
        return super.getAdapter(adapter);
    }

    protected void redrawRulers() {
        this.redrawRulers(true);
    }

    protected void redrawRulers(boolean explicit) {
        if (explicit) {
            if (this.numbersRuler != null) {
                this.numbersRuler.markForRedraw();
            }
            if (this.upperRevisionRuler != null) {
                this.upperRevisionRuler.markForRedraw();
            }
            if (this.lowerRevisionRuler != null) {
                this.lowerRevisionRuler.markForRedraw();
            }
            if (this.upperUserRuler != null) {
                this.upperUserRuler.markForRedraw();
            }
            if (this.lowerUserRuler != null) {
                this.lowerUserRuler.markForRedraw();
            }
        }
        if (this.ruler != null) {
            ITextViewer viewer = this.getViewer();
            StyledText parent = viewer.getTextWidget();
            if (viewer instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)viewer;
                parent = extension.getControl();
            }
            if (parent instanceof Composite && !parent.isDisposed()) {
                ((Composite)parent).layout(true);
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.agingPainter != null) {
            this.agingPainter.dispose();
        }
        if (this.diffPainter != null) {
            this.diffPainter.dispose();
        }
        if (this.findAction != null) {
            this.getEditorSite().getKeyBindingService().unregisterAction((IAction)this.findAction);
        }
    }

    protected CompositeRuler getRuler() {
        return this.ruler;
    }

    protected CompositeRuler configureRulers(boolean addLineNumbers) {
        this.ruler = new CompositeRuler(0);
        if (this.showingRanges) {
            this.createRevisionRulers();
        }
        if (this.showingAuthors) {
            this.createAuthorRulers();
        }
        if (this.numbersRuler == null && addLineNumbers) {
            this.numbersRuler = new LineNumberRuler();
            this.numbersRuler.setBackground(this.getEditorColor("AbstractTextEditor.Color.Background"));
            this.numbersRuler.setForeground(this.getEditorColor("AbstractTextEditor.Color.Foreground"));
            this.ruler.addDecorator(4, (IVerticalRulerColumn)this.numbersRuler);
        }
        return this.ruler;
    }
}

