/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse;

import com.perforce.p4java.core.file.FileAction;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.decorator.OverlayIcon;
import com.perforce.team.ui.text.timelapse.INodeModel;
import com.perforce.team.ui.timelapse.ActionTickDecorator;
import com.perforce.team.ui.timelapse.ITickDecorator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public abstract class NodeTickDecorator
implements ITickDecorator {
    public static final int IMAGE_SIZE = 16;
    private Map<IP4Revision, INodeModel.ChangeType> types = new HashMap<IP4Revision, INodeModel.ChangeType>();
    private Map<OverlayIcon, Image> decorations = new HashMap<OverlayIcon, Image>();
    private Image lastBase;
    private Image blankImage;
    private INodeModel model;
    private String nodeId;
    protected ITickDecorator actionDecorator;

    public NodeTickDecorator(INodeModel model) {
        this(model, null);
        this.actionDecorator = this.createActionTickDecorator();
    }

    protected ITickDecorator createActionTickDecorator() {
        return new ActionTickDecorator();
    }

    public NodeTickDecorator(INodeModel model, String nodeId) {
        this.model = model;
        this.setNodeId(nodeId);
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String id) {
        this.nodeId = id;
        this.lastBase = null;
        this.types.clear();
        if (this.nodeId != null && this.model != null) {
            INodeModel.IRecord[] records;
            INodeModel.IRecord[] iRecordArray = records = this.model.getNodeRecords(this.nodeId);
            int n = records.length;
            int n2 = 0;
            while (n2 < n) {
                INodeModel.IRecord record = iRecordArray[n2];
                this.types.put(record.getRevision(), record.getType());
                ++n2;
            }
        }
    }

    public void setModel(INodeModel model) {
        this.model = model;
    }

    protected abstract Image getBaseImage(Object var1);

    protected boolean isModifiedByOwner(IP4Revision revision) {
        return revision.isModifiedByOwner();
    }

    private ImageDescriptor getFileDescriptor(IP4Revision revision) {
        String id = null;
        FileAction action = revision.getAction();
        if (action != null) {
            boolean owned = this.isModifiedByOwner(revision);
            switch (action) {
                case ADD: 
                case MOVE_ADD: {
                    if (owned) {
                        id = "decorations/add.png";
                        break;
                    }
                    id = "decorations/add_other.png";
                    break;
                }
                case BRANCH: {
                    if (owned) {
                        id = "decorations/branch.png";
                        break;
                    }
                    id = "decorations/branch_other.png";
                    break;
                }
                case EDIT: {
                    if (owned) {
                        id = "decorations/edit.png";
                        break;
                    }
                    id = "decorations/edit_other.png";
                    break;
                }
                case INTEGRATE: {
                    if (owned) {
                        id = "decorations/integrate.png";
                        break;
                    }
                    id = "decorations/integrate_other.png";
                    break;
                }
                case DELETE: 
                case MOVE_DELETE: {
                    if (owned) {
                        id = "decorations/delete.png";
                        break;
                    }
                    id = "decorations/delete_other.png";
                    break;
                }
            }
        }
        return id != null ? PerforceUIPlugin.getDescriptor(id) : null;
    }

    protected ImageDescriptor[] getDecoration(INodeModel.ChangeType type, IP4Revision revision) {
        ImageDescriptor[] descriptor = new ImageDescriptor[2];
        descriptor[0] = this.getFileDescriptor(revision);
        switch (type) {
            case ADD: {
                descriptor[1] = PerforceUIPlugin.getDescriptor((String)"decorations/add_func.png");
                break;
            }
            case DELETE: {
                descriptor[1] = PerforceUIPlugin.getDescriptor((String)"decorations/delete_func.png");
                break;
            }
            case EDIT: {
                descriptor[1] = PerforceUIPlugin.getDescriptor((String)"decorations/edit_func.png");
                break;
            }
            default: {
                return null;
            }
        }
        return descriptor[0] != null && descriptor[1] != null ? descriptor : null;
    }

    public void decorate(IP4Revision revision, int x, int y, GC gc) {
        if (this.nodeId != null && this.model != null) {
            INodeModel.ChangeType type = this.types.get(revision);
            if (type != null && type != INodeModel.ChangeType.UNCHANGED) {
                if (INodeModel.ChangeType.DELETE != type) {
                    Object node = this.model.getNode(this.nodeId, revision);
                    if (node != null) {
                        Image base = this.getBaseImage(node);
                        if (base != null) {
                            this.lastBase = base;
                        }
                        ImageDescriptor[] decorators = this.getDecoration(type, revision);
                        if (base != null && decorators != null) {
                            OverlayIcon icon = new OverlayIcon(base, decorators, new int[]{4, 1});
                            Image full = this.decorations.get(icon);
                            if (full == null) {
                                full = icon.createImage();
                                this.decorations.put(icon, full);
                            }
                            gc.drawImage(full, x - full.getBounds().width / 2, y);
                        }
                    }
                } else {
                    ImageDescriptor[] decorators;
                    Image base;
                    if (this.blankImage == null) {
                        ImageData data = new ImageData(16, 16, 1, new PaletteData(new RGB[]{gc.getBackground().getRGB()}));
                        this.blankImage = new Image(gc.getDevice(), data);
                    }
                    if ((base = this.lastBase) == null) {
                        base = this.blankImage;
                    }
                    if ((decorators = this.getDecoration(type, revision)) != null) {
                        OverlayIcon icon = new OverlayIcon(base, decorators, new int[]{4, 1});
                        Image full = this.decorations.get(icon);
                        if (full == null) {
                            full = icon.createImage();
                            this.decorations.put(icon, full);
                        }
                        gc.drawImage(full, x - full.getBounds().width / 2, y);
                    }
                }
            }
        } else {
            this.actionDecorator.decorate(revision, x, y, gc);
        }
    }

    public void dispose() {
        this.actionDecorator.dispose();
        for (Image image : this.decorations.values()) {
            image.dispose();
        }
        if (this.blankImage != null) {
            this.blankImage.dispose();
        }
    }
}

