/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.text.timelapse.INodeModel;
import com.perforce.team.ui.text.timelapse.Messages;
import com.perforce.team.ui.timelapse.IRevisionInputCache;
import com.perforce.team.ui.timelapse.ITempFileInput;
import java.io.File;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public abstract class NodeModel
implements INodeModel {
    private Map<IP4Revision, Map<String, NodeRecord>> records = Collections.synchronizedMap(new HashMap());
    private Map<String, INodeModel.ChangeType[]> typeStore = Collections.synchronizedMap(new HashMap());
    private IP4Revision[] revisions = null;
    private IRevisionInputCache cache = null;
    private MessageDigest digester = null;
    private boolean complete = false;

    public NodeModel(IP4Revision[] revisions, IRevisionInputCache inputCache) {
        this.revisions = revisions;
        this.cache = inputCache;
        try {
            this.digester = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.digester = null;
        }
    }

    @Override
    public void clear() {
        this.records.clear();
        this.typeStore.clear();
        this.complete = false;
    }

    @Override
    public void clear(IP4Revision revision) {
        if (this.records.remove(revision) != null) {
            this.complete = false;
        }
    }

    protected NodeRecord getRecord(IP4Revision revision, String id) {
        NodeRecord record = null;
        Map<String, NodeRecord> revRecords = this.records.get(revision);
        if (revRecords != null) {
            record = revRecords.get(id);
        }
        return record;
    }

    @Override
    public int getTotalChangeCount(IP4Revision revision, String id) {
        int hash = 0;
        int change = 0;
        NodeRecord record = this.getRecord(revision, id);
        if (record != null) {
            if (record.head > 0) {
                change = record.head;
            } else {
                IP4Revision[] iP4RevisionArray = this.revisions;
                int n = this.revisions.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Revision rev = iP4RevisionArray[n2];
                    NodeRecord found = this.getRecord(rev, id);
                    if (found != null && hash != found.hash) {
                        ++change;
                        hash = found.hash;
                    } else if (found == null && hash != 0) {
                        ++change;
                        hash = 0;
                    }
                    ++n2;
                }
            }
            record.head = change;
        }
        return change;
    }

    @Override
    public int getRelativeChangeCount(IP4Revision revision, String id) {
        int hash = 0;
        int change = 0;
        NodeRecord record = this.getRecord(revision, id);
        if (record != null) {
            if (record.have > 0) {
                change = record.have;
            } else {
                IP4Revision[] iP4RevisionArray = this.revisions;
                int n = this.revisions.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4Revision rev = iP4RevisionArray[n2];
                    NodeRecord found = this.getRecord(rev, id);
                    if (found != null && hash != found.hash) {
                        ++change;
                        hash = found.hash;
                    } else if (found == null && hash != 0) {
                        ++change;
                        hash = 0;
                    }
                    if (rev.equals(revision)) break;
                    ++n2;
                }
            }
            record.have = change;
        }
        return change;
    }

    @Override
    public INodeModel.IRecord[] getNodeRecords(String id) {
        INodeModel.IRecord[] records = new INodeModel.IRecord[this.revisions.length];
        INodeModel.ChangeType[] types = this.getRecords(id);
        int i = 0;
        while (i < types.length) {
            records[i] = new Record(id, this.revisions[i], types[i]);
            ++i;
        }
        return records;
    }

    @Override
    public IP4Revision[] getChangeRevisions(String id) {
        int hash = 0;
        ArrayList<IP4Revision> changes = new ArrayList<IP4Revision>();
        IP4Revision[] iP4RevisionArray = this.revisions;
        int n = this.revisions.length;
        int n2 = 0;
        while (n2 < n) {
            NodeRecord found;
            IP4Revision revision = iP4RevisionArray[n2];
            Map<String, NodeRecord> revRecords = this.records.get(revision);
            if (revRecords != null && (found = revRecords.get(id)) != null && hash != found.hash) {
                changes.add(revision);
                hash = found.hash;
            }
            ++n2;
        }
        return changes.toArray(new IP4Revision[changes.size()]);
    }

    @Override
    public int getChangeCount(String id) {
        int changes = 0;
        int hash = 0;
        IP4Revision[] iP4RevisionArray = this.revisions;
        int n = this.revisions.length;
        int n2 = 0;
        while (n2 < n) {
            NodeRecord found;
            IP4Revision revision = iP4RevisionArray[n2];
            Map<String, NodeRecord> revRecords = this.records.get(revision);
            if (revRecords != null && (found = revRecords.get(id)) != null && hash != found.hash) {
                ++changes;
                hash = found.hash;
            }
            ++n2;
        }
        return changes;
    }

    @Override
    public IP4Revision[] getRevisions(String id) {
        ArrayList<IP4Revision> foundRevisions = new ArrayList<IP4Revision>();
        if (id != null) {
            IP4Revision[] iP4RevisionArray = this.revisions;
            int n = this.revisions.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Revision revision = iP4RevisionArray[n2];
                Map<String, NodeRecord> revRecords = this.records.get(revision);
                if (revRecords != null && revRecords.containsKey(id)) {
                    foundRevisions.add(revision);
                }
                ++n2;
            }
        }
        return foundRevisions.toArray(new IP4Revision[foundRevisions.size()]);
    }

    @Override
    public INodeModel.ChangeType[] getRecords(String id) {
        INodeModel.ChangeType[] types = new INodeModel.ChangeType[]{};
        if (id != null && (types = this.typeStore.get(id)) == null) {
            types = new INodeModel.ChangeType[this.revisions.length];
            Arrays.fill((Object[])types, (Object)INodeModel.ChangeType.UNCHANGED);
            int index = 0;
            INodeModel.ChangeType lastType = INodeModel.ChangeType.UNCHANGED;
            int lastHash = 0;
            IP4Revision[] iP4RevisionArray = this.revisions;
            int n = this.revisions.length;
            int n2 = 0;
            while (n2 < n) {
                IP4Revision revision = iP4RevisionArray[n2];
                Map<String, NodeRecord> revRecords = this.records.get(revision);
                if (revRecords != null) {
                    NodeRecord found = revRecords.get(id);
                    switch (lastType) {
                        case ADD: 
                        case EDIT: {
                            if (found != null) {
                                if (found.hash == lastHash) break;
                                lastHash = found.hash;
                                types[index] = INodeModel.ChangeType.EDIT;
                                break;
                            }
                            types[index] = INodeModel.ChangeType.DELETE;
                            lastHash = 0;
                            break;
                        }
                        case DELETE: {
                            if (found == null) break;
                            lastHash = found.hash;
                            types[index] = INodeModel.ChangeType.ADD;
                            break;
                        }
                        case UNCHANGED: {
                            if (found != null) {
                                if (lastHash == 0) {
                                    types[index] = INodeModel.ChangeType.ADD;
                                } else if (found.hash != lastHash) {
                                    types[index] = INodeModel.ChangeType.EDIT;
                                }
                                lastHash = found.hash;
                                break;
                            }
                            if (lastHash == 0) break;
                            types[index] = INodeModel.ChangeType.DELETE;
                            lastHash = 0;
                            break;
                        }
                    }
                }
                lastType = types[index];
                ++index;
                ++n2;
            }
            this.typeStore.put(id, types);
        }
        return types;
    }

    @Override
    public void buildAll() {
        this.clear();
        IP4Revision[] iP4RevisionArray = this.revisions;
        int n = this.revisions.length;
        int n2 = 0;
        while (n2 < n) {
            IP4Revision revision = iP4RevisionArray[n2];
            this.build(revision);
            ++n2;
        }
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public void build(IP4Revision revision) {
        this.clear(revision);
        IStorageEditorInput input = this.cache.getRevisionInput(revision);
        if (input != null) {
            Object nodeInput = this.parseInput((IEditorInput)input, revision);
            if (nodeInput != null) {
                this.findNodes(nodeInput, revision);
            }
            if (input instanceof ITempFileInput) {
                this.deleteTempFile((ITempFileInput)input);
            }
        }
    }

    protected void deleteTempFile(ITempFileInput tempInput) {
        File file;
        if (tempInput.deletePostLoad() && (file = tempInput.getFile()) != null && !file.delete()) {
            String msg = MessageFormat.format(Messages.NodeModel_DeleteFileError, file.getAbsolutePath());
            PerforceProviderPlugin.logError((String)msg);
        }
    }

    @Override
    public Object getNode(String id, IP4Revision revision) {
        NodeRecord record;
        Object node = null;
        Map<String, NodeRecord> revRecords = this.records.get(revision);
        if (revRecords != null && (record = revRecords.get(id)) != null) {
            node = record.element;
        }
        return node;
    }

    protected void addRecord(int hash, String id, String id2, Object element, IP4Revision revision) {
        if (id != null) {
            NodeRecord record = new NodeRecord();
            record.hash = hash;
            record.element = element;
            Map<String, NodeRecord> revRecords = this.records.get(revision);
            if (revRecords == null) {
                revRecords = Collections.synchronizedMap(new HashMap());
                this.records.put(revision, revRecords);
            }
            revRecords.put(id, record);
            if (id2 != null) {
                revRecords.put(id2, record);
            }
        }
    }

    public Object getElement(IP4Revision revision, String id) {
        NodeRecord record;
        Object element = null;
        Map<String, NodeRecord> revRecords = this.records.get(revision);
        if (revRecords != null && (record = revRecords.get(id)) != null) {
            element = record.element;
        }
        return element;
    }

    protected int computeHash(String content, Charset charset) {
        if (this.digester != null) {
            this.digester.update(content.getBytes(charset));
            return new BigInteger(1, this.digester.digest()).intValue();
        }
        return content.hashCode();
    }

    @Override
    public boolean isChanged(String id, IP4Revision revision) {
        boolean changed = false;
        if (id != null && revision != null) {
            INodeModel.IRecord[] records;
            INodeModel.IRecord[] iRecordArray = records = this.getNodeRecords(id);
            int n = records.length;
            int n2 = 0;
            while (n2 < n) {
                INodeModel.IRecord record = iRecordArray[n2];
                if (revision == record.getRevision()) {
                    changed = record.getType() != INodeModel.ChangeType.UNCHANGED;
                    break;
                }
                ++n2;
            }
        }
        return changed;
    }

    @Override
    public abstract Object parseInput(IEditorInput var1, IP4Revision var2);

    @Override
    public abstract void findNodes(Object var1, IP4Revision var2);

    public static class NodeRecord {
        int hash;
        Object element;
        int have = -1;
        int head = -1;
    }

    public static class Record
    implements INodeModel.IRecord {
        private String id;
        private IP4Revision revision;
        private INodeModel.ChangeType type;

        public Record(String id, IP4Revision revision, INodeModel.ChangeType type) {
            this.id = id;
            this.revision = revision;
            this.type = type;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public IP4Revision getRevision() {
            return this.revision;
        }

        @Override
        public INodeModel.ChangeType getType() {
            return this.type;
        }
    }
}

