/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.text.timelapse;

import com.perforce.team.core.p4java.IP4Revision;
import com.perforce.team.ui.text.TextUtils;
import com.perforce.team.ui.text.timelapse.ITextAnnotateModel;
import com.perforce.team.ui.text.timelapse.TextRuler;
import com.perforce.team.ui.timelapse.IAnnotateModel;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public abstract class MinimalRuler
extends TextRuler
implements IAnnotateModel.IModelListener {
    protected IP4Revision revision;
    protected ITextAnnotateModel model;
    protected ITextAnnotateModel.Line[] lines;
    protected int latest = -1;

    public MinimalRuler(ITextAnnotateModel model) {
        this.model = model;
        this.model.addListener(this);
        this.loaded(this.model);
    }

    public void loaded(IAnnotateModel model) {
        this.latest = model.getRevisionId(model.getLatest());
    }

    @Override
    protected void handleDispose() {
        super.handleDispose();
        this.model.removeListener(this);
    }

    @Override
    protected int computeMaxNumber() {
        int max = 0;
        int i = 0;
        while (i < this.lines.length) {
            String text = this.getLineText(i);
            if (text != null) {
                max = Math.max(max, text.length());
            }
            ++i;
        }
        return max;
    }

    protected void generateRevisions() {
        if (this.model != null && this.revision != null) {
            this.lines = this.model.getLines(this.revision);
        }
    }

    public void setRevision(IP4Revision revision) {
        if (revision != this.revision) {
            this.revision = revision;
            this.generateRevisions();
        }
    }

    @Override
    protected void paintLines(int startLine, int endLine, int width, int y, GC gc, Display display) {
        if (this.lines == null) {
            return;
        }
        ITextViewer viewer = this.getViewer();
        StyledText text = this.getTextWidget();
        ITextAnnotateModel.Line lineModel = null;
        int line = startLine;
        while (line < endLine) {
            boolean draw = false;
            int widgetLine = TextUtils.modelLineToWidgetLine(viewer, line);
            if (widgetLine != -1) {
                int lineHeight = text.getLineHeight(text.getOffsetAtLine(widgetLine));
                this.paintBackground(line, gc, y, width, lineHeight);
                ITextAnnotateModel.Line current = null;
                if (line < this.lines.length) {
                    current = this.lines[line];
                    if (lineModel == null) {
                        draw = true;
                    } else if (current.lower != lineModel.lower || current.upper != lineModel.upper) {
                        draw = true;
                    }
                }
                if (y + lineHeight >= 0) {
                    if (draw) {
                        this.paintLine(line, y, lineHeight, gc, display);
                    }
                    lineModel = current;
                }
                y += lineHeight;
            }
            ++line;
        }
    }
}

