/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.model;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.file.FileSpecOpStatus;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.AccessException;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.BranchGraphElement;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.MappingDescriptor;
import com.perforce.team.core.mergequest.model.MappingException;
import com.perforce.team.core.p4java.IErrorHandler;
import com.perforce.team.core.p4java.IP4ClientOperation;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4ServerOperation;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4IntegrationOptions;
import com.perforce.team.core.p4java.P4IntegrationOptions2;
import com.perforce.team.core.p4java.P4Workspace;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class Mapping
extends BranchGraphElement {
    public static final String CONNECTED = "connected";
    public static final String DIRECTION = "direction";
    public static final String SOURCE_ANCHOR = "sourceAnchor";
    public static final String TARGET_ANCHOR = "targetAnchor";
    public static final String SOURCE_CHANGE_TYPE = "sourceChangeType";
    public static final String TARGET_CHANGE_TYPE = "targetChangeType";
    public static final String LATEST_SOURCE_CHANGE = "latestSourceChange";
    public static final String LATEST_TARGET_CHANGE = "latestTargetChange";
    public static final String SOURCE_CHANGE_COUNT = "sourceChangeCount";
    public static final String TARGET_CHANGE_COUNT = "targetChangeCount";
    public static final String JOINTS = "joints";
    public static final int ANCHOR_MIN = 0;
    public static final int ANCHOR_MAX = 9;
    public static final IP4SubmittedChangelist[] EMPTY_LISTS = new IP4SubmittedChangelist[0];
    protected MappingDescriptor descriptor;
    private Direction direction = Direction.BOTH;
    private String sourceId;
    private String targetId;
    private int sourceAnchor = 0;
    private int targetAnchor = 0;
    private List<Joint> joints = new ArrayList<Joint>();

    public Mapping(String id) {
        this(id, (IBranchGraph)null);
    }

    public Mapping(String id, IBranchGraph graph) {
        this(id, id, graph);
    }

    public Mapping(String id, String name, IBranchGraph graph) {
        super(id, name, graph);
        this.descriptor = new MappingDescriptor();
    }

    public void addJoint(Joint joint) {
        if (joint != null) {
            this.joints.add(joint);
            this.changeSupport.firePropertyChange(JOINTS, null, joint);
        }
    }

    public void addJoint(int index, Joint joint) {
        if (joint != null & index >= 0 && index <= this.joints.size()) {
            this.joints.add(index, joint);
            this.changeSupport.firePropertyChange(JOINTS, null, joint);
        }
    }

    public Joint removeJoint(int index) {
        Joint removed = null;
        if (index >= 0 && index < this.joints.size()) {
            removed = this.joints.remove(index);
            this.changeSupport.firePropertyChange(JOINTS, removed, null);
        }
        return removed;
    }

    public Joint setJoint(int index, Joint joint) {
        Joint removed = null;
        if (joint != null && index >= 0 && index < this.joints.size()) {
            removed = this.joints.set(index, joint);
            this.changeSupport.firePropertyChange(JOINTS, removed, joint);
        }
        return removed;
    }

    public Joint[] getJoints() {
        return this.joints.toArray(new Joint[this.joints.size()]);
    }

    public int getJointCount() {
        return this.joints.size();
    }

    private int getValidAnchor(int terminal) {
        return Math.min(9, Math.max(0, terminal));
    }

    public void setSourceAnchor(int index) {
        if ((index = this.getValidAnchor(index)) != this.sourceAnchor) {
            int previous = this.sourceAnchor;
            this.sourceAnchor = index;
            this.changeSupport.firePropertyChange(SOURCE_ANCHOR, previous, this.sourceAnchor);
        }
    }

    public int getSourceAnchor() {
        return this.sourceAnchor;
    }

    public void setTargetAnchor(int anchor) {
        if ((anchor = this.getValidAnchor(anchor)) != this.targetAnchor) {
            int previous = this.targetAnchor;
            this.targetAnchor = anchor;
            this.changeSupport.firePropertyChange(SOURCE_ANCHOR, previous, this.targetAnchor);
        }
    }

    public int getTargetAnchor() {
        return this.targetAnchor;
    }

    public boolean setSourceToTargetCount(int count) {
        int previous = this.descriptor.getTargetCount();
        boolean set = this.descriptor.setTargetCount(count);
        if (set) {
            this.changeSupport.firePropertyChange(TARGET_CHANGE_COUNT, previous, this.descriptor.getTargetCount());
        }
        return set;
    }

    public boolean setTargetToSourceCount(int count) {
        int previous = this.descriptor.getSourceCount();
        boolean set = this.descriptor.setSourceCount(count);
        if (set) {
            this.changeSupport.firePropertyChange(SOURCE_CHANGE_COUNT, previous, this.descriptor.getSourceCount());
        }
        return set;
    }

    public boolean setSourceChanges(MappingDescriptor.ChangeType type) {
        MappingDescriptor.ChangeType previous = this.descriptor.getSourceChangeType();
        boolean set = this.descriptor.setSourceChangeType(type);
        if (set) {
            this.changeSupport.firePropertyChange(SOURCE_CHANGE_TYPE, (Object)previous, (Object)this.descriptor.getSourceChangeType());
        }
        return set;
    }

    public MappingDescriptor.ChangeType getSourceChange() {
        return this.descriptor.getSourceChangeType();
    }

    public MappingDescriptor.ChangeType getTargetChange() {
        return this.descriptor.getTargetChangeType();
    }

    public boolean setTargetChanges(MappingDescriptor.ChangeType type) {
        MappingDescriptor.ChangeType previous = this.descriptor.getTargetChangeType();
        boolean set = this.descriptor.setTargetChangeType(type);
        if (set) {
            this.changeSupport.firePropertyChange(TARGET_CHANGE_TYPE, (Object)previous, (Object)this.descriptor.getTargetChangeType());
        }
        return set;
    }

    private boolean hasChanges(MappingDescriptor.ChangeType type) {
        return type == MappingDescriptor.ChangeType.NO_PERMISSION || type == MappingDescriptor.ChangeType.VISIBLE_CHANGES;
    }

    public boolean hasSourceChanges() {
        return this.hasChanges(this.descriptor.getSourceChangeType());
    }

    public boolean hasTargetChanges() {
        return this.hasChanges(this.descriptor.getTargetChangeType());
    }

    public int getSourceToTargetCount() {
        return this.descriptor.getTargetCount();
    }

    public int getTargetToSourceCount() {
        return this.descriptor.getSourceCount();
    }

    public int getLatestSource() {
        return this.descriptor.getLatestSource();
    }

    public boolean setLatestSource(int latestSource) {
        int previous = this.descriptor.getLatestSource();
        boolean set = this.descriptor.setLatestSource(latestSource);
        if (set) {
            this.changeSupport.firePropertyChange(LATEST_SOURCE_CHANGE, previous, this.descriptor.getLatestSource());
        }
        return set;
    }

    public int getLatestTarget() {
        return this.descriptor.getLatestTarget();
    }

    public boolean setLatestTarget(int latestTarget) {
        int previous = this.descriptor.getLatestTarget();
        boolean set = this.descriptor.setLatestTarget(latestTarget);
        if (set) {
            this.changeSupport.firePropertyChange(LATEST_TARGET_CHANGE, previous, this.descriptor.getLatestTarget());
        }
        return set;
    }

    private Branch getBranch(String id) {
        IBranchGraph graph = this.getGraph();
        return graph != null && id != null ? graph.getElementById(id, Branch.class) : null;
    }

    public Branch getSource() {
        return this.getBranch(this.sourceId);
    }

    public Branch getTarget() {
        return this.getBranch(this.targetId);
    }

    public abstract IP4SubmittedChangelist[] refreshTargetInterchanges(IP4Connection var1) throws MappingException;

    public abstract IP4SubmittedChangelist[] refreshSourceInterchanges(IP4Connection var1) throws MappingException;

    public abstract Object getSourceContext(IP4Connection var1, Object var2);

    public abstract Object getTargetContext(IP4Connection var1, Object var2);

    public abstract IP4SubmittedChangelist refreshLatestTargetChange(IP4Connection var1, Object var2) throws MappingException;

    public abstract IP4SubmittedChangelist refreshLatestSourceChange(IP4Connection var1, Object var2) throws MappingException;

    public abstract boolean refreshSourceStatus(IP4Connection var1, Object var2) throws MappingException;

    public abstract boolean refreshTargetStatus(IP4Connection var1, Object var2) throws MappingException;

    public abstract String getType();

    protected MappingDescriptor.ChangeType getChangeType(IFileSpec spec) {
        MappingDescriptor.ChangeType type = MappingDescriptor.ChangeType.UNKNOWN;
        if (FileSpecOpStatus.ERROR != spec.getOpStatus()) {
            type = MappingDescriptor.ChangeType.VISIBLE_CHANGES;
        } else {
            String message = spec.getStatusMessage();
            if (message != null) {
                if (message.endsWith("- no permission for operation on file(s).")) {
                    type = MappingDescriptor.ChangeType.NO_PERMISSION;
                } else if (message.endsWith("- all revision(s) already integrated.")) {
                    type = MappingDescriptor.ChangeType.NO_CHANGES;
                } else if (message.endsWith("- no such file(s).")) {
                    type = MappingDescriptor.ChangeType.NO_CHANGES;
                } else if (message.endsWith("- no target file(s) in both client and branch view.")) {
                    type = MappingDescriptor.ChangeType.NO_CHANGES;
                } else if (message.endsWith("File(s) not in client view.")) {
                    type = MappingDescriptor.ChangeType.NO_CHANGES;
                }
            }
        }
        return type;
    }

    protected boolean retryAfterLogin(IP4Connection connection, AccessException exception) {
        if (connection == null || exception == null) {
            return false;
        }
        IErrorHandler handler = connection.getErrorHandler();
        if (handler == null) {
            handler = P4Workspace.getWorkspace().getErrorHandler();
        }
        if (handler != null) {
            return handler.shouldRetry(connection, (P4JavaException)exception);
        }
        return false;
    }

    protected void runOperation(IP4Connection connection, IP4ClientOperation operation) throws MappingException {
        if (connection == null || operation == null) {
            return;
        }
        IClient client = connection.getClient();
        boolean retry = true;
        while (retry) {
            retry = false;
            if (client == null) {
                throw new MappingException("Client not set on connection");
            }
            try {
                operation.run(client);
            }
            catch (P4JavaException e) {
                if (e instanceof AccessException) {
                    retry = this.retryAfterLogin(connection, (AccessException)e);
                }
                if (retry) {
                    client = connection.getClient();
                    continue;
                }
                throw new MappingException(e);
            }
            catch (P4JavaError e) {
                throw new MappingException(e);
            }
        }
    }

    protected void runOperation(IP4Connection connection, IP4ServerOperation operation) throws MappingException {
        if (connection == null || operation == null) {
            return;
        }
        IServer server = connection.getServer();
        boolean retry = true;
        while (retry) {
            retry = false;
            if (server == null) {
                throw new MappingException("Server not set on connection");
            }
            try {
                operation.run(server);
            }
            catch (P4JavaException e) {
                if (e instanceof AccessException) {
                    retry = this.retryAfterLogin(connection, (AccessException)e);
                }
                if (retry) {
                    server = connection.getServer();
                    continue;
                }
                throw new MappingException(e);
            }
            catch (P4JavaError e) {
                throw new MappingException(e);
            }
        }
    }

    public boolean disconnect() {
        Branch target;
        boolean removed = false;
        Branch source = this.getSource();
        if (source != null) {
            removed = source.remove(this);
        }
        if ((target = this.getTarget()) != null) {
            boolean bl = removed = target.remove(this) || removed;
        }
        if (removed) {
            this.changeSupport.firePropertyChange(CONNECTED, true, false);
        }
        return removed;
    }

    public boolean connect(Branch source, Branch target) {
        boolean added = false;
        if (source != null && target != null && !source.equals(target)) {
            this.disconnect();
            this.setSourceId(source.getId());
            this.setTargetId(target.getId());
            added = this.connect();
        }
        return added;
    }

    public boolean connect() {
        Branch target;
        boolean added = false;
        Branch source = this.getSource();
        if (source != null) {
            added = source.add(this);
        }
        if ((target = this.getTarget()) != null) {
            boolean bl = added = target.add(this) || added;
        }
        if (added) {
            this.changeSupport.firePropertyChange(CONNECTED, false, true);
        }
        return added;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public boolean setDirection(Direction direction) {
        boolean set = false;
        if (direction != null && this.direction != direction) {
            Direction previous = this.direction;
            this.direction = direction;
            set = true;
            this.changeSupport.firePropertyChange(DIRECTION, (Object)previous, (Object)this.direction);
        }
        return set;
    }

    public Direction getDirection() {
        return this.direction;
    }

    protected P4IntegrationOptions createIntegrationOptions() {
        IServer server = this.getGraph().getConnection().getServer();
        P4IntegrationOptions options = P4IntegrationOptions.createInstance((IServer)server);
        if (options instanceof P4IntegrationOptions2) {
            ((P4IntegrationOptions2)options).setBaselessMerge(true);
        }
        options.setMaxFiles(1);
        options.setIntegrateAroundDeleted(true);
        return options;
    }

    public static enum Direction {
        SOURCE,
        TARGET,
        BOTH;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static class Joint {
        int x1;
        int y1;
        int x2;
        int y2;

        public Joint(int x1, int y1, int x2, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public String toString() {
            return String.valueOf(this.x1) + ", " + this.y1 + ", " + this.x2 + ", " + this.y2;
        }

        public int getX1() {
            return this.x1;
        }

        public int getY1() {
            return this.y1;
        }

        public int getX2() {
            return this.x2;
        }

        public int getY2() {
            return this.y2;
        }

        public int hashCode() {
            return (this.x1 + this.x2 + 1) * (this.y1 + this.y2 + 1) ^ this.x1 ^ this.y1;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Joint) {
                Joint other = (Joint)obj;
                return this.x1 == other.x1 && this.x2 == other.x2 && this.y1 == other.y1 && this.y2 == other.y2;
            }
            return false;
        }
    }
}

