/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.model;

import com.perforce.p4java.client.IClient;
import com.perforce.p4java.core.IChangelist;
import com.perforce.p4java.core.IChangelistSummary;
import com.perforce.p4java.core.file.IFileSpec;
import com.perforce.p4java.exception.P4JavaError;
import com.perforce.p4java.exception.P4JavaException;
import com.perforce.p4java.impl.generic.core.Changelist;
import com.perforce.p4java.impl.generic.core.file.FileSpec;
import com.perforce.p4java.server.IServer;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.mergequest.model.MappingDescriptor;
import com.perforce.team.core.mergequest.model.MappingException;
import com.perforce.team.core.p4java.IP4ClientOperation;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4ServerOperation;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4ClientOperation;
import com.perforce.team.core.p4java.P4IntegrationOptions;
import com.perforce.team.core.p4java.P4ServerOperation;
import com.perforce.team.core.p4java.P4SubmittedChangelist;
import com.perforce.team.core.p4java.builder.P4FileSpecBuilder;
import java.util.ArrayList;
import java.util.List;

public class DepotPathMapping
extends Mapping {
    public static final String TYPE = "depotPath";
    public static final String SOURCE_PATH = "sourcePath";
    public static final String TARGET_PATH = "targetPath";
    private String sourcePath = "";
    private String targetPath = "";

    public DepotPathMapping(String id) {
        this(id, (IBranchGraph)null);
    }

    public DepotPathMapping(String id, IBranchGraph graph) {
        super(id, graph);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DepotPathMapping && super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getTargetPath() {
        return this.targetPath;
    }

    public boolean setSourcePath(String sourcePath) {
        boolean set = false;
        if (sourcePath != null && !this.sourcePath.equals(sourcePath)) {
            String previous = this.sourcePath;
            this.sourcePath = sourcePath;
            this.changeSupport.firePropertyChange(SOURCE_PATH, previous, sourcePath);
            set = true;
        }
        return set;
    }

    public boolean setTargetPath(String targetPath) {
        boolean set = false;
        if (targetPath != null && !this.targetPath.equals(targetPath)) {
            String previous = this.targetPath;
            this.targetPath = targetPath;
            this.changeSupport.firePropertyChange(TARGET_PATH, previous, targetPath);
            set = true;
        }
        return set;
    }

    private IP4SubmittedChangelist[] getInterchanges(final IP4Connection connection, final String source, final String target) throws MappingException {
        final List[] submittedLists = new List[1];
        P4ServerOperation operation = new P4ServerOperation(){

            public void run(IServer server) throws P4JavaException, P4JavaError {
                FileSpec sourceSpec = new FileSpec(source);
                FileSpec targetSpec = new FileSpec(target);
                List interchanges = server.getInterchanges((IFileSpec)sourceSpec, (IFileSpec)targetSpec, false, true, -1);
                ArrayList<P4SubmittedChangelist> submitted = new ArrayList<P4SubmittedChangelist>(interchanges.size());
                for (IChangelist list : interchanges) {
                    submitted.add(new P4SubmittedChangelist(connection, list));
                }
                submittedLists[0] = submitted;
            }
        };
        this.runOperation(connection, (IP4ServerOperation)operation);
        if (submittedLists[0] != null) {
            return submittedLists[0].toArray(new IP4SubmittedChangelist[submittedLists[0].size()]);
        }
        return null;
    }

    @Override
    public IP4SubmittedChangelist[] refreshSourceInterchanges(IP4Connection connection) throws MappingException {
        IP4SubmittedChangelist[] lists = null;
        if (Mapping.Direction.TARGET != this.getDirection() && connection != null && (lists = this.getInterchanges(connection, this.targetPath, this.sourcePath)) != null) {
            this.setTargetToSourceCount(lists.length);
        }
        if (lists == null) {
            lists = EMPTY_LISTS;
        }
        return lists;
    }

    @Override
    public IP4SubmittedChangelist[] refreshTargetInterchanges(IP4Connection connection) throws MappingException {
        IP4SubmittedChangelist[] lists = null;
        if (Mapping.Direction.SOURCE != this.getDirection() && connection != null && (lists = this.getInterchanges(connection, this.sourcePath, this.targetPath)) != null) {
            this.setSourceToTargetCount(lists.length);
        }
        if (lists == null) {
            lists = EMPTY_LISTS;
        }
        return lists;
    }

    private IP4SubmittedChangelist getLatestChangelist(final IP4Connection connection, final String path) throws MappingException {
        final IP4SubmittedChangelist[] list = new IP4SubmittedChangelist[1];
        P4ServerOperation operation = new P4ServerOperation(){

            public void run(IServer server) throws P4JavaException, P4JavaError {
                List lists = server.getChangelists(1, P4FileSpecBuilder.makeFileSpecList((String)path), null, null, false, IChangelist.Type.SUBMITTED, false);
                if (lists.size() > 0) {
                    list[0] = new P4SubmittedChangelist(connection, (IChangelist)new Changelist((IChangelistSummary)lists.get(0), server, false));
                }
            }
        };
        this.runOperation(connection, (IP4ServerOperation)operation);
        return list[0];
    }

    @Override
    public IP4SubmittedChangelist refreshLatestSourceChange(IP4Connection connection, Object context) throws MappingException {
        IP4SubmittedChangelist latest = null;
        if (context instanceof String) {
            latest = this.getLatestChangelist(connection, (String)context);
        }
        if (latest != null) {
            this.setLatestSource(latest.getId());
        }
        return latest;
    }

    @Override
    public IP4SubmittedChangelist refreshLatestTargetChange(IP4Connection connection, Object context) throws MappingException {
        IP4SubmittedChangelist latest = null;
        if (context instanceof String) {
            latest = this.getLatestChangelist(connection, (String)context);
        }
        if (latest != null) {
            this.setLatestTarget(latest.getId());
        }
        return latest;
    }

    @Override
    public Object getSourceContext(IP4Connection connection, Object context) {
        return this.getSourcePath();
    }

    @Override
    public Object getTargetContext(IP4Connection connection, Object context) {
        return this.getTargetPath();
    }

    private MappingDescriptor.ChangeType changesExist(IP4Connection connection, final String path1, final String path2) throws MappingException {
        final MappingDescriptor.ChangeType[] type = new MappingDescriptor.ChangeType[]{MappingDescriptor.ChangeType.UNKNOWN};
        P4ClientOperation operation = new P4ClientOperation(){

            public void run(IClient client) throws P4JavaException, P4JavaError {
                P4IntegrationOptions options = DepotPathMapping.this.createIntegrationOptions();
                List files = client.integrateFiles((IFileSpec)new FileSpec(path1), (IFileSpec)new FileSpec(path2), null, options.createIntegrateFilesOptions(-1, true));
                if (files.size() > 0) {
                    type[0] = DepotPathMapping.this.getChangeType((IFileSpec)files.get(0));
                }
            }
        };
        this.runOperation(connection, (IP4ClientOperation)operation);
        return type[0];
    }

    @Override
    public boolean refreshSourceStatus(IP4Connection connection, Object context) throws MappingException {
        MappingDescriptor.ChangeType changes = this.getSourceChange();
        if (Mapping.Direction.TARGET != this.getDirection()) {
            changes = this.changesExist(connection, this.getTargetPath(), this.getSourcePath());
            this.setSourceChanges(changes);
        }
        return changes == MappingDescriptor.ChangeType.VISIBLE_CHANGES;
    }

    @Override
    public boolean refreshTargetStatus(IP4Connection connection, Object context) throws MappingException {
        MappingDescriptor.ChangeType changes = this.getTargetChange();
        if (Mapping.Direction.SOURCE != this.getDirection()) {
            changes = this.changesExist(connection, this.getSourcePath(), this.getTargetPath());
            this.setTargetChanges(changes);
        }
        return changes == MappingDescriptor.ChangeType.VISIBLE_CHANGES;
    }
}

