/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.builder.xml;

import com.perforce.team.core.mergequest.builder.xml.ElementBuilder;
import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.mergequest.model.MappingDescriptor;
import java.util.Locale;
import org.w3c.dom.Element;

public abstract class MappingBuilder
extends ElementBuilder {
    public static final String TARGET_CHANGES_ATTRIBUTE = "targetChanges";
    public static final String SOURCE_CHANGES_ATTRIBUTE = "sourceChanges";
    public static final String TARGET_COUNT_ATTRIBUTE = "targetCount";
    public static final String SOURCE_COUNT_ATTRIBUTE = "sourceCount";
    public static final String LATEST_TARGET_ATTRIBUTE = "latestTarget";
    public static final String LATEST_SOURCE_ATTRIBUTE = "latestSource";
    public static final String DIRECTION_ATTRIBUTE = "direction";
    public static final String SOURCE_ATTRIBUTE = "source";
    public static final String TARGET_ATTRIBUTE = "target";
    public static final String SOURCE_ANCHOR_ATTRIBUTE = "sourceAnchor";
    public static final String TARGET_ANCHOR_ATTRIBUTE = "targetAnchor";
    public static final String JOINTS_ATTRIBUTE = "joints";

    protected MappingDescriptor.ChangeType getType(String type) {
        MappingDescriptor.ChangeType change = null;
        if (type != null) {
            try {
                change = MappingDescriptor.ChangeType.valueOf(type.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                change = null;
            }
        }
        return change;
    }

    protected Mapping.Direction getDirection(String value) {
        Mapping.Direction direction = null;
        if (value != null) {
            try {
                direction = Mapping.Direction.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException ile) {
                direction = null;
            }
        }
        return direction;
    }

    protected void saveMappingFields(Element element, Mapping mapping) {
        Branch target;
        element.setAttribute("id", mapping.getId());
        element.setAttribute(DIRECTION_ATTRIBUTE, mapping.getDirection().toString());
        Branch source = mapping.getSource();
        if (source != null) {
            element.setAttribute(SOURCE_ATTRIBUTE, source.getId());
        }
        if ((target = mapping.getTarget()) != null) {
            element.setAttribute(TARGET_ATTRIBUTE, target.getId());
        }
        element.setAttribute("name", mapping.getName());
        element.setAttribute(TARGET_COUNT_ATTRIBUTE, Integer.toString(mapping.getSourceToTargetCount()));
        element.setAttribute(SOURCE_COUNT_ATTRIBUTE, Integer.toString(mapping.getTargetToSourceCount()));
        element.setAttribute(SOURCE_CHANGES_ATTRIBUTE, mapping.getSourceChange().toString());
        element.setAttribute(TARGET_CHANGES_ATTRIBUTE, mapping.getTargetChange().toString());
        element.setAttribute(LATEST_SOURCE_ATTRIBUTE, Integer.toString(mapping.getLatestSource()));
        element.setAttribute(LATEST_TARGET_ATTRIBUTE, Integer.toString(mapping.getLatestTarget()));
        element.setAttribute(SOURCE_ANCHOR_ATTRIBUTE, Integer.toString(mapping.getSourceAnchor()));
        element.setAttribute(TARGET_ANCHOR_ATTRIBUTE, Integer.toString(mapping.getTargetAnchor()));
        StringBuilder joints = new StringBuilder();
        Mapping.Joint[] jointArray = mapping.getJoints();
        int n = jointArray.length;
        int n2 = 0;
        while (n2 < n) {
            Mapping.Joint joint = jointArray[n2];
            joints.append(joint.toString()).append(';');
            ++n2;
        }
        element.setAttribute(JOINTS_ATTRIBUTE, joints.toString());
    }

    @Override
    public void complete(IBranchGraphElement element, IBranchGraph graph) {
        if (element instanceof Mapping) {
            Mapping mapping = (Mapping)element;
            boolean connected = false;
            Branch source = mapping.getSource();
            Branch target = mapping.getTarget();
            if (source != null && target != null) {
                mapping.connect();
                connected = true;
            }
            if (!connected) {
                graph.remove(mapping);
            }
        }
    }

    private int getInteger(String value) throws NumberFormatException {
        if (value == null) {
            throw new NumberFormatException();
        }
        if ((value = value.trim()).length() == 0) {
            throw new NumberFormatException();
        }
        return Integer.parseInt(value);
    }

    protected void loadMappingFields(Element element, Mapping mapping) {
        String name = element.getAttribute("name");
        mapping.setName(name);
        mapping.setDirection(this.getDirection(element.getAttribute(DIRECTION_ATTRIBUTE)));
        mapping.setTargetChanges(this.getType(element.getAttribute(TARGET_CHANGES_ATTRIBUTE)));
        mapping.setSourceChanges(this.getType(element.getAttribute(SOURCE_CHANGES_ATTRIBUTE)));
        mapping.setSourceToTargetCount(this.getInteger(element, TARGET_COUNT_ATTRIBUTE));
        mapping.setTargetToSourceCount(this.getInteger(element, SOURCE_COUNT_ATTRIBUTE));
        mapping.setLatestSource(this.getInteger(element, LATEST_SOURCE_ATTRIBUTE));
        mapping.setLatestTarget(this.getInteger(element, LATEST_TARGET_ATTRIBUTE));
        mapping.setSourceId(element.getAttribute(SOURCE_ATTRIBUTE));
        mapping.setTargetId(element.getAttribute(TARGET_ATTRIBUTE));
        mapping.setSourceAnchor(this.getInteger(element, SOURCE_ANCHOR_ATTRIBUTE));
        mapping.setTargetAnchor(this.getInteger(element, TARGET_ANCHOR_ATTRIBUTE));
        String joints = element.getAttribute(JOINTS_ATTRIBUTE);
        if (joints.length() > 0) {
            String[] segments;
            String[] stringArray = segments = joints.split(";");
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                String[] joint = segment.split(",");
                if (joint.length == 4) {
                    try {
                        int x1 = this.getInteger(joint[0]);
                        int y1 = this.getInteger(joint[1]);
                        int x2 = this.getInteger(joint[2]);
                        int y2 = this.getInteger(joint[3]);
                        mapping.addJoint(new Mapping.Joint(x1, y1, x2, y2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
    }
}

