/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.core.mergequest.builder.xml;

import com.perforce.team.core.PerforceProviderPlugin;
import com.perforce.team.core.mergequest.builder.xml.IElementBuilder;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class BuilderRegistry {
    public static final String TAG_NAME_ATTRIBUTE = "tagName";
    public static final String ELEMENT_CLASS_ATTRIBUTE = "elementClass";
    public static final String CLASS_ATTRIBUTE = "class";
    private Map<String, IElementBuilder> classBuilders = new HashMap<String, IElementBuilder>();
    private Map<String, IElementBuilder> nameBuilders = new HashMap<String, IElementBuilder>();

    public BuilderRegistry(String extensionPoint) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPoint);
        this.generateBuilders(elements);
    }

    public String[] getTagNames() {
        return this.nameBuilders.keySet().toArray(new String[this.nameBuilders.size()]);
    }

    private void generateBuilders(IConfigurationElement[] elements) {
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String elementName = element.getAttribute(TAG_NAME_ATTRIBUTE);
            String elementClass = element.getAttribute(ELEMENT_CLASS_ATTRIBUTE);
            String builder = element.getAttribute(CLASS_ATTRIBUTE);
            if ((elementName != null || elementClass != null) && builder != null) {
                try {
                    Object createdBuilder = element.createExecutableExtension(CLASS_ATTRIBUTE);
                    if (createdBuilder instanceof IElementBuilder) {
                        if (elementClass != null) {
                            this.classBuilders.put(elementClass, (IElementBuilder)createdBuilder);
                        }
                        if (elementName != null) {
                            this.nameBuilders.put(elementName, (IElementBuilder)createdBuilder);
                        }
                    }
                }
                catch (CoreException ce) {
                    PerforceProviderPlugin.logError((Throwable)ce);
                }
            }
            ++n2;
        }
    }

    public IElementBuilder getBuilder(String tagName) {
        return tagName != null ? this.nameBuilders.get(tagName) : null;
    }

    public IElementBuilder getBuilder(IBranchGraphElement element) {
        return element != null ? this.classBuilders.get(element.getClass().getName()) : null;
    }
}

