/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.branch;

import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.registry.BranchType;
import com.perforce.team.ui.mergequest.P4BranchGraphPlugin;
import com.perforce.team.ui.mergequest.wizards.branch.BranchDescriptor;
import com.perforce.team.ui.mergequest.wizards.branch.BranchWizardPage;
import com.perforce.team.ui.mergequest.wizards.branch.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewBranchWizard
extends Wizard
implements INewWizard {
    private IBranchGraph graph;
    private BranchDescriptor createdBranch = new BranchDescriptor();
    private BranchDescriptor initialBranch = new BranchDescriptor();
    private BranchWizardPage branchPage;

    public NewBranchWizard(IBranchGraph graph, BranchDescriptor descriptor) {
        this.graph = graph;
        if (descriptor == null) {
            descriptor = new BranchDescriptor();
        }
        this.initialBranch = descriptor;
    }

    public NewBranchWizard(IBranchGraph graph) {
        this(graph, null);
    }

    public void addPages() {
        this.branchPage = new BranchWizardPage("branchPage", this.graph, this.initialBranch);
        this.addPage((IWizardPage)this.branchPage);
        this.branchPage.setTitle(Messages.BranchWizardPage_NewBranch);
        this.branchPage.setMessage(Messages.BranchWizardPage_AddNewBranch);
        this.branchPage.setImageDescriptor(P4BranchGraphPlugin.getImageDescriptor("icons/wizard/branchWizard.png"));
    }

    public void setInitialName(String name) {
        this.initialBranch.setName(name);
    }

    public void setInitialType(BranchType type) {
        this.initialBranch.setType(type);
    }

    public boolean performFinish() {
        this.createdBranch = this.branchPage.getCreatedBranch();
        return true;
    }

    public String getBranchName() {
        return this.createdBranch.getName();
    }

    public BranchType getBranchType() {
        return this.createdBranch.getType();
    }

    public IAction[] getPostFinishActions() {
        return new IAction[0];
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

