/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.branch;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.ui.IErrorDisplay;
import com.perforce.team.ui.IErrorProvider;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import com.perforce.team.ui.mergequest.wizards.branch.BranchDescriptor;
import com.perforce.team.ui.mergequest.wizards.branch.BranchNameArea;
import com.perforce.team.ui.mergequest.wizards.branch.Messages;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BranchWizardPage
extends WizardPage
implements IErrorDisplay,
IErrorProvider {
    private IBranchGraph graph;
    private SharedResources resources;
    private BranchDescriptor initial;
    private BranchDescriptor descriptor;
    private BranchNameArea nameArea;
    protected Set<String> names = new HashSet<String>();

    public BranchWizardPage(String pageName, IBranchGraph graph, BranchDescriptor initial) {
        super(pageName);
        this.initial = initial;
        this.graph = graph;
        Branch[] branchArray = graph.getBranches();
        int n = branchArray.length;
        int n2 = 0;
        while (n2 < n) {
            Branch branch = branchArray[n2];
            this.names.add(branch.getName());
            ++n2;
        }
        this.names.remove(this.initial.getName());
    }

    public void setErrorMessage(String message, IErrorProvider provider) {
        this.setPageComplete(message == null);
        this.setErrorMessage(message);
    }

    public void validate() {
        String message = null;
        String name = this.descriptor.getName();
        if (message == null && name.length() == 0) {
            message = Messages.BranchWizardPage_EnterBranchName;
        }
        if (message == null && this.names.contains(name)) {
            message = MessageFormat.format(Messages.BranchWizardPage_BranchExists, name);
        }
        this.setErrorMessage(message, null);
    }

    protected BranchNameArea createNameArea(Composite parent, SharedResources resources, IBranchGraph graph, IErrorProvider provider) {
        BranchNameArea area = new BranchNameArea(resources, graph, provider);
        this.descriptor = area.createControl(parent, Messages.BranchWizardPage_Name, this.initial);
        return area;
    }

    public void createControl(Composite parent) {
        this.resources = new SharedResources();
        Composite displayArea = new Composite(parent, 0);
        displayArea.setLayout((Layout)GridLayoutFactory.swtDefaults().equalWidth(false).create());
        displayArea.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).grab(true, true).create());
        this.nameArea = this.createNameArea(displayArea, this.resources, this.graph, this);
        this.nameArea.setFocus();
        this.setControl((Control)displayArea);
        this.setPageComplete(false);
    }

    public BranchDescriptor getCreatedBranch() {
        return this.descriptor;
    }

    public void setErrorDisplay(IErrorDisplay display) {
    }
}

