/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.wizards.branch;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.ui.editor.BaseContentAssistProcessor;
import com.perforce.team.ui.editor.BaseContentAssistant;
import com.perforce.team.ui.editor.IProposal;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import com.perforce.team.ui.mergequest.wizards.branch.BranchCompletionProposal;
import com.perforce.team.ui.mergequest.wizards.branch.BranchProposal;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.swt.graphics.Point;

public class BranchAssistant
extends BaseContentAssistant {
    private Set<IProposal> branchProposals = new TreeSet<IProposal>();
    private SharedResources resources;

    public BranchAssistant(SharedResources resources) {
        this.resources = resources;
    }

    public void loadProposals(IBranchGraph graph) {
        if (graph != null) {
            Branch[] branchArray = graph.getBranches();
            int n = branchArray.length;
            int n2 = 0;
            while (n2 < n) {
                Branch branch = branchArray[n2];
                this.branchProposals.add((IProposal)new BranchProposal(branch, this.resources));
                this.activatorSet.add(Character.valueOf(branch.getName().charAt(0)));
                ++n2;
            }
        }
        this.updateCharArray();
    }

    protected ICompletionProposal createProposal(IProposal proposal, int replaceOffset, int replaceLength, int cursorOffset) {
        return new BranchCompletionProposal(((BranchProposal)proposal).getBranch(), replaceOffset, replaceLength, cursorOffset, proposal.getImage());
    }

    public void init() {
        super.init();
        this.enablePrefixCompletion(false);
        this.setShowEmptyList(true);
        this.enableColoredLabels(true);
    }

    protected IContentAssistProcessor createProcessor() {
        return new BaseContentAssistProcessor(){

            public char[] getCompletionProposalAutoActivationCharacters() {
                return BranchAssistant.this.activators;
            }

            public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
                String prefix = this.getPrefix(viewer.getDocument(), offset);
                TreeSet proposals = new TreeSet(BranchAssistant.this.comparator);
                Point selection = viewer.getSelectedRange();
                int selectOffset = selection.x;
                int selectLength = selection.y;
                BranchAssistant.this.createProposals(prefix, BranchAssistant.this.branchProposals, proposals, offset, selectOffset, selectLength);
                return proposals.toArray(new ICompletionProposal[proposals.size()]);
            }
        };
    }
}

