/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.views.tasks;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraph;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.p4java.IP4ConnectionProvider;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Runnable;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.P4Runnable;
import com.perforce.team.core.p4java.P4Runner;
import com.perforce.team.ui.DecorationLabel;
import com.perforce.team.ui.P4FormUIUtils;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceContentProvider;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.Messages;
import com.perforce.team.ui.mergequest.actions.MappingIntegrateAction;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import com.perforce.team.ui.mergequest.views.tasks.DateTaskGroup;
import com.perforce.team.ui.mergequest.views.tasks.IIntegrateTaskContainer;
import com.perforce.team.ui.mergequest.views.tasks.IntegrateTaskLabelProvider;
import com.perforce.team.ui.mergequest.views.tasks.IntegrateTaskSorter;
import com.perforce.team.ui.mergequest.views.tasks.JobTaskGroup;
import com.perforce.team.ui.mergequest.views.tasks.UserTaskGroup;
import com.perforce.team.ui.submitted.SubmittedFileContentProvider;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class TaskContainer
implements IIntegrateTaskContainer,
PropertyChangeListener {
    private IP4SubmittedChangelist[] lists;
    private List<DateTaskGroup> dateAdapters = new ArrayList<DateTaskGroup>();
    private Map<String, UserTaskGroup> userAdapters = new HashMap<String, UserTaskGroup>();
    private Map<String, JobTaskGroup> taskAdapters = new HashMap<String, JobTaskGroup>();
    private Section sourceSection;
    private IIntegrateTaskContainer.Mode sourceMode = IIntegrateTaskContainer.Mode.FLAT;
    private Composite sourceSide;
    private CLabel sourceLabel;
    private Label arrowLabel;
    private CLabel targetLabel;
    private DecorationLabel sourceListLabel;
    private ToolBar toolbar;
    private TreeViewer sourceViewer;
    private WorkbenchLabelProvider labelProvider;
    private IP4ConnectionProvider provider = null;
    private Mapping mapping = null;
    private IBranchGraph graph = null;
    private SharedResources resources = new SharedResources();
    private boolean reverse = false;

    public TaskContainer(IP4ConnectionProvider provider) {
        this.provider = provider;
    }

    public TaskContainer(IP4ConnectionProvider provider, boolean reverse) {
        this(provider);
        this.reverse = reverse;
    }

    public void createControl(FormToolkit toolkit, Composite parent) {
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TaskContainer.this.resources.dispose();
                TaskContainer.this.unhookGraphListener();
            }
        });
        this.labelProvider = new WorkbenchLabelProvider();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (TaskContainer.this.labelProvider != null) {
                    TaskContainer.this.labelProvider.dispose();
                }
            }
        });
        this.sourceSection = toolkit.createSection(parent, 8448);
        GridData ssData = new GridData(4, 4, true, true);
        this.sourceSection.setLayoutData((Object)ssData);
        Composite sourceHeader = P4FormUIUtils.createSectionTextClient((FormToolkit)toolkit, (Section)this.sourceSection, (int)5);
        this.sourceSide = toolkit.createComposite((Composite)this.sourceSection);
        this.sourceSection.setClient((Control)this.sourceSide);
        GridLayout ssLayout = new GridLayout(1, false);
        ssLayout.marginHeight = 0;
        ssLayout.marginWidth = 0;
        ssLayout.verticalSpacing = 0;
        this.sourceSide.setLayout((Layout)ssLayout);
        this.sourceSide.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sourceLabel = new CLabel(sourceHeader, 0);
        this.sourceLabel.setText("");
        this.sourceLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.sourceLabel.setFont(this.sourceSection.getFont());
        this.sourceLabel.setForeground(this.sourceSection.getTitleBarForeground());
        this.arrowLabel = new Label(sourceHeader, 16384);
        this.arrowLabel.setImage(this.resources.getImage("icons/arrow_right.png"));
        this.arrowLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.arrowLabel.setVisible(false);
        this.targetLabel = new CLabel(sourceHeader, 0);
        this.targetLabel.setText("");
        this.targetLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.targetLabel.setFont(this.sourceSection.getFont());
        this.targetLabel.setForeground(this.sourceSection.getTitleBarForeground());
        this.sourceListLabel = new DecorationLabel(sourceHeader, "(", ")");
        this.sourceListLabel.setForeground(this.sourceSection.getTitleBarForeground());
        this.sourceListLabel.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.toolbar = new ToolBar(sourceHeader, 0x800000);
        this.toolbar.setVisible(false);
        ToolItem integrate = new ToolItem(this.toolbar, 8);
        integrate.setToolTipText(Messages.TaskContainer_IntegrateMapping);
        integrate.setImage(this.resources.getImage(PerforceUIPlugin.getDescriptor((String)"normal/integrate.png")));
        integrate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingIntegrateAction integ = new MappingIntegrateAction(TaskContainer.this.mapping, TaskContainer.this.reverse);
                integ.run();
            }
        });
        ToolItem collapse = new ToolItem(this.toolbar, 8);
        collapse.setImage(this.resources.getImage(PerforceUIPlugin.getDescriptor((String)"normal/collapseall.png")));
        collapse.setToolTipText(Messages.TaskContainer_CollapseAll);
        collapse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskContainer.this.sourceViewer.collapseAll();
            }
        });
        this.sourceViewer = this.createListViewer(this.sourceSide, 1);
        IntegrateTaskLabelProvider provider = new IntegrateTaskLabelProvider(this);
        this.sourceViewer.setSorter((ViewerSorter)new IntegrateTaskSorter(provider.getLabelProvider()));
    }

    public void setMode(IIntegrateTaskContainer.Mode mode) {
        if (mode != null) {
            this.sourceMode = mode;
            this.setInput();
        }
    }

    private TreeViewer createListViewer(Composite parent, int hSpan) {
        TreeViewer viewer = new TreeViewer(parent, 2820);
        GridData vData = new GridData(4, 4, true, true);
        vData.widthHint = 300;
        vData.heightHint = 80;
        vData.horizontalSpan = hSpan;
        viewer.getTree().setLayoutData((Object)vData);
        viewer.setContentProvider((IContentProvider)new SubmittedFileContentProvider((StructuredViewer)viewer, true));
        return viewer;
    }

    public void show(boolean show) {
        ((GridData)this.sourceSection.getLayoutData()).exclude = !show;
        this.sourceSection.setVisible(show);
    }

    private void setInput() {
        if (this.lists == null) {
            this.lists = new IP4SubmittedChangelist[0];
        }
        switch (this.sourceMode) {
            case FLAT: {
                this.sourceViewer.setInput((Object)this.lists);
                break;
            }
            case USER: {
                this.setExpandedInput(this.userAdapters.values().toArray());
                break;
            }
            case DATE: {
                this.setExpandedInput(this.dateAdapters.toArray());
                break;
            }
            case TASK: {
                if (this.taskAdapters.isEmpty() && this.lists.length > 0) {
                    this.loadTasks();
                    break;
                }
                this.setExpandedInput(this.taskAdapters.values().toArray());
            }
        }
    }

    private void setExpandedInput(Object[] input) {
        this.sourceViewer.setInput((Object)input);
    }

    private void loadTasks() {
        this.showLoading();
        final IP4SubmittedChangelist[] taskLists = this.lists;
        P4Runner.schedule((IP4Runnable)new P4Runnable(){
            private Map<String, JobTaskGroup> taskAdapters = new HashMap<String, JobTaskGroup>();

            public String getTitle() {
                return Messages.TaskContainer_LoadingFixes;
            }

            private void addList(String fix, IP4SubmittedChangelist list) {
                JobTaskGroup adapter;
                String id = fix;
                if (id == null) {
                    id = JobTaskGroup.NO_TASKS_ATTACHED;
                }
                if ((adapter = this.taskAdapters.get(fix)) == null) {
                    IP4Job job = null;
                    if (fix != null) {
                        job = list.getConnection().getJob(id);
                    }
                    adapter = new JobTaskGroup(job);
                    this.taskAdapters.put(fix, adapter);
                }
                adapter.add(list);
            }

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(this.getTitle(), taskLists.length);
                IP4SubmittedChangelist[] iP4SubmittedChangelistArray = taskLists;
                int n = taskLists.length;
                int n2 = 0;
                while (n2 < n) {
                    IP4SubmittedChangelist list = iP4SubmittedChangelistArray[n2];
                    monitor.subTask(MessageFormat.format(Messages.TaskContainer_Changelist, Integer.toString(list.getId())));
                    String[] fixes = list.getJobIds();
                    if (fixes.length == 0) {
                        this.addList(null, list);
                    } else {
                        String[] stringArray = fixes;
                        int n3 = fixes.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String fix = stringArray[n4];
                            this.addList(fix, list);
                            ++n4;
                        }
                    }
                    monitor.worked(1);
                    if (monitor.isCanceled()) break;
                    ++n2;
                }
                monitor.done();
                PerforceUIPlugin.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (P4UIUtils.okToUse((Viewer)TaskContainer.this.sourceViewer) && Arrays.equals(taskLists, TaskContainer.this.lists)) {
                            TaskContainer.this.taskAdapters = taskAdapters;
                            if (IIntegrateTaskContainer.Mode.TASK == TaskContainer.this.sourceMode) {
                                TaskContainer.this.setInput();
                            }
                        }
                    }
                });
            }
        });
    }

    private void updateHeader(Mapping newMapping, IP4SubmittedChangelist[] lists) {
        Branch source = null;
        Branch target = null;
        if (newMapping != null) {
            source = this.reverse ? newMapping.getTarget() : newMapping.getSource();
            Branch branch = target = this.reverse ? newMapping.getSource() : newMapping.getTarget();
        }
        if (newMapping != null && source != null && target != null) {
            this.toolbar.setVisible(true);
            this.arrowLabel.setVisible(true);
            this.sourceLabel.setImage(this.labelProvider.getImage((Object)source));
            this.sourceLabel.setText(source.getName());
            this.targetLabel.setImage(this.labelProvider.getImage((Object)target));
            this.targetLabel.setText(target.getName());
            String message = Messages.IntegrateTaskViewer_ChangelistCount;
            if (lists.length == 1) {
                message = Messages.IntegrateTaskViewer_OneChangelist;
            }
            this.sourceListLabel.setText(MessageFormat.format(message, lists.length));
        } else {
            this.toolbar.setVisible(false);
            ((GridData)this.sourceSection.getLayoutData()).exclude = false;
            this.arrowLabel.setVisible(false);
            this.sourceSection.setVisible(true);
            this.sourceLabel.setImage(null);
            this.sourceLabel.setText("");
            this.targetLabel.setText("");
            this.targetLabel.setImage(null);
            this.sourceListLabel.setText(null);
        }
    }

    private void updateGroups(Mapping mapping, IP4SubmittedChangelist[] lists) {
        this.userAdapters.clear();
        this.dateAdapters.clear();
        this.taskAdapters.clear();
        if (mapping != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            Date thisMonth = calendar.getTime();
            calendar = new GregorianCalendar();
            calendar.set(6, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            Date thisYear = calendar.getTime();
            DateTaskGroup month = new DateTaskGroup(Messages.TaskContainer_ThisMonth, thisMonth);
            DateTaskGroup year = new DateTaskGroup(Messages.TaskContainer_ThisYear, thisYear);
            DateTaskGroup earlier = new DateTaskGroup(MessageFormat.format(Messages.TaskContainer_EarlierThan, Integer.toString(calendar.get(1))), new Date(thisYear.getTime() - 1L));
            this.dateAdapters.add(month);
            this.dateAdapters.add(year);
            this.dateAdapters.add(earlier);
            IP4SubmittedChangelist[] iP4SubmittedChangelistArray = lists;
            int n = lists.length;
            int n2 = 0;
            while (n2 < n) {
                Date date;
                IP4SubmittedChangelist list = iP4SubmittedChangelistArray[n2];
                String username = list.getUserName();
                if (username != null) {
                    UserTaskGroup user = this.userAdapters.get(username);
                    if (user == null) {
                        user = new UserTaskGroup(username, this.provider);
                        this.userAdapters.put(username, user);
                    }
                    user.add(list);
                }
                if ((date = list.getDate()) != null) {
                    if (date.after(thisMonth)) {
                        month.add(list);
                    } else if (date.after(thisYear)) {
                        year.add(list);
                    } else {
                        earlier.add(list);
                    }
                }
                ++n2;
            }
        }
    }

    private void hookGraphListener() {
        if (this.graph != null) {
            this.graph.addPropertyListener("name", (PropertyChangeListener)this);
            this.graph.addPropertyListener("type", (PropertyChangeListener)this);
        }
    }

    private void unhookGraphListener() {
        if (this.graph != null) {
            this.graph.removePropertyListener("name", (PropertyChangeListener)this);
            this.graph.removePropertyListener("type", (PropertyChangeListener)this);
        }
    }

    public void setInput(Mapping mapping, IP4SubmittedChangelist[] lists) {
        this.unhookGraphListener();
        this.mapping = mapping;
        this.graph = this.mapping != null ? this.mapping.getGraph() : null;
        this.hookGraphListener();
        if (lists == null) {
            lists = new IP4SubmittedChangelist[]{};
        }
        this.lists = lists;
        this.updateHeader(mapping, lists);
        this.updateGroups(mapping, lists);
        this.setInput();
        this.sourceSection.layout();
    }

    public TreeViewer getViewer() {
        return this.sourceViewer;
    }

    public void showLoading() {
        PerforceContentProvider cfr_ignored_0 = (PerforceContentProvider)this.sourceViewer.getContentProvider();
        this.sourceViewer.setInput((Object)new PerforceContentProvider.Loading());
    }

    @Override
    public IIntegrateTaskContainer.Mode getMode() {
        return this.sourceMode;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (P4UIUtils.okToUse((Widget)TaskContainer.this.sourceSection)) {
                    TaskContainer.this.updateHeader(TaskContainer.this.mapping, TaskContainer.this.lists);
                    TaskContainer.this.sourceSection.layout();
                }
            }
        });
    }
}

