/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.views.tasks;

import com.perforce.team.core.P4CoreUtils;
import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.BranchSpecMapping;
import com.perforce.team.core.mergequest.model.DepotPathMapping;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.core.p4java.IP4Branch;
import com.perforce.team.core.p4java.IP4Connection;
import com.perforce.team.core.p4java.IP4Job;
import com.perforce.team.core.p4java.IP4Resource;
import com.perforce.team.core.p4java.IP4SubmittedChangelist;
import com.perforce.team.core.p4java.IP4SubmittedFile;
import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.editor.IBranchGraphEditor;
import com.perforce.team.ui.mergequest.editor.IBranchGraphPage;
import com.perforce.team.ui.mergequest.views.tasks.IntegrateTaskView;
import com.perforce.team.ui.mergequest.views.tasks.IntegrateTaskViewer;
import com.perforce.team.ui.mergequest.views.tasks.Messages;
import com.perforce.team.ui.p4java.actions.EditJobAction;
import com.perforce.team.ui.p4java.actions.IntegrateAction;
import com.perforce.team.ui.p4java.actions.ViewChangelistAction;
import com.perforce.team.ui.submitted.OpenEditorAction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.UIJob;

public class IntegrateTaskPage
extends Page
implements ISelectionChangedListener,
PropertyChangeListener,
ISelectionListener {
    private Composite displayArea;
    private IntegrateTaskViewer viewer;
    private Mapping selectedMapping = null;
    private IBranchGraphEditor editor = null;
    private WorkbenchLabelProvider provider = new WorkbenchLabelProvider();
    private HashSet<IBranchGraphPage> pages = new HashSet();
    private boolean loaded = false;
    private Listener showListener = new Listener(){

        public void handleEvent(Event event) {
            if (!IntegrateTaskPage.this.loaded) {
                IntegrateTaskPage.this.loadCurrentSelection();
            }
        }
    };
    private IPartListener2 partListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (!IntegrateTaskPage.this.loaded && partRef != null && partRef.getPart(false) instanceof IntegrateTaskView) {
                IntegrateTaskPage.this.loadCurrentSelection();
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    };
    private IPageChangedListener pageListener = new IPageChangedListener(){

        public void pageChanged(PageChangedEvent event) {
            IntegrateTaskPage.this.pageChange();
            IntegrateTaskPage.this.updateSelection();
        }
    };

    public IntegrateTaskPage(IBranchGraphEditor editor) {
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        this.displayArea = new Composite(parent, 0);
        this.displayArea.setBackgroundMode(1);
        this.displayArea.setBackground(this.displayArea.getDisplay().getSystemColor(1));
        this.displayArea.addListener(22, this.showListener);
        this.getSite().getPage().addPartListener(this.partListener);
        GridLayout daLayout = new GridLayout(1, true);
        daLayout.marginHeight = 0;
        daLayout.marginWidth = 0;
        this.displayArea.setLayout((Layout)daLayout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewer = new IntegrateTaskViewer(this.editor, this.editor.getProcessor());
        this.viewer.createControl(this.displayArea);
        this.registerMenu(this.viewer.getSourceViewer(), true);
        this.registerMenu(this.viewer.getTargetViewer(), false);
        this.loadCurrentSelection();
    }

    private void loadCurrentSelection() {
        new UIJob(Messages.IntegrateTaskPage_UpdatingTasks){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (P4UIUtils.okToUse((Widget)IntegrateTaskPage.this.displayArea) && IntegrateTaskPage.this.displayArea.isVisible() && !IntegrateTaskPage.this.loaded) {
                    IntegrateTaskPage.this.loaded = true;
                    IBranchGraphPage page = IntegrateTaskPage.this.editor.getActiveGraphPage();
                    if (page != null) {
                        IntegrateTaskPage.this.pageChange();
                        IntegrateTaskPage.this.updateSelection();
                    }
                    IntegrateTaskPage.this.editor.addPageChangedListener(IntegrateTaskPage.this.pageListener);
                    IntegrateTaskPage.this.getSite().getPage().addSelectionListener((ISelectionListener)IntegrateTaskPage.this);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void pageChange() {
        IBranchGraphPage page = this.editor.getActiveGraphPage();
        if (page != null && !this.pages.contains(page)) {
            page.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
            page.getGraph().addPropertyListener((PropertyChangeListener)this);
            this.pages.add(page);
        }
    }

    private void updateSelection() {
        IBranchGraphPage page = this.editor.getActiveGraphPage();
        if (page != null) {
            ISelectionProvider provider = page.getSelectionProvider();
            this.selectionChanged(new SelectionChangedEvent(provider, provider.getSelection()));
        }
    }

    private void registerMenu(final TreeViewer viewer, final boolean reverse) {
        final Action customIntegrate = new Action(Messages.IntegrateTaskPage_IntegrateChangelist, PerforceUIPlugin.getDescriptor((String)"normal/integrate.png")){

            public void run() {
                Object element = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
                if (element instanceof IP4SubmittedChangelist) {
                    IP4SubmittedChangelist changelist = (IP4SubmittedChangelist)element;
                    IP4Connection connection = changelist.getConnection();
                    if (IntegrateTaskPage.this.selectedMapping instanceof BranchSpecMapping) {
                        BranchSpecMapping mapping = (BranchSpecMapping)IntegrateTaskPage.this.selectedMapping;
                        IP4Branch branch = mapping.generateBranch(connection);
                        IntegrateAction action = new IntegrateAction();
                        action.integrateBranch(branch, reverse, changelist);
                    } else if (IntegrateTaskPage.this.selectedMapping instanceof DepotPathMapping) {
                        DepotPathMapping mapping = (DepotPathMapping)IntegrateTaskPage.this.selectedMapping;
                        IntegrateAction action = new IntegrateAction();
                        String source = reverse ? mapping.getTargetPath() : mapping.getSourcePath();
                        String target = reverse ? mapping.getSourcePath() : mapping.getTargetPath();
                        action.integratePaths((IP4Resource)connection, source, target, changelist);
                    }
                }
            }
        };
        MenuManager manager = new MenuManager();
        Menu menu = manager.createContextMenu(viewer.getControl());
        manager.setRemoveAllWhenShown(true);
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu("changelistPage", manager, (ISelectionProvider)viewer);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IContributionItem)new Separator("additions"));
                IContributionItem integrate = manager.find("com.perforce.team.ui.integratechangelist");
                if (integrate != null) {
                    manager.remove(integrate);
                    manager.prependToGroup("perforce.group1", (IAction)customIntegrate);
                }
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object[] objectArray = ((IStructuredSelection)viewer.getSelection()).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object select = objectArray[n2];
                    if (P4CoreUtils.convert((Object)select, IP4SubmittedChangelist.class) != null) {
                        ViewChangelistAction view = new ViewChangelistAction();
                        view.selectionChanged(null, (ISelection)new StructuredSelection(select));
                        view.run(null);
                    } else if (P4CoreUtils.convert((Object)select, IP4SubmittedFile.class) != null) {
                        OpenEditorAction open = new OpenEditorAction();
                        open.selectionChanged(null, (ISelection)new StructuredSelection(select));
                        open.run(null);
                    } else if (P4CoreUtils.convert((Object)select, IP4Job.class) != null) {
                        EditJobAction edit = new EditJobAction();
                        edit.selectionChanged(null, (ISelection)new StructuredSelection(select));
                        edit.doubleClick(null);
                    } else {
                        viewer.setExpandedState(select, !viewer.getExpandedState(select));
                    }
                    ++n2;
                }
            }
        });
    }

    public Control getControl() {
        return this.displayArea;
    }

    public void setFocus() {
        if (P4UIUtils.okToUse((Widget)this.displayArea)) {
            this.displayArea.setFocus();
            if (!this.loaded) {
                this.loadCurrentSelection();
            }
        }
    }

    public void dispose() {
        for (IBranchGraphPage page : this.pages) {
            page.getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
            page.getGraph().removePropertyListener((PropertyChangeListener)this);
        }
        if (P4UIUtils.okToUse((Widget)this.displayArea)) {
            this.displayArea.removeListener(22, this.showListener);
        }
        this.editor.removePageChangedListener(this.pageListener);
        this.viewer.dispose();
        this.getSite().getPage().removeSelectionListener((ISelectionListener)this);
        this.getSite().getPage().removePartListener(this.partListener);
        super.dispose();
        this.provider.dispose();
    }

    private void refreshViewer() {
        if (this.selectedMapping != null) {
            this.viewer.setInput(this.selectedMapping);
        } else {
            this.viewer.setInput(null);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged(null, event.getSelection());
    }

    private void handleRemove(PropertyChangeEvent evt) {
        String id;
        Mapping mapping = this.selectedMapping;
        if (mapping == null) {
            return;
        }
        Object old = evt.getOldValue();
        if (old == null) {
            return;
        }
        if (mapping.equals(old)) {
            this.selectedMapping = null;
            this.asyncRefresh();
        } else if (old instanceof Branch && ((id = ((Branch)old).getId()).equals(mapping.getSourceId()) || id.equals(mapping.getTargetId()))) {
            this.selectedMapping = null;
            this.asyncRefresh();
        }
    }

    private void asyncRefresh() {
        PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (P4UIUtils.okToUse((Widget)IntegrateTaskPage.this.displayArea)) {
                    IntegrateTaskPage.this.refreshViewer();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if ("ELEMENT_REMOVED".equals(property)) {
            this.handleRemove(evt);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object selected;
        Mapping mapping;
        if (!P4UIUtils.okToUse((Widget)this.displayArea)) {
            return;
        }
        if (part != null && !part.equals(this.editor)) {
            return;
        }
        if (selection instanceof IStructuredSelection && (mapping = (Mapping)P4CoreUtils.convert((Object)(selected = ((IStructuredSelection)selection).getFirstElement()), Mapping.class)) != null) {
            this.selectedMapping = mapping;
            this.refreshViewer();
        }
    }
}

