/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.parts;

import com.perforce.team.ui.P4UIUtils;
import com.perforce.team.ui.decorator.OverlayIcon;
import com.perforce.team.ui.mergequest.P4BranchGraphPlugin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;

public class SharedResources {
    private Map<String, Image> images = new HashMap<String, Image>();
    private Map<ImageDescriptor, Image> descriptors = new HashMap<ImageDescriptor, Image>();
    private Map<OverlayIcon, Image> overlays = new HashMap<OverlayIcon, Image>();
    private Map<RGB, Color> colors = new HashMap<RGB, Color>();

    public Image getImage(ImageDescriptor descriptor) {
        Image image = null;
        if (descriptor != null && (image = this.descriptors.get(descriptor)) == null && (image = descriptor.createImage()) != null) {
            this.descriptors.put(descriptor, image);
        }
        return image;
    }

    public Image getImage(String path) {
        ImageDescriptor desc;
        Image image = null;
        if (path != null && (image = this.images.get(path)) == null && (desc = P4BranchGraphPlugin.getImageDescriptor(path)) != null && (image = desc.createImage()) != null) {
            this.images.put(path, image);
        }
        return image;
    }

    public Color getColor(RGB rgb) {
        Color color = null;
        if (rgb != null && (color = this.colors.get(rgb)) == null) {
            color = new Color((Device)P4UIUtils.getDisplay(), rgb);
            this.colors.put(rgb, color);
        }
        return color;
    }

    public Image getOverlay(OverlayIcon icon) {
        Image image = null;
        if (icon != null && (image = this.overlays.get(icon)) == null && (image = icon.createImage()) != null) {
            this.overlays.put(icon, image);
        }
        return image;
    }

    public Color getSystemColor(int id) {
        return P4UIUtils.getDisplay().getSystemColor(id);
    }

    public void dispose() {
        for (Image image : this.images.values()) {
            if (image.isDisposed()) continue;
            image.dispose();
        }
        for (Image image : this.overlays.values()) {
            if (image.isDisposed()) continue;
            image.dispose();
        }
        for (Image image : this.descriptors.values()) {
            if (image.isDisposed()) continue;
            image.dispose();
        }
        for (Color color : this.colors.values()) {
            if (color.isDisposed()) continue;
            color.dispose();
        }
    }
}

