/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.parts;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.IBranchGraphElement;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.PerforceUIPlugin;
import com.perforce.team.ui.mergequest.commands.BranchEditCommand;
import com.perforce.team.ui.mergequest.commands.CommandAction;
import com.perforce.team.ui.mergequest.figures.BranchFigure;
import com.perforce.team.ui.mergequest.figures.theme.FigureThemeHelper;
import com.perforce.team.ui.mergequest.parts.MappingEditPart;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import com.perforce.team.ui.mergequest.parts.ToolTipHelper;
import com.perforce.team.ui.mergequest.policies.BranchConnectPolicy;
import com.perforce.team.ui.mergequest.policies.BranchEditPolicy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.jface.resource.JFaceResources;

public class BranchEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
NodeEditPart {
    private SharedResources images;
    private ToolTipHelper tooltipHelper = null;
    private FigureThemeHelper themeHelper = null;
    private Runnable refreshCallback = new Runnable(){

        @Override
        public void run() {
            BranchEditPart.this.refreshVisuals();
        }
    };

    public BranchEditPart(SharedResources images) {
        this.images = images;
        this.tooltipHelper = new ToolTipHelper(this);
        this.themeHelper = new FigureThemeHelper();
        this.themeHelper.setDefaultBackground(ColorConstants.white);
        this.themeHelper.setDefaultOutline(ColorConstants.darkGray);
        this.themeHelper.setDefaultForeground(ColorConstants.darkGray);
        this.themeHelper.setDefaultFont(JFaceResources.getDialogFont());
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getBranch().addPropertyListener((PropertyChangeListener)this);
            this.tooltipHelper.activate();
            this.themeHelper.activate(this.refreshCallback);
        }
    }

    public Object getAdapter(Class key) {
        if (key == Branch.class || key == IBranchGraphElement.class) {
            return this.getBranch();
        }
        return super.getAdapter(key);
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getBranch().removePropertyListener((PropertyChangeListener)this);
            this.tooltipHelper.deactivate();
            this.themeHelper.deactivate();
            super.deactivate();
        }
    }

    private BranchFigure getBranchFigure() {
        return (BranchFigure)this.getFigure();
    }

    protected IFigure createFigure() {
        Branch branch = this.getBranch();
        BranchFigure figure = new BranchFigure(branch, this.images);
        figure.setOutline(true);
        this.themeHelper.setFigure(figure);
        this.bindTypeTheme();
        return figure;
    }

    private void bindTypeTheme() {
        String type = this.getBranch().getType().toString().toLowerCase(Locale.ENGLISH);
        String suffix = "branch." + type;
        this.themeHelper.setBackgroundKey("com.perforce.team.ui.mergequest.background." + suffix);
        this.themeHelper.setForegroundKey("com.perforce.team.ui.mergequest.foreground." + suffix);
        this.themeHelper.setFontKey("com.perforce.team.ui.mergequest.font." + suffix);
        this.themeHelper.setOutlineKey("com.perforce.team.ui.mergequest.outline." + suffix);
        this.themeHelper.synchronize();
    }

    private Branch getBranch() {
        return (Branch)this.getModel();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new BranchEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new BranchConnectPolicy());
    }

    private int getNewTerminal(Branch source, Branch target, int current) {
        if (target.getY() > source.getY() && current < 3) {
            current += 5;
        } else if (target.getY() < source.getY() && current > 4 && current < 8) {
            current -= 5;
        } else if (target.getX() > source.getX() && current > 7) {
            current -= 5;
        } else if (target.getX() < source.getX() && current > 2 && current < 5) {
            current += 5;
        }
        return current;
    }

    private void refreshAnchors() {
        Mapping mapping;
        Branch branch = this.getBranch();
        Mapping[] mappingArray = branch.getSourceMappings();
        int n = mappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            Branch target;
            mapping = mappingArray[n2];
            if (mapping.getJointCount() == 0 && (target = mapping.getTarget()) != null) {
                mapping.setSourceAnchor(this.getNewTerminal(branch, target, mapping.getSourceAnchor()));
                mapping.setTargetAnchor(this.getNewTerminal(target, branch, mapping.getTargetAnchor()));
            }
            ++n2;
        }
        mappingArray = branch.getTargetMappings();
        n = mappingArray.length;
        n2 = 0;
        while (n2 < n) {
            Branch source;
            mapping = mappingArray[n2];
            if (mapping.getJointCount() == 0 && (source = mapping.getSource()) != null) {
                mapping.setSourceAnchor(this.getNewTerminal(source, branch, mapping.getSourceAnchor()));
                mapping.setTargetAnchor(this.getNewTerminal(branch, source, mapping.getTargetAnchor()));
            }
            ++n2;
        }
    }

    protected void refreshVisuals() {
        if (this.isActive()) {
            if (PerforceUIPlugin.isUIThread()) {
                Branch branch = this.getBranch();
                BranchFigure figure = this.getBranchFigure();
                figure.refresh();
                Dimension preferred = figure.getPreferredSize();
                Rectangle bounds = new Rectangle(branch.getX(), branch.getY(), preferred.width, preferred.height);
                bounds.width = Math.max(branch.getWidth(), bounds.width);
                bounds.height = Math.max(branch.getHeight(), bounds.height);
                branch.setSize(bounds.width, bounds.height);
                ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, (IFigure)figure, (Object)bounds);
                this.refreshAnchors();
            } else {
                PerforceUIPlugin.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        BranchEditPart.this.refreshVisuals();
                    }
                });
            }
        }
    }

    protected List<Mapping> getModelSourceConnections() {
        return Arrays.asList(this.getBranch().getSourceMappings());
    }

    protected List<Mapping> getModelTargetConnections() {
        return Arrays.asList(this.getBranch().getSourceOwnedTargetMappings());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if ("location".equals(property) || "name".equals(property) || "size".equals(property)) {
            this.refreshVisuals();
        } else if ("type".equals(property)) {
            this.bindTypeTheme();
        } else if ("sourceMappings".equals(property) || "targetMappings".equals(property)) {
            this.refreshAnchors();
            this.refreshSourceConnections();
            this.refreshTargetConnections();
        }
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return this.getBranchFigure().getAnchor(((MappingEditPart)connection).getMapping());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return this.getSourceConnectionAnchor(request);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return this.getTargetConnectionAnchor(connection);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point point = new Point(((DropRequest)request).getLocation());
        return this.getBranchFigure().getAnchor(point);
    }

    public void performRequest(Request req) {
        if ("open".equals(req.getType())) {
            CommandAction edit = new CommandAction(new BranchEditCommand(this.getBranch()), this.getViewer());
            edit.run();
        } else {
            super.performRequest(req);
        }
    }
}

