/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.figures;

import com.perforce.team.core.mergequest.model.MappingDescriptor;
import com.perforce.team.ui.mergequest.figures.IOutlineFigure;
import com.perforce.team.ui.mergequest.figures.Messages;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ChangeCountFigure
extends RoundedRectangle
implements IOutlineFigure {
    private Label countLabel;
    private Color outlineColor;
    private SharedResources resources;

    public ChangeCountFigure(SharedResources resources) {
        this.resources = resources;
        this.outlineColor = ColorConstants.white;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        layout.horizontalSpacing = 1;
        this.setLayoutManager((LayoutManager)layout);
        this.setBorder((Border)new MarginBorder(1));
        this.setOpaque(true);
        this.countLabel = new Label();
        this.countLabel.setIconAlignment(16);
        this.countLabel.setIconTextGap(1);
        this.add((IFigure)this.countLabel, new GridData(0x1000000, 0x1000000, true, true));
    }

    public Label getCountLabel() {
        return this.countLabel;
    }

    public void updateChanges(MappingDescriptor.ChangeType type, int count) {
        if (type == null) {
            type = MappingDescriptor.ChangeType.UNKNOWN;
        }
        switch (type) {
            case NO_CHANGES: {
                this.countLabel.setIcon(this.resources.getImage("icons/indicator_no_integration_tasks.png"));
                this.setCount(0);
                break;
            }
            case NO_PERMISSION: {
                this.countLabel.setIcon(this.resources.getImage("icons/no_permission.png"));
                if (count > 0) {
                    this.setCount(count);
                    break;
                }
                this.setCount(Messages.ChangeCountFigure_Unknown);
                break;
            }
            case VISIBLE_CHANGES: {
                this.countLabel.setIcon(this.resources.getImage("icons/indicator_integration_tasks.png"));
                if (count > 0) {
                    this.setCount(count);
                    break;
                }
                this.setCount(Messages.ChangeCountFigure_OneOrMore);
                break;
            }
            case UNKNOWN: {
                this.setVisible(false);
                break;
            }
        }
    }

    public void setLabelIcon(Image image) {
        this.countLabel.setIcon(image);
    }

    public void setCount(int count) {
        this.setCount(Integer.toString(count));
    }

    public void setCount(String count) {
        this.countLabel.setText(count);
    }

    protected void outlineShape(Graphics graphics) {
        if (this.outlineColor != null) {
            graphics.setForegroundColor(this.outlineColor);
        }
        super.outlineShape(graphics);
    }

    @Override
    public void setOutlineColor(Color color) {
        this.outlineColor = color;
        this.repaint();
    }

    @Override
    public Color getOutlineColor() {
        return this.outlineColor;
    }
}

