/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.team.ui.mergequest.figures;

import com.perforce.team.core.mergequest.model.Branch;
import com.perforce.team.core.mergequest.model.Mapping;
import com.perforce.team.ui.mergequest.BranchWorkbenchAdapter;
import com.perforce.team.ui.mergequest.figures.BranchBorder;
import com.perforce.team.ui.mergequest.figures.IOutlineFigure;
import com.perforce.team.ui.mergequest.figures.MappingConnectionAnchor;
import com.perforce.team.ui.mergequest.parts.SharedResources;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.swt.graphics.Color;

public class BranchFigure
extends RoundedRectangle
implements IOutlineFigure,
HandleBounds {
    private BranchWorkbenchAdapter adapter;
    private SharedResources resources;
    private Branch branch;
    private Label label;
    private Color outlineColor;
    private List<MappingConnectionAnchor> anchors = new ArrayList<MappingConnectionAnchor>();

    public BranchFigure(Branch branch, SharedResources resources) {
        this.adapter = new BranchWorkbenchAdapter();
        this.resources = resources;
        this.branch = branch;
        this.setBorder((Border)new BranchBorder());
        this.setOpaque(true);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        this.setLayoutManager((LayoutManager)layout);
        this.label = new Label();
        this.label.setTextPlacement(16);
        this.label.setTextAlignment(2);
        this.label.setIconAlignment(2);
        this.label.setBorder(null);
        this.add((IFigure)this.label, new GridData(0x1000000, 0x1000000, true, true));
        int count = 0;
        while (count < 3) {
            this.anchors.add(new MappingConnectionAnchor(this, count, 128));
            ++count;
        }
        int i = 0;
        while (i < 2) {
            this.anchors.add(new MappingConnectionAnchor(this, count, 131072));
            ++count;
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.anchors.add(new MappingConnectionAnchor(this, count, 1024));
            ++count;
            ++i;
        }
        i = 0;
        while (i < 2) {
            this.anchors.add(new MappingConnectionAnchor(this, count, 16384));
            ++count;
            ++i;
        }
        this.refresh();
    }

    public void showAnchors(boolean show) {
        if (((BranchBorder)this.getBorder()).showAnchors(show)) {
            this.repaint();
        }
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        this.refreshAnchors();
        super.validate();
    }

    public MappingConnectionAnchor getAnchor(Mapping mapping) {
        MappingConnectionAnchor anchor = null;
        if (this.branch.equals((Object)mapping.getSource())) {
            anchor = this.anchors.get(mapping.getSourceAnchor());
        } else if (this.branch.equals((Object)mapping.getTarget())) {
            anchor = this.anchors.get(mapping.getTargetAnchor());
        }
        return anchor;
    }

    public MappingConnectionAnchor getAnchor(Point point) {
        MappingConnectionAnchor closest = null;
        long minDistance = Long.MAX_VALUE;
        for (MappingConnectionAnchor anchor : this.anchors) {
            Point location = anchor.getLocation(null);
            long distance = point.getDistance2(location);
            if (distance >= minDistance) continue;
            minDistance = distance;
            closest = anchor;
        }
        return closest;
    }

    private void refreshAnchors() {
        Dimension size = this.getSize();
        int xSpacing = size.width / 4;
        int ySpacing = size.height / 3;
        int count = 0;
        int i = 1;
        while (i < 4) {
            this.anchors.get(count).setXOffset(i * xSpacing + 1).setYOffset(0);
            ++i;
            ++count;
        }
        i = 1;
        while (i < 3) {
            this.anchors.get(count).setYOffset(i * ySpacing + 1).setXOffset(size.width - 1);
            ++i;
            ++count;
        }
        i = 1;
        while (i < 4) {
            this.anchors.get(count).setXOffset(i * xSpacing + 1).setYOffset(size.height - 1);
            ++i;
            ++count;
        }
        i = 1;
        while (i < 3) {
            this.anchors.get(count).setYOffset(i * ySpacing + 1).setXOffset(0);
            ++i;
            ++count;
        }
    }

    protected void outlineShape(Graphics graphics) {
        if (this.getBorder() == null) {
            super.outlineShape(graphics);
        }
    }

    protected void fillShape(Graphics graphics) {
        Rectangle fillBounds = new Rectangle(this.getBounds()).crop(new Insets(2));
        graphics.fillRoundRectangle(fillBounds, this.corner.width, this.corner.height);
    }

    public void refresh() {
        this.label.setText(this.adapter.getLabel(this.branch));
        this.label.setIcon(this.resources.getImage(this.adapter.getImageDescriptor(this.branch)));
        this.refreshAnchors();
    }

    @Override
    public void setOutlineColor(Color color) {
        this.outlineColor = color;
        this.repaint();
    }

    @Override
    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public Rectangle getHandleBounds() {
        return this.getBounds().getCropped(new Insets(1));
    }
}

